/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.gear.bloodcrust;

import java.util.function.Consumer;
import net.jitl.common.capability.player.BloodcrustAbility;
import net.jitl.common.items.gear.IAbility;
import net.jitl.core.helper.TooltipFiller;
import net.jitl.core.init.internal.JDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class BloodcrustToolAbility
implements IAbility {
    @Override
    public void breakBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, Player entity) {
        BloodcrustAbility bloodcrust = (BloodcrustAbility)stack.get(JDataComponents.BLOODCRUST.get());
        if (stack.has(JDataComponents.BLOODCRUST)) {
            if (bloodcrust.fire_boost() >= 1.0) {
                stack.set(JDataComponents.BLOODCRUST, (Object)new BloodcrustAbility(bloodcrust.fire_boost() - 1.0));
            }
            System.out.println(bloodcrust.fire_boost());
        }
    }

    @Override
    public void playerInteract(PlayerInteractEvent event) {
        if (event.getLevel().getBlockState(event.getPos()).is(Blocks.FIRE)) {
            event.getItemStack().set(JDataComponents.BLOODCRUST, (Object)new BloodcrustAbility(16.0));
            System.out.println("boost");
        }
    }

    @Override
    public float blockBreakSpeed(ItemStack stack, BlockState state, float original) {
        if (stack.has(JDataComponents.BLOODCRUST) && this.isCorrectTool(stack, state)) {
            original += (float)((BloodcrustAbility)stack.get(JDataComponents.BLOODCRUST)).fire_boost();
        }
        return original;
    }

    @Override
    public void fillTooltips(ItemStack stack, Consumer<Component> tooltip) {
        TooltipFiller filler = new TooltipFiller(tooltip, "bloodcrust_tool");
        filler.addOverview();
        filler.addDrawback();
        filler.addBreak();
        if (stack.has(JDataComponents.BLOODCRUST.get())) {
            filler.addValue(((BloodcrustAbility)stack.get(JDataComponents.BLOODCRUST)).fire_boost());
        }
    }
}

