/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.depths;

import java.util.function.Consumer;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;

public class JDripstoneUtils {
    protected static double getDripstoneHeight(double radius, double maxRadius, double scale, double minRadius) {
        if (radius < minRadius) {
            radius = minRadius;
        }
        double d0 = 0.384;
        double d1 = radius / maxRadius * 0.384;
        double d2 = 0.75 * Math.pow(d1, 1.3333333333333333);
        double d3 = Math.pow(d1, 0.6666666666666666);
        double d4 = 0.3333333333333333 * Math.log(d1);
        double d5 = scale * (d2 - d3 - d4);
        d5 = Math.max(d5, 0.0);
        return d5 / 0.384 * maxRadius;
    }

    protected static boolean isCircleMostlyEmbeddedInStone(WorldGenLevel level, BlockPos pos, int radius) {
        if (JDripstoneUtils.isEmptyOrWaterOrLava((LevelAccessor)level, pos)) {
            return false;
        }
        float f = 6.0f;
        float f1 = 6.0f / (float)radius;
        for (float f2 = 0.0f; f2 < (float)Math.PI * 2; f2 += f1) {
            int j;
            int i = (int)(Mth.cos((float)f2) * (float)radius);
            if (!JDripstoneUtils.isEmptyOrWaterOrLava((LevelAccessor)level, pos.offset(i, 0, j = (int)(Mth.sin((float)f2) * (float)radius)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isEmptyOrWater(LevelAccessor level, BlockPos pos) {
        return level.isStateAtPosition(pos, JDripstoneUtils::isEmptyOrWater);
    }

    protected static boolean isEmptyOrWaterOrLava(LevelAccessor level, BlockPos pos) {
        return level.isStateAtPosition(pos, JDripstoneUtils::isEmptyOrWaterOrLava);
    }

    protected static void buildBaseToTipColumn(Block pointed, Direction direction, int height, boolean mergeTip, Consumer<BlockState> blockSetter) {
        if (height >= 3) {
            blockSetter.accept(JDripstoneUtils.createPointedDripstone(pointed, direction, DripstoneThickness.BASE));
            for (int i = 0; i < height - 3; ++i) {
                blockSetter.accept(JDripstoneUtils.createPointedDripstone(pointed, direction, DripstoneThickness.MIDDLE));
            }
        }
        if (height >= 2) {
            blockSetter.accept(JDripstoneUtils.createPointedDripstone(pointed, direction, DripstoneThickness.FRUSTUM));
        }
        if (height >= 1) {
            blockSetter.accept(JDripstoneUtils.createPointedDripstone(pointed, direction, mergeTip ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    protected static void growPointedDripstone(Block pointed, LevelAccessor level, BlockPos pos, Direction direction, int height, boolean mergeTip) {
        if (JDripstoneUtils.isDripstoneBase(level.getBlockState(pos.relative(direction.getOpposite())))) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
            JDripstoneUtils.buildBaseToTipColumn(pointed, direction, height, mergeTip, p_313662_ -> {
                if (p_313662_.is(pointed)) {
                    p_313662_ = (BlockState)p_313662_.setValue((Property)PointedDripstoneBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.isWaterAt((BlockPos)blockpos$mutableblockpos)));
                }
                level.setBlock((BlockPos)blockpos$mutableblockpos, p_313662_, 2);
                blockpos$mutableblockpos.move(direction);
            });
        }
    }

    protected static boolean placeDripstoneBlockIfPossible(Block dripstone, LevelAccessor level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.is(JBlocks.DEPTHS_GRASS) || blockstate.is(JBlocks.DEPTHS_STONE) || blockstate.is(JBlocks.DEPTHS_DIRT)) {
            level.setBlock(pos, dripstone.defaultBlockState(), 2);
            return true;
        }
        return false;
    }

    private static BlockState createPointedDripstone(Block pointed, Direction direction, DripstoneThickness dripstoneThickness) {
        return (BlockState)((BlockState)pointed.defaultBlockState().setValue((Property)PointedDripstoneBlock.TIP_DIRECTION, (Comparable)direction)).setValue((Property)PointedDripstoneBlock.THICKNESS, (Comparable)dripstoneThickness);
    }

    public static boolean isDripstoneBaseOrLava(BlockState state) {
        return JDripstoneUtils.isDripstoneBase(state) || state.is(Blocks.LAVA);
    }

    public static boolean isDripstoneBase(BlockState state) {
        return state.is(JBlocks.CRYSTALLIZED_DRIPSTONE) || state.is(JBlocks.DEPTHS_DRIPSTONE) || state.is(JBlocks.DEPTHS_GRASS) || state.is(JBlocks.DEPTHS_STONE) || state.is(JBlocks.DEPTHS_DIRT);
    }

    public static boolean isEmptyOrWater(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER);
    }

    public static boolean isNeitherEmptyNorWater(BlockState state) {
        return !state.isAir() && !state.is(Blocks.WATER);
    }

    public static boolean isEmptyOrWaterOrLava(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER) || state.is(Blocks.LAVA);
    }
}

