/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.nether;

import com.mojang.serialization.Codec;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SmithstoneFeature
extends Feature<NoneFeatureConfiguration> {
    public SmithstoneFeature(Codec<NoneFeatureConfiguration> c) {
        super(c);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos blockpos = context.origin();
        RandomSource randomsource = context.random();
        if (!level.isEmptyBlock(blockpos)) {
            return false;
        }
        BlockState blockstate = level.getBlockState(blockpos.above());
        if (!(blockstate.is(Blocks.NETHERRACK) || blockstate.is(Blocks.BASALT) || blockstate.is(Blocks.BLACKSTONE))) {
            return false;
        }
        level.setBlock(blockpos, ((Block)JBlocks.SMITHSTONE_BLOCK.get()).defaultBlockState(), 2);
        for (int i = 0; i < 1500; ++i) {
            BlockPos blockpos1 = blockpos.offset(randomsource.nextInt(8) - randomsource.nextInt(8), -randomsource.nextInt(12), randomsource.nextInt(8) - randomsource.nextInt(8));
            if (!level.getBlockState(blockpos1).isAir()) continue;
            int j = 0;
            for (Direction direction : Direction.values()) {
                if (level.getBlockState(blockpos1.relative(direction)).is((Block)JBlocks.SMITHSTONE_BLOCK.get())) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            level.setBlock(blockpos1, ((Block)JBlocks.SMITHSTONE_BLOCK.get()).defaultBlockState(), 2);
        }
        return true;
    }
}

