/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.data.BasicFileGenerator;
import net.jitl.core.init.internal.JBlocks;

public class JBlockBushGenerator
extends BasicFileGenerator {
    protected BufferedWriter blockModelWriter0;
    protected BufferedWriter blockModelWriter1;
    protected BufferedWriter blockModelWriter2;
    protected BufferedWriter blockModelWriter3;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.bushBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir0 = "../src/main/resources/assets/jitl/models/block/" + name + "_0.json";
            String blockModelDir1 = "../src/main/resources/assets/jitl/models/block/" + name + "_1.json";
            String blockModelDir2 = "../src/main/resources/assets/jitl/models/block/" + name + "_2.json";
            String blockModelDir3 = "../src/main/resources/assets/jitl/models/block/" + name + "_3.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel0 = new File(blockModelDir0);
            File blockModel1 = new File(blockModelDir1);
            File blockModel2 = new File(blockModelDir2);
            File blockModel3 = new File(blockModelDir3);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel0.exists()) {
                    blockModel0.delete();
                }
                blockModel0.createNewFile();
                this.blockModelWriter0 = new BufferedWriter(new FileWriter(blockModel0));
                if (blockModel1.exists()) {
                    blockModel1.delete();
                }
                blockModel1.createNewFile();
                this.blockModelWriter1 = new BufferedWriter(new FileWriter(blockModel1));
                if (blockModel2.exists()) {
                    blockModel2.delete();
                }
                blockModel2.createNewFile();
                this.blockModelWriter2 = new BufferedWriter(new FileWriter(blockModel2));
                if (blockModel3.exists()) {
                    blockModel3.delete();
                }
                blockModel3.createNewFile();
                this.blockModelWriter3 = new BufferedWriter(new FileWriter(blockModel3));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name, 4);
            this.getBlockstate("jitl", name, 4);
            this.generateBasicFile(true, name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"minecraft:item/generated\",");
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("    \"layer0\": \"" + modID + ":block/" + name + "_3\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name, int maxStages) {
        for (int i = 0; i < maxStages; ++i) {
            this.writeToBlockModelFile(i, "{");
            this.writeToBlockModelFile(i, "  \"parent\": \"minecraft:block/cross\",");
            this.writeToBlockModelFile(i, "  \"textures\": {");
            this.writeToBlockModelFile(i, "    \"cross\": \"" + modID + ":block/" + name + "_" + i + "\"");
            this.writeToBlockModelFile(i, "  }");
            this.writeToBlockModelFile(i, "}");
        }
    }

    public void getBlockstate(String modID, String name, int maxStages) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        int j = 0;
        for (int i = 0; i < maxStages; ++i) {
            String end = ++j == maxStages ? "}" : "},";
            this.writeToBlockstateFile("   \"age=" + i + "\": {");
            this.writeToBlockstateFile("       \"model\": \"" + modID + ":block/" + name + "_" + i + "\"");
            this.writeToBlockstateFile("    " + end);
        }
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter0.close();
            this.blockModelWriter1.close();
            this.blockModelWriter2.close();
            this.blockModelWriter3.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(int writerNumber, String text) {
        BufferedWriter writer = this.blockModelWriter0;
        try {
            if (writerNumber == 0) {
                writer = this.blockModelWriter0;
            }
            if (writerNumber == 1) {
                writer = this.blockModelWriter1;
            }
            if (writerNumber == 2) {
                writer = this.blockModelWriter2;
            }
            if (writerNumber == 3) {
                writer = this.blockModelWriter3;
            }
            writer.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

