/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.data.BasicFileGenerator;
import net.jitl.core.init.internal.JBlocks;

public class JBlockDoublePlantGenerator
extends BasicFileGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockTopModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.doublePlantBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_bottom.json";
            String blockTopModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_top.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockTopModel = new File(blockTopModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockTopModel.exists()) {
                    blockModel.delete();
                }
                blockTopModel.createNewFile();
                this.blockTopModelWriter = new BufferedWriter(new FileWriter(blockTopModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.generateBasicFile(true, name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"minecraft:item/generated\",");
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("    \"layer0\": \"" + modID + ":block/" + name + "_top\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile("{");
        this.writeToBlockModelFile("  \"parent\": \"minecraft:block/cross\",");
        this.writeToBlockModelFile("  \"textures\": {");
        this.writeToBlockModelFile("    \"cross\": \"" + modID + ":block/" + name + "_bottom\"");
        this.writeToBlockModelFile("  }");
        this.writeToBlockModelFile("}");
        this.writeToBlockTopModelFile("{");
        this.writeToBlockTopModelFile("  \"parent\": \"minecraft:block/cross\",");
        this.writeToBlockTopModelFile("  \"textures\": {");
        this.writeToBlockTopModelFile("    \"cross\": \"" + modID + ":block/" + name + "_top\"");
        this.writeToBlockTopModelFile("  }");
        this.writeToBlockTopModelFile("}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("  \"half=lower\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_bottom\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("  \"half=upper\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_top\"");
        this.writeToBlockstateFile("    }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockTopModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(String text) {
        try {
            this.blockModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockTopModelFile(String text) {
        try {
            this.blockTopModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

