/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.data.BasicFileGenerator;
import net.jitl.core.init.internal.JBlocks;

public class JBlockFarmGenerator
extends BasicFileGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockMoistModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.farmlandBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockMoistModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_moist.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockMoistModel = new File(blockMoistModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockMoistModel.exists()) {
                    blockMoistModel.delete();
                }
                blockMoistModel.createNewFile();
                this.blockMoistModelWriter = new BufferedWriter(new FileWriter(blockMoistModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockHorModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.generateBasicFile(name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile("{");
        this.writeToBlockModelFile("  \"parent\": \"minecraft:block/template_farmland\",");
        this.writeToBlockModelFile("  \"textures\": {");
        this.writeToBlockModelFile("    \"dirt\": \"" + modID + ":block/" + name + "_dirt\",");
        this.writeToBlockModelFile("    \"top\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile("  }");
        this.writeToBlockModelFile("}");
    }

    public void getBlockHorModel(String modID, String name) {
        this.writeToBlockMoistModelFile("{");
        this.writeToBlockMoistModelFile("  \"parent\": \"minecraft:block/template_farmland\",");
        this.writeToBlockMoistModelFile("  \"textures\": {");
        this.writeToBlockMoistModelFile("    \"dirt\": \"" + modID + ":block/" + name + "_dirt\",");
        this.writeToBlockMoistModelFile("    \"top\": \"" + modID + ":block/" + name + "_moist\"");
        this.writeToBlockMoistModelFile("  }");
        this.writeToBlockMoistModelFile("}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"moisture=0\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"moisture=1\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"moisture=2\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"moisture=3\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"moisture=4\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"moisture=5\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"moisture=6\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"moisture=7\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_moist\"");
        this.writeToBlockstateFile("    }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockMoistModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockMoistModelFile(String text) {
        try {
            this.blockMoistModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(String text) {
        try {
            this.blockModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

