/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.data.BasicFileGenerator;
import net.jitl.core.init.internal.JBlocks;

public class JBlockMushroomGenerator
extends BasicFileGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockInsideModelWriter;
    protected BufferedWriter blockInventoryModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.mushroomBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockInsideModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_inside.json";
            String blockInventoryModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_inventory.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockInsideModel = new File(blockInsideModelDir);
            File blockInventoryModel = new File(blockInventoryModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockInsideModel.exists()) {
                    blockInsideModel.delete();
                }
                blockInsideModel.createNewFile();
                this.blockInsideModelWriter = new BufferedWriter(new FileWriter(blockInsideModel));
                if (blockInventoryModel.exists()) {
                    blockInventoryModel.delete();
                }
                blockInventoryModel.createNewFile();
                this.blockInventoryModelWriter = new BufferedWriter(new FileWriter(blockInventoryModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockInventoryModel("jitl", name);
            this.getBlockInsideModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.generateBasicFile(name, "_inventory");
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "_inventory\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile("{");
        this.writeToBlockModelFile("  \"parent\": \"minecraft:block/template_single_face\",");
        this.writeToBlockModelFile("  \"textures\": {");
        this.writeToBlockModelFile("    \"texture\": \"" + modID + ":block/" + name + "_skin\"");
        this.writeToBlockModelFile("  }");
        this.writeToBlockModelFile("}");
    }

    public void getBlockInventoryModel(String modID, String name) {
        this.writeToBlockInventoryModelFile("{");
        this.writeToBlockInventoryModelFile("  \"parent\": \"minecraft:block/cube_all\",");
        this.writeToBlockInventoryModelFile("  \"textures\": {");
        this.writeToBlockInventoryModelFile("    \"all\": \"" + modID + ":block/" + name + "_skin\"");
        this.writeToBlockInventoryModelFile("  }");
        this.writeToBlockInventoryModelFile("}");
    }

    public void getBlockInsideModel(String modID, String name) {
        this.writeToBlockInsideModelFile("{");
        this.writeToBlockInsideModelFile("  \"parent\": \"minecraft:block/template_single_face\",");
        this.writeToBlockInsideModelFile("  \"textures\": {");
        this.writeToBlockInsideModelFile("    \"texture\": \"" + modID + ":block/" + name + "_inside\"");
        this.writeToBlockInsideModelFile("  }");
        this.writeToBlockInsideModelFile("}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"multipart\": [");
        this.writeToBlockstateFile("    {");
        this.writeToBlockstateFile("      \"apply\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("      \"when\": {");
        this.writeToBlockstateFile("        \"north\": \"true\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    {");
        this.writeToBlockstateFile("      \"apply\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("        \"uvlock\": true,");
        this.writeToBlockstateFile("        \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("      \"when\": {");
        this.writeToBlockstateFile("        \"east\": \"true\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    {");
        this.writeToBlockstateFile("      \"apply\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("        \"uvlock\": true,");
        this.writeToBlockstateFile("        \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("      \"when\": {");
        this.writeToBlockstateFile("        \"south\": \"true\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    {");
        this.writeToBlockstateFile("      \"apply\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("        \"uvlock\": true,");
        this.writeToBlockstateFile("        \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("      \"when\": {");
        this.writeToBlockstateFile("        \"west\": \"true\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    {");
        this.writeToBlockstateFile("      \"apply\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("        \"uvlock\": true,");
        this.writeToBlockstateFile("        \"x\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("      \"when\": {");
        this.writeToBlockstateFile("        \"up\": \"true\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    {");
        this.writeToBlockstateFile("      \"apply\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("        \"uvlock\": true,");
        this.writeToBlockstateFile("        \"x\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("      \"when\": {");
        this.writeToBlockstateFile("        \"down\": \"true\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    {");
        this.writeToBlockstateFile("      \"apply\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inside\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("      \"when\": {");
        this.writeToBlockstateFile("        \"north\": \"false\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    {");
        this.writeToBlockstateFile("      \"apply\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inside\",");
        this.writeToBlockstateFile("        \"uvlock\": true,");
        this.writeToBlockstateFile("        \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("      \"when\": {");
        this.writeToBlockstateFile("        \"east\": \"false\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    {");
        this.writeToBlockstateFile("      \"apply\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inside\",");
        this.writeToBlockstateFile("        \"uvlock\": true,");
        this.writeToBlockstateFile("        \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("      \"when\": {");
        this.writeToBlockstateFile("        \"south\": \"false\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    {");
        this.writeToBlockstateFile("      \"apply\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inside\",");
        this.writeToBlockstateFile("        \"uvlock\": true,");
        this.writeToBlockstateFile("        \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("      \"when\": {");
        this.writeToBlockstateFile("        \"west\": \"false\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    {");
        this.writeToBlockstateFile("      \"apply\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inside\",");
        this.writeToBlockstateFile("        \"uvlock\": true,");
        this.writeToBlockstateFile("        \"x\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("      \"when\": {");
        this.writeToBlockstateFile("        \"up\": \"false\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    {");
        this.writeToBlockstateFile("      \"apply\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inside\",");
        this.writeToBlockstateFile("        \"uvlock\": true,");
        this.writeToBlockstateFile("        \"x\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("      \"when\": {");
        this.writeToBlockstateFile("        \"down\": \"false\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("    }");
        this.writeToBlockstateFile("  ]");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockInsideModelWriter.close();
            this.blockInventoryModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockInsideModelFile(String text) {
        try {
            this.blockInsideModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(String text) {
        try {
            this.blockModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockInventoryModelFile(String text) {
        try {
            this.blockInventoryModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

