/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.data.BasicFileGenerator;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JBlocks;

public class JBlockPressurePlateGenerator
extends BasicFileGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockPressedModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.pressurePlateBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockPressedModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_down.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockPressedModel = new File(blockPressedModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockPressedModel.exists()) {
                    blockPressedModel.delete();
                }
                blockPressedModel.createNewFile();
                this.blockPressedModelWriter = new BufferedWriter(new FileWriter(blockPressedModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.generateBasicFile(name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockModelWriter, "{");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"parent\": \"minecraft:block/pressure_plate_up\",");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"texture\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockModelWriter, "  }");
        this.writeToBlockModelFile(this.blockModelWriter, "}");
        this.writeToBlockModelFile(this.blockPressedModelWriter, "{");
        this.writeToBlockModelFile(this.blockPressedModelWriter, "  \"parent\": \"minecraft:block/pressure_plate_down\",");
        this.writeToBlockModelFile(this.blockPressedModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockPressedModelWriter, "    \"texture\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockPressedModelWriter, "  }");
        this.writeToBlockModelFile(this.blockPressedModelWriter, "}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"powered=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"powered=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_down\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockPressedModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(BufferedWriter writer, String text) {
        try {
            writer.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

