/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.data.BasicFileGenerator;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JBlocks;

public class JBlockStairsGenerator
extends BasicFileGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockInnerModelWriter;
    protected BufferedWriter blockOuterModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.stairsBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockInnerModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_inner.json";
            String blockOuterModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_outer.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockInnerModel = new File(blockInnerModelDir);
            File blockOuterModel = new File(blockOuterModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockInnerModel.exists()) {
                    blockInnerModel.delete();
                }
                blockInnerModel.createNewFile();
                this.blockInnerModelWriter = new BufferedWriter(new FileWriter(blockInnerModel));
                if (blockOuterModel.exists()) {
                    blockOuterModel.delete();
                }
                blockOuterModel.createNewFile();
                this.blockOuterModelWriter = new BufferedWriter(new FileWriter(blockOuterModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.generateBasicFile(name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockModelWriter, "{");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"parent\": \"minecraft:block/stairs\",");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"bottom\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\",");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"side\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\",");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"top\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockModelWriter, "  }");
        this.writeToBlockModelFile(this.blockModelWriter, "}");
        this.writeToBlockModelFile(this.blockInnerModelWriter, "{");
        this.writeToBlockModelFile(this.blockInnerModelWriter, "  \"parent\": \"minecraft:block/inner_stairs\",");
        this.writeToBlockModelFile(this.blockInnerModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockInnerModelWriter, "    \"bottom\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\",");
        this.writeToBlockModelFile(this.blockInnerModelWriter, "    \"side\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\",");
        this.writeToBlockModelFile(this.blockInnerModelWriter, "    \"top\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockInnerModelWriter, "  }");
        this.writeToBlockModelFile(this.blockInnerModelWriter, "}");
        this.writeToBlockModelFile(this.blockOuterModelWriter, "{");
        this.writeToBlockModelFile(this.blockOuterModelWriter, "  \"parent\": \"minecraft:block/outer_stairs\",");
        this.writeToBlockModelFile(this.blockOuterModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockOuterModelWriter, "    \"bottom\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\",");
        this.writeToBlockModelFile(this.blockOuterModelWriter, "    \"side\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\",");
        this.writeToBlockModelFile(this.blockOuterModelWriter, "    \"top\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockOuterModelWriter, "  }");
        this.writeToBlockModelFile(this.blockOuterModelWriter, "}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"facing=east,half=bottom,shape=inner_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,half=bottom,shape=inner_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,half=bottom,shape=outer_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,half=bottom,shape=outer_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,half=bottom,shape=straight\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,half=top,shape=inner_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,half=top,shape=inner_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,half=top,shape=outer_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,half=top,shape=outer_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,half=top,shape=straight\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=bottom,shape=inner_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=bottom,shape=inner_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=bottom,shape=outer_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=bottom,shape=outer_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=bottom,shape=straight\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=top,shape=inner_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=top,shape=inner_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=top,shape=outer_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=top,shape=outer_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=top,shape=straight\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=bottom,shape=inner_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=bottom,shape=inner_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=bottom,shape=outer_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=bottom,shape=outer_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=bottom,shape=straight\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=top,shape=inner_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=top,shape=inner_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=top,shape=outer_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=top,shape=outer_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=top,shape=straight\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=bottom,shape=inner_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=bottom,shape=inner_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=bottom,shape=outer_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=bottom,shape=outer_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=bottom,shape=straight\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=top,shape=inner_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=top,shape=inner_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_inner\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=top,shape=outer_left\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=top,shape=outer_right\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_outer\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=top,shape=straight\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockInnerModelWriter.close();
            this.blockOuterModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(BufferedWriter writer, String text) {
        try {
            writer.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

