/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.data.BasicFileGenerator;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JBlocks;

public class JBlockWallGenerator
extends BasicFileGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockPostModelWriter;
    protected BufferedWriter blockSideModelWriter;
    protected BufferedWriter blockSideTallModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.wallBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_inventory.json";
            String blockPostModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_post.json";
            String blockSideModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_side.json";
            String blockSideTallModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_side_tall.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockPostModel = new File(blockPostModelDir);
            File blockSideModel = new File(blockSideModelDir);
            File blockSideTallModel = new File(blockSideTallModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockPostModel.exists()) {
                    blockPostModel.delete();
                }
                blockPostModel.createNewFile();
                this.blockPostModelWriter = new BufferedWriter(new FileWriter(blockPostModel));
                if (blockSideModel.exists()) {
                    blockSideModel.delete();
                }
                blockSideModel.createNewFile();
                this.blockSideModelWriter = new BufferedWriter(new FileWriter(blockSideModel));
                if (blockSideTallModel.exists()) {
                    blockSideTallModel.delete();
                }
                blockSideTallModel.createNewFile();
                this.blockSideTallModelWriter = new BufferedWriter(new FileWriter(blockSideTallModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.generateBasicFile(name, "_inventory");
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "_inventory\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockModelWriter, "{");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"parent\": \"minecraft:block/wall_inventory\",");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"wall\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockModelWriter, "  }");
        this.writeToBlockModelFile(this.blockModelWriter, "}");
        this.writeToBlockModelFile(this.blockPostModelWriter, "{");
        this.writeToBlockModelFile(this.blockPostModelWriter, "  \"parent\": \"minecraft:block/template_wall_post\",");
        this.writeToBlockModelFile(this.blockPostModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockPostModelWriter, "    \"wall\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockPostModelWriter, "  }");
        this.writeToBlockModelFile(this.blockPostModelWriter, "}");
        this.writeToBlockModelFile(this.blockSideModelWriter, "{");
        this.writeToBlockModelFile(this.blockSideModelWriter, "  \"parent\": \"minecraft:block/template_wall_side\",");
        this.writeToBlockModelFile(this.blockSideModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockSideModelWriter, "    \"wall\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockSideModelWriter, "  }");
        this.writeToBlockModelFile(this.blockSideModelWriter, "}");
        this.writeToBlockModelFile(this.blockSideTallModelWriter, "{");
        this.writeToBlockModelFile(this.blockSideTallModelWriter, "  \"parent\": \"minecraft:block/template_wall_side_tall\",");
        this.writeToBlockModelFile(this.blockSideTallModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockSideTallModelWriter, "    \"wall\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockSideTallModelWriter, "  }");
        this.writeToBlockModelFile(this.blockSideTallModelWriter, "}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"multipart\": [");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_post\"");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"up\": \"true\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_side\",");
        this.writeToBlockstateFile("            \"uvlock\": true");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"north\": \"low\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_side\",");
        this.writeToBlockstateFile("            \"uvlock\": true,");
        this.writeToBlockstateFile("            \"y\": 90");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"east\": \"low\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_side\",");
        this.writeToBlockstateFile("            \"uvlock\": true,");
        this.writeToBlockstateFile("            \"y\": 180");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"south\": \"low\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_side\",");
        this.writeToBlockstateFile("            \"uvlock\": true,");
        this.writeToBlockstateFile("            \"y\": 270");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"west\": \"low\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_side_tall\",");
        this.writeToBlockstateFile("            \"uvlock\": true");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"north\": \"tall\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_side_tall\",");
        this.writeToBlockstateFile("            \"uvlock\": true,");
        this.writeToBlockstateFile("            \"y\": 90");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"east\": \"tall\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_side_tall\",");
        this.writeToBlockstateFile("            \"uvlock\": true,");
        this.writeToBlockstateFile("            \"y\": 180");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"south\": \"tall\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_side_tall\",");
        this.writeToBlockstateFile("            \"uvlock\": true,");
        this.writeToBlockstateFile("            \"y\": 270");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"west\": \"tall\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     }");
        this.writeToBlockstateFile("  ]");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockPostModelWriter.close();
            this.blockSideModelWriter.close();
            this.blockSideTallModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(BufferedWriter writer, String text) {
        try {
            writer.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

