/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.world_gen.placed_features;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.jitl.core.init.JITL;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class JPlacedFeature {
    public static List<PlacementModifier> orePlacement(PlacementModifier countPlacement, PlacementModifier heightRange) {
        return List.of(countPlacement, InSquarePlacement.spread(), heightRange, BiomeFilter.biome());
    }

    public static List<PlacementModifier> patch(int count, int chance, PlacementModifier heightRange) {
        return List.of(CountPlacement.of((int)count), InSquarePlacement.spread(), heightRange, RarityFilter.onAverageOnceEvery((int)chance), BiomeFilter.biome());
    }

    public static List<PlacementModifier> patch(int count, PlacementModifier heightRange) {
        return List.of(CountPlacement.of((int)count), InSquarePlacement.spread(), heightRange, BiomeFilter.biome());
    }

    public static List<PlacementModifier> patch(int count, PlacementModifier heightRange, boolean square) {
        return List.of(CountPlacement.of((int)count), heightRange, BiomeFilter.biome());
    }

    public static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier heightRange) {
        return JPlacedFeature.orePlacement((PlacementModifier)CountPlacement.of((int)count), heightRange);
    }

    public static List<PlacementModifier> rareOrePlacement(int chance, PlacementModifier heightRange) {
        return JPlacedFeature.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)chance), heightRange);
    }

    public static ResourceKey<PlacedFeature> registerKey(String key) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)JITL.rl(key));
    }

    public static ImmutableList.Builder<PlacementModifier> treePlacementBase(PlacementModifier placement) {
        return ImmutableList.builder().add((Object)placement).add((Object)InSquarePlacement.spread()).add((Object)SurfaceWaterDepthFilter.forMaxDepth((int)0)).add((Object)PlacementUtils.HEIGHTMAP_OCEAN_FLOOR).add((Object)BiomeFilter.biome());
    }

    public static ImmutableList.Builder<PlacementModifier> treePlacementBaseHeight(PlacementModifier placement, PlacementModifier placement2) {
        return ImmutableList.builder().add((Object)placement).add((Object)placement2).add((Object)InSquarePlacement.spread()).add((Object)SurfaceWaterDepthFilter.forMaxDepth((int)0)).add((Object)PlacementUtils.FULL_RANGE).add((Object)BiomeFilter.biome());
    }

    public static List<PlacementModifier> treePlacement(PlacementModifier placement) {
        return JPlacedFeature.treePlacementBase(placement).build();
    }

    public static List<PlacementModifier> treePlacement(PlacementModifier placement, PlacementModifier placement2) {
        return JPlacedFeature.treePlacementBaseHeight(placement, placement2).build();
    }

    public static List<PlacementModifier> treePlacement(PlacementModifier placement, Block saplingBlock) {
        return JPlacedFeature.treePlacementBase(placement).add((Object)BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)saplingBlock.defaultBlockState(), (Vec3i)BlockPos.ZERO))).build();
    }
}

