/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;

public class InternetHandler {
    public static boolean isUpdateAvailable() throws IOException {
        BufferedReader versionFile = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/TheSlayerMC/JITL/main/version").openStream()));
        String curVersion = versionFile.readLine();
        versionFile.close();
        return !curVersion.contains("2.2.5");
    }

    public static String getUpdateVersion() throws IOException {
        BufferedReader versionFile = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/TheSlayerMC/JITL/main/version").openStream()));
        return versionFile.readLine();
    }

    public static boolean isOnline() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface interf = interfaces.nextElement();
            if (!interf.isUp() || interf.isLoopback()) continue;
            List<InterfaceAddress> adrs = interf.getInterfaceAddresses();
            for (InterfaceAddress adr : adrs) {
                InetAddress inadr = adr.getAddress();
                if (!(inadr instanceof Inet4Address)) continue;
                return true;
            }
        }
        return false;
    }
}

