/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.helper.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class UnlockedConstructor<T> {
    private final Constructor<T> c;
    private final boolean accessible;

    public UnlockedConstructor(Constructor<T> c) {
        this.c = c;
        this.accessible = c.trySetAccessible();
    }

    public T newInstance(Object ... initParams) {
        if (!this.accessible) {
            throw new UnsupportedOperationException("The constructor isn't accessible");
        }
        try {
            return this.c.newInstance(initParams);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Constructor<T> unboxed() {
        return this.c;
    }

    public String toString() {
        return this.c.toString();
    }
}

