/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.helper.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.jitl.core.helper.internal.ReflectionHelper;
import org.jetbrains.annotations.Nullable;

public class UnlockedMethod<O, T> {
    private final Method method;
    private final boolean accessible;
    private final boolean isStatic;

    public UnlockedMethod(Method method) {
        this.method = method;
        this.accessible = method.trySetAccessible();
        this.isStatic = ReflectionHelper.isStatic(method);
    }

    public T invoke(@Nullable O methodOwner, Object ... params) {
        if (!this.accessible) {
            throw new UnsupportedOperationException("The method isn't accessible");
        }
        if (!this.isStatic && methodOwner == null) {
            throw new IllegalArgumentException(String.format("Tried to pass null as a methodOwner to the non static method %s", this.method.toString()));
        }
        try {
            return (T)this.method.invoke(methodOwner, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Method unboxed() {
        return this.method;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean guessIsAccessible() {
        return this.accessible;
    }

    public String toString() {
        return this.method.toString();
    }
}

