/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.init;

import net.jitl.client.ClientEventHandler;
import net.jitl.client.gui.BossBarRenderer;
import net.jitl.client.gui.KeyUsedEvent;
import net.jitl.common.world.dimension.Dimensions;
import net.jitl.common.world.dimension.JCarver;
import net.jitl.common.world.gen.JFeatures;
import net.jitl.common.world.gen.JFoliagePlacers;
import net.jitl.common.world.gen.JTreeDecorators;
import net.jitl.core.config.JClientConfig;
import net.jitl.core.config.JCommonConfig;
import net.jitl.core.data.JNetworkRegistry;
import net.jitl.core.init.compat.ModCompat;
import net.jitl.core.init.internal.JAttributes;
import net.jitl.core.init.internal.JBlockEntities;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JContainers;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JDataComponents;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JParticleManager;
import net.jitl.core.init.internal.JSounds;
import net.jitl.core.init.internal.JTabs;
import net.jitl.core.init.internal.ScrollEntries;
import net.jitl.core.init.internal.StructureRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="jitl")
public class JITL {
    public static final String MOD_ID = "jitl";
    public static final String MOD_VERSION = "2.2.5";
    public static final String MOD_NAME = "Journey Into the Light";
    public static final Logger LOGGER = LogManager.getLogger((String)"jitl");
    public static final boolean DEV_MODE = false;

    public JITL(IEventBus modEventBus, ModContainer container) {
        modEventBus.addListener(JTabs::registerTabs);
        JItems.ITEMS.register(modEventBus);
        JBlocks.BLOCKS.register(modEventBus);
        JItems.BLOCK_ITEMS.register(modEventBus);
        JEntities.REGISTRY.register(modEventBus);
        JAttributes.REGISTRY.register(modEventBus);
        JFoliagePlacers.REGISTRY.register(modEventBus);
        JFeatures.REGISTRY.register(modEventBus);
        JContainers.REGISTRY.register(modEventBus);
        JBlockEntities.REGISTRY.register(modEventBus);
        Dimensions.REGISTRY.register(modEventBus);
        JCarver.REGISTRY.register(modEventBus);
        StructureRegistry.REGISTRY.register(modEventBus);
        JParticleManager.REGISTRY.register(modEventBus);
        JTreeDecorators.REGISTRY.register(modEventBus);
        JSounds.REGISTRY.register(modEventBus);
        JSounds.JUKEBOX_SONG.register(modEventBus);
        JTabs.REGISTRY.register(modEventBus);
        JDataAttachments.REGISTRY.register(modEventBus);
        JDataComponents.REGISTRY.register(modEventBus);
        JNetworkRegistry.init(modEventBus);
        modEventBus.addListener(this::commonInit);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::enqueue);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)JClientConfig.SPEC, "jitl-client.toml");
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)JCommonConfig.SPEC, "jitl-common.toml");
    }

    private void commonInit(FMLCommonSetupEvent event) {
        ModCompat.init(event);
        ScrollEntries.register();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        BossBarRenderer.init();
        NeoForge.EVENT_BUS.register(KeyUsedEvent.class);
        IEventBus forgeEventBus = NeoForge.EVENT_BUS;
        ClientEventHandler.regToBus(forgeEventBus);
    }

    private void enqueue(InterModEnqueueEvent event) {
    }

    public static ResourceLocation rl(String r) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)r);
    }

    public static ResourceLocation tl(String r) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)("textures/" + r));
    }

    public static ResourceLocation getRegistryName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceLocation getRegistryName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static ResourceLocation getRegistryName(EntityType<?> entity) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entity);
    }
}

