/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.init.internal;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;

public class JDamageSources {
    private final Registry<DamageType> damageTypes;
    public final DamageSource BRADBERRY_BUSH;
    public final DamageSource REDCURRANT_BUSH;
    public final DamageSource DEMONIC_BOMB;
    public final DamageSource FIRE_BOMB;

    private JDamageSources(RegistryAccess r) {
        this.damageTypes = r.lookupOrThrow(Registries.DAMAGE_TYPE);
        this.BRADBERRY_BUSH = this.source(this.makeSource("bradberry_bush"));
        this.REDCURRANT_BUSH = this.source(this.makeSource("redcurrant_bush"));
        this.DEMONIC_BOMB = this.source(this.makeSource("demonic_bomb"));
        this.FIRE_BOMB = this.source(this.makeSource("fire_bomb"));
    }

    private ResourceKey<DamageType> makeSource(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)name));
    }

    private DamageSource source(ResourceKey<DamageType> r) {
        return new DamageSource((Holder)this.damageTypes.getOrThrow(r));
    }
}

