/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.text.StringsKt;
import ru.astrainteractive.soulkeeper.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.soulkeeper.org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nCallableId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableId.kt\norg/jetbrains/kotlin/name/CallableId\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class CallableId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName packageName;
    @Nullable
    private final FqName className;
    @NotNull
    private final Name callableName;
    @Nullable
    private final ClassId classId;
    @Nullable
    private final FqName pathToLocal;
    @NotNull
    private static final Name LOCAL_NAME = SpecialNames.LOCAL;
    @NotNull
    private static final FqName PACKAGE_FQ_NAME_FOR_LOCAL;

    private CallableId(FqName packageName, FqName className, Name callableName, ClassId classId, FqName pathToLocal) {
        this.packageName = packageName;
        this.className = className;
        this.callableName = callableName;
        this.classId = classId;
        this.pathToLocal = pathToLocal;
    }

    public CallableId(@NotNull FqName packageName, @NotNull Name callableName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        Intrinsics.checkNotNullParameter(callableName, "callableName");
        this(packageName, null, callableName, null, null);
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof CallableId) ? false : Intrinsics.areEqual(this.packageName, ((CallableId)other).packageName) && Intrinsics.areEqual(this.className, ((CallableId)other).className) && Intrinsics.areEqual(this.callableName, ((CallableId)other).callableName));
    }

    public int hashCode() {
        int result2 = 17;
        result2 = result2 * 31 + this.packageName.hashCode();
        FqName fqName = this.className;
        result2 = result2 * 31 + (fqName != null ? ((Object)fqName).hashCode() : 0);
        result2 = result2 * 31 + this.callableName.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String string = this.packageName.asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        $this$toString_u24lambda_u241.append(StringsKt.replace$default(string, '.', '/', false, 4, null));
        $this$toString_u24lambda_u241.append("/");
        if (this.className != null) {
            $this$toString_u24lambda_u241.append(this.className);
            $this$toString_u24lambda_u241.append(".");
        }
        $this$toString_u24lambda_u241.append(this.callableName);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    static {
        FqName fqName = FqName.topLevel(LOCAL_NAME);
        Intrinsics.checkNotNullExpressionValue(fqName, "topLevel(...)");
        PACKAGE_FQ_NAME_FOR_LOCAL = fqName;
    }

    @SourceDebugExtension(value={"SMAP\nCallableId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableId.kt\norg/jetbrains/kotlin/name/CallableId$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

