/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.soulkeeper.kotlinx.serialization.json.internal;

import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.DeserializationStrategy;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.KSerializer;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.SerializationStrategy;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.descriptors.PolymorphicKind;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.descriptors.PrimitiveKind;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.descriptors.SerialDescriptor;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.descriptors.SerialKind;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.descriptors.StructureKind;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.json.ClassDiscriminatorMode;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.json.JsonConfiguration;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.modules.SerializersModuleCollector;
import ru.astrainteractive.soulkeeper.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JQ\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102/\u0010\u0011\u001a+\u0012\u001d\u0012\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0012H\u0016JF\u0010\u0018\u001a\u00020\f\"\b\b\u0000\u0010\u0019*\u00020\u000e\"\b\b\u0001\u0010\u001a*\u0002H\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u0014H\u0016J\u001c\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001c\u0010!\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002JK\u0010\"\u001a\u00020\f\"\b\b\u0000\u0010\u0019*\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u00102)\u0010#\u001a%\u0012\u0013\u0012\u0011H\u0019\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b($\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0019\u0018\u00010%0\u0012H\u0016JM\u0010&\u001a\u00020\f\"\b\b\u0000\u0010\u0019*\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u00102+\u0010'\u001a'\u0012\u0015\u0012\u0013\u0018\u00010\u0007\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b((\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0019\u0018\u00010)0\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lru/astrainteractive/soulkeeper/kotlinx/serialization/json/internal/JsonSerializersModuleValidator;", "Lru/astrainteractive/soulkeeper/kotlinx/serialization/modules/SerializersModuleCollector;", "configuration", "Lru/astrainteractive/soulkeeper/kotlinx/serialization/json/JsonConfiguration;", "<init>", "(Lru/astrainteractive/soulkeeper/kotlinx/serialization/json/JsonConfiguration;)V", "discriminator", "", "useArrayPolymorphism", "", "isDiscriminatorRequired", "contextual", "", "T", "", "kClass", "Lkotlin/reflect/KClass;", "provider", "Lkotlin/Function1;", "", "Lru/astrainteractive/soulkeeper/kotlinx/serialization/KSerializer;", "Lkotlin/ParameterName;", "name", "typeArgumentsSerializers", "polymorphic", "Base", "Sub", "baseClass", "actualClass", "actualSerializer", "checkKind", "descriptor", "Lru/astrainteractive/soulkeeper/kotlinx/serialization/descriptors/SerialDescriptor;", "checkDiscriminatorCollisions", "polymorphicDefaultSerializer", "defaultSerializerProvider", "value", "Lru/astrainteractive/soulkeeper/kotlinx/serialization/SerializationStrategy;", "polymorphicDefaultDeserializer", "defaultDeserializerProvider", "className", "Lru/astrainteractive/soulkeeper/kotlinx/serialization/DeserializationStrategy;", "ru.astrainteractive.soulkeeper.kotlinx-serialization-json"})
public final class JsonSerializersModuleValidator
implements SerializersModuleCollector {
    @NotNull
    private final String discriminator;
    private final boolean useArrayPolymorphism;
    private final boolean isDiscriminatorRequired;

    public JsonSerializersModuleValidator(@NotNull JsonConfiguration configuration) {
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        this.discriminator = configuration.getClassDiscriminator();
        this.useArrayPolymorphism = configuration.getUseArrayPolymorphism();
        this.isDiscriminatorRequired = configuration.getClassDiscriminatorMode() != ClassDiscriminatorMode.NONE;
    }

    @Override
    public <T> void contextual(@NotNull KClass<T> kClass, @NotNull Function1<? super List<? extends KSerializer<?>>, ? extends KSerializer<?>> provider) {
        Intrinsics.checkNotNullParameter(kClass, "kClass");
        Intrinsics.checkNotNullParameter(provider, "provider");
    }

    @Override
    public <Base, Sub extends Base> void polymorphic(@NotNull KClass<Base> baseClass, @NotNull KClass<Sub> actualClass, @NotNull KSerializer<Sub> actualSerializer) {
        Intrinsics.checkNotNullParameter(baseClass, "baseClass");
        Intrinsics.checkNotNullParameter(actualClass, "actualClass");
        Intrinsics.checkNotNullParameter(actualSerializer, "actualSerializer");
        SerialDescriptor descriptor2 = actualSerializer.getDescriptor();
        this.checkKind(descriptor2, actualClass);
        if (!this.useArrayPolymorphism && this.isDiscriminatorRequired) {
            this.checkDiscriminatorCollisions(descriptor2, actualClass);
        }
    }

    private final void checkKind(SerialDescriptor descriptor2, KClass<?> actualClass) {
        SerialKind kind = descriptor2.getKind();
        if (kind instanceof PolymorphicKind || Intrinsics.areEqual(kind, SerialKind.CONTEXTUAL.INSTANCE)) {
            throw new IllegalArgumentException("Serializer for " + actualClass.getSimpleName() + " can't be registered as a subclass for polymorphic serialization because its kind " + kind + " is not concrete. To work with multiple hierarchies, register it as a base class.");
        }
        if (this.useArrayPolymorphism) {
            return;
        }
        if (!this.isDiscriminatorRequired) {
            return;
        }
        if (Intrinsics.areEqual(kind, StructureKind.LIST.INSTANCE) || Intrinsics.areEqual(kind, StructureKind.MAP.INSTANCE) || kind instanceof PrimitiveKind || kind instanceof SerialKind.ENUM) {
            throw new IllegalArgumentException("Serializer for " + actualClass.getSimpleName() + " of kind " + kind + " cannot be serialized polymorphically with class discriminator.");
        }
    }

    private final void checkDiscriminatorCollisions(SerialDescriptor descriptor2, KClass<?> actualClass) {
        int n = descriptor2.getElementsCount();
        for (int i = 0; i < n; ++i) {
            String name = descriptor2.getElementName(i);
            if (!Intrinsics.areEqual(name, this.discriminator)) continue;
            throw new IllegalArgumentException("Polymorphic serializer for " + actualClass + " has property '" + name + "' that conflicts with JSON class discriminator. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism");
        }
    }

    @Override
    public <Base> void polymorphicDefaultSerializer(@NotNull KClass<Base> baseClass, @NotNull Function1<? super Base, ? extends SerializationStrategy<? super Base>> defaultSerializerProvider) {
        Intrinsics.checkNotNullParameter(baseClass, "baseClass");
        Intrinsics.checkNotNullParameter(defaultSerializerProvider, "defaultSerializerProvider");
    }

    @Override
    public <Base> void polymorphicDefaultDeserializer(@NotNull KClass<Base> baseClass, @NotNull Function1<? super String, ? extends DeserializationStrategy<? extends Base>> defaultDeserializerProvider) {
        Intrinsics.checkNotNullParameter(baseClass, "baseClass");
        Intrinsics.checkNotNullParameter(defaultDeserializerProvider, "defaultDeserializerProvider");
    }

    @Override
    public <T> void contextual(@NotNull KClass<T> kClass, @NotNull KSerializer<T> serializer2) {
        SerializersModuleCollector.super.contextual(kClass, serializer2);
    }

    @Override
    @Deprecated(message="Deprecated in favor of function with more precise name: polymorphicDefaultDeserializer", replaceWith=@ReplaceWith(expression="polymorphicDefaultDeserializer(baseClass, defaultDeserializerProvider)", imports={}), level=DeprecationLevel.WARNING)
    public <Base> void polymorphicDefault(@NotNull KClass<Base> baseClass, @NotNull Function1<? super String, ? extends DeserializationStrategy<? extends Base>> defaultDeserializerProvider) {
        SerializersModuleCollector.super.polymorphicDefault(baseClass, defaultDeserializerProvider);
    }
}

