/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.soulkeeper.kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.json.internal.AbstractJsonLexer;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.json.internal.ArrayAsSequence;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.json.internal.CharArrayPoolBatchSize;
import ru.astrainteractive.soulkeeper.kotlinx.serialization.json.internal.InternalJsonReader;
import ru.astrainteractive.soulkeeper.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.soulkeeper.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u0010\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\rH\u0016J\u0018\u0010$\u001a\u00020 2\u0006\u0010#\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0016J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\rH\u0014J\u001a\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u0013H\u0016J\u0006\u0010,\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\r8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006-"}, d2={"Lru/astrainteractive/soulkeeper/kotlinx/serialization/json/internal/ReaderJsonLexer;", "Lru/astrainteractive/soulkeeper/kotlinx/serialization/json/internal/AbstractJsonLexer;", "reader", "Lru/astrainteractive/soulkeeper/kotlinx/serialization/json/internal/InternalJsonReader;", "buffer", "", "<init>", "(Lru/astrainteractive/soulkeeper/kotlinx/serialization/json/internal/InternalJsonReader;[C)V", "getReader", "()Lru/astrainteractive/soulkeeper/kotlinx/serialization/json/internal/InternalJsonReader;", "getBuffer", "()[C", "threshold", "", "source", "Lru/astrainteractive/soulkeeper/kotlinx/serialization/json/internal/ArrayAsSequence;", "getSource", "()Lru/astrainteractive/soulkeeper/kotlinx/serialization/json/internal/ArrayAsSequence;", "canConsumeValue", "", "preload", "", "unprocessedCount", "prefetchOrEof", "position", "consumeNextToken", "", "expected", "", "skipWhitespaces", "ensureHaveChars", "consumeKeyString", "", "indexOf", "char", "startPos", "substring", "endPos", "appendRange", "fromIndex", "toIndex", "peekLeadingMatchingValue", "keyToMatch", "isLenient", "release", "ru.astrainteractive.soulkeeper.kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nReaderJsonLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReaderJsonLexer.kt\nkotlinx/serialization/json/internal/ReaderJsonLexer\n+ 2 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n+ 3 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer$fail$1\n*L\n1#1,221:1\n158#2:222\n158#2:223\n158#2:224\n226#2,10:225\n229#3:235\n*S KotlinDebug\n*F\n+ 1 ReaderJsonLexer.kt\nkotlinx/serialization/json/internal/ReaderJsonLexer\n*L\n66#1:222\n133#1:223\n150#1:224\n181#1:225,10\n181#1:235\n*E\n"})
public class ReaderJsonLexer
extends AbstractJsonLexer {
    @NotNull
    private final InternalJsonReader reader;
    @NotNull
    private final char[] buffer;
    @JvmField
    protected int threshold;
    @NotNull
    private final ArrayAsSequence source;

    public ReaderJsonLexer(@NotNull InternalJsonReader reader, @NotNull char[] buffer) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.reader = reader;
        this.buffer = buffer;
        this.threshold = 128;
        this.source = new ArrayAsSequence(this.buffer);
        this.preload(0);
    }

    public /* synthetic */ ReaderJsonLexer(InternalJsonReader internalJsonReader, char[] cArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cArray = CharArrayPoolBatchSize.INSTANCE.take();
        }
        this(internalJsonReader, cArray);
    }

    @NotNull
    public final InternalJsonReader getReader() {
        return this.reader;
    }

    @NotNull
    public final char[] getBuffer() {
        return this.buffer;
    }

    @Override
    @NotNull
    protected ArrayAsSequence getSource() {
        return this.source;
    }

    @Override
    public boolean canConsumeValue() {
        this.ensureHaveChars();
        int current = this.currentPosition;
        while ((current = this.prefetchOrEof(current)) != -1) {
            char c = this.getSource().charAt(current);
            AbstractJsonLexer abstractJsonLexer = this;
            char $this$isWs$iv = c;
            boolean $i$f$isWs = false;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') {
                ++current;
                continue;
            }
            this.currentPosition = current;
            return this.isValidValueStart(c);
        }
        this.currentPosition = current;
        return false;
    }

    private final void preload(int unprocessedCount) {
        int actual;
        char[] buffer = this.getSource().getBuffer$kotlinx_serialization_json();
        if (unprocessedCount != 0) {
            ArraysKt.copyInto(buffer, buffer, 0, this.currentPosition, this.currentPosition + unprocessedCount);
        }
        int sizeTotal = this.getSource().length();
        for (int filledCount = unprocessedCount; filledCount != sizeTotal; filledCount += actual) {
            actual = this.reader.read(buffer, filledCount, sizeTotal - filledCount);
            if (actual != -1) continue;
            this.getSource().trim(filledCount);
            this.threshold = -1;
            break;
        }
        this.currentPosition = 0;
    }

    @Override
    public int prefetchOrEof(int position) {
        if (position < this.getSource().length()) {
            return position;
        }
        this.currentPosition = position;
        this.ensureHaveChars();
        if (this.currentPosition != 0 || ((CharSequence)this.getSource()).length() == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public byte consumeNextToken() {
        this.ensureHaveChars();
        ArrayAsSequence source2 = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            char ch;
            byte tc;
            if ((tc = AbstractJsonLexerKt.charToTokenClass(ch = source2.charAt(cpos++))) == 3) continue;
            this.currentPosition = cpos;
            return tc;
        }
        this.currentPosition = cpos;
        return 10;
    }

    @Override
    public void consumeNextToken(char expected) {
        this.ensureHaveChars();
        ArrayAsSequence source2 = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            char c = source2.charAt(cpos++);
            AbstractJsonLexer abstractJsonLexer = this;
            char $this$isWs$iv = c;
            boolean $i$f$isWs = false;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') continue;
            this.currentPosition = cpos;
            if (c == expected) {
                return;
            }
            this.unexpectedToken(expected);
        }
        this.currentPosition = cpos;
        this.unexpectedToken(expected);
    }

    @Override
    public int skipWhitespaces() {
        int current = this.currentPosition;
        while ((current = this.prefetchOrEof(current)) != -1) {
            char c = this.getSource().charAt(current);
            AbstractJsonLexer abstractJsonLexer = this;
            char $this$isWs$iv = c;
            boolean $i$f$isWs = false;
            if (!($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t')) break;
            ++current;
        }
        this.currentPosition = current;
        return current;
    }

    @Override
    public void ensureHaveChars() {
        int cur = this.currentPosition;
        int oldSize = this.getSource().length();
        int spaceLeft = oldSize - cur;
        if (spaceLeft > this.threshold) {
            return;
        }
        this.preload(spaceLeft);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String consumeKeyString() {
        this.consumeNextToken('\"');
        int current = this.currentPosition;
        int closingQuote = this.indexOf('\"', current);
        if (closingQuote == -1) {
            if ((current = this.prefetchOrEof(current)) == -1) {
                void source2;
                String s$iv;
                void $this$iv;
                AbstractJsonLexer abstractJsonLexer = this;
                byte expectedToken$iv = 1;
                boolean wasConsumed$iv = true;
                boolean $i$f$fail$kotlinx_serialization_json = false;
                String expected$iv = AbstractJsonLexerKt.tokenDescription(expectedToken$iv);
                int position$iv = $this$iv.currentPosition - 1;
                String string = s$iv = $this$iv.currentPosition == AbstractJsonLexer.access$getSource((AbstractJsonLexer)$this$iv).length() || position$iv < 0 ? "EOF" : String.valueOf(AbstractJsonLexer.access$getSource((AbstractJsonLexer)$this$iv).charAt(position$iv));
                String string2 = expected$iv;
                void var13_13 = $this$iv;
                boolean bl = false;
                String expected = string2;
                AbstractJsonLexer.fail$default((AbstractJsonLexer)var13_13, "Expected " + expected + ", but had '" + (String)source2 + "' instead", position$iv, null, 4, null);
                throw new KotlinNothingValueException();
            }
            return this.consumeString(this.getSource(), this.currentPosition, current);
        }
        for (int i = current; i < closingQuote; ++i) {
            if (this.getSource().charAt(i) != '\\') continue;
            return this.consumeString(this.getSource(), this.currentPosition, i);
        }
        this.currentPosition = closingQuote + 1;
        return this.substring(current, closingQuote);
    }

    @Override
    public int indexOf(char c, int startPos) {
        ArrayAsSequence src = this.getSource();
        int n = src.length();
        for (int i = startPos; i < n; ++i) {
            if (src.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    public String substring(int startPos, int endPos) {
        return this.getSource().substring(startPos, endPos);
    }

    @Override
    protected void appendRange(int fromIndex, int toIndex) {
        StringBuilder stringBuilder = this.getEscapedString();
        Intrinsics.checkNotNullExpressionValue(stringBuilder.append(this.getSource().getBuffer$kotlinx_serialization_json(), fromIndex, toIndex - fromIndex), "append(...)");
    }

    @Override
    @Nullable
    public String peekLeadingMatchingValue(@NotNull String keyToMatch, boolean isLenient) {
        Intrinsics.checkNotNullParameter(keyToMatch, "keyToMatch");
        return null;
    }

    public final void release() {
        CharArrayPoolBatchSize.INSTANCE.release(this.buffer);
    }
}

