/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.soulkeeper.module.souls.database.coulmn;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import ru.astrainteractive.soulkeeper.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.soulkeeper.org.jetbrains.annotations.Nullable;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.ColumnType;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lru/astrainteractive/soulkeeper/module/souls/database/coulmn/KJavaInstantColumnType;", "Lru/astrainteractive/soulkeeper/org/jetbrains/exposed/sql/ColumnType;", "Ljava/time/Instant;", "<init>", "()V", "sqlType", "", "valueFromDB", "value", "", "valueToDB", "valueToString", "nonNullValueToString", "dao"})
public final class KJavaInstantColumnType
extends ColumnType<Instant> {
    public KJavaInstantColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().longType();
    }

    @Override
    @NotNull
    public Instant valueFromDB(@NotNull Object value) {
        Instant instant;
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        if (object instanceof Long) {
            Instant instant2 = Instant.ofEpochMilli(((Number)value).longValue());
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue(instant2, "ofEpochMilli(...)");
        } else if (object instanceof Number) {
            Instant instant3 = Instant.ofEpochMilli(((Number)value).longValue());
            instant = instant3;
            Intrinsics.checkNotNullExpressionValue(instant3, "ofEpochMilli(...)");
        } else if (object instanceof String) {
            Instant instant4 = Instant.ofEpochMilli(Long.parseLong((String)value));
            instant = instant4;
            Intrinsics.checkNotNullExpressionValue(instant4, "ofEpochMilli(...)");
        } else {
            throw new IllegalStateException(("Unexpected value of type Long: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return instant;
    }

    @Override
    @Nullable
    public Object valueToDB(@Nullable Instant value) {
        Instant instant = value;
        return instant != null ? Long.valueOf(instant.toEpochMilli()) : null;
    }

    @Override
    @NotNull
    public String valueToString(@Nullable Instant value) {
        Instant instant = value;
        String string = instant != null ? Long.valueOf(instant.toEpochMilli()).toString() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Instant value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return String.valueOf(value.toEpochMilli());
    }
}

