/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.soulkeeper.module.souls.di;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.bukkit.plugin.Plugin;
import ru.astrainteractive.soulkeeper.core.di.BukkitCoreModule;
import ru.astrainteractive.soulkeeper.core.di.CoreModule;
import ru.astrainteractive.soulkeeper.core.plugin.SoulsConfig;
import ru.astrainteractive.soulkeeper.kotlinx.coroutines.flow.FlowKt;
import ru.astrainteractive.soulkeeper.module.souls.dao.SoulsDao;
import ru.astrainteractive.soulkeeper.module.souls.di.SoulsDaoModule;
import ru.astrainteractive.soulkeeper.module.souls.domain.GetNearestSoulUseCase;
import ru.astrainteractive.soulkeeper.module.souls.domain.PickUpExpUseCase;
import ru.astrainteractive.soulkeeper.module.souls.domain.PickUpItemsUseCase;
import ru.astrainteractive.soulkeeper.module.souls.domain.PickUpSoulUseCase;
import ru.astrainteractive.soulkeeper.module.souls.domain.armorstand.ShowArmorStandUseCase;
import ru.astrainteractive.soulkeeper.module.souls.domain.di.factory.ShowArmorStandUseCaseFactory;
import ru.astrainteractive.soulkeeper.module.souls.renderer.ArmorStandRenderer;
import ru.astrainteractive.soulkeeper.module.souls.renderer.SoulParticleRenderer;
import ru.astrainteractive.soulkeeper.module.souls.renderer.SoulSoundRenderer;
import ru.astrainteractive.soulkeeper.module.souls.service.DeleteSoulWorker;
import ru.astrainteractive.soulkeeper.module.souls.service.FreeSoulWorker;
import ru.astrainteractive.soulkeeper.module.souls.service.PickUpWorker;
import ru.astrainteractive.soulkeeper.module.souls.service.SoulCallWorker;
import ru.astrainteractive.soulkeeper.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.soulkeeper.ru.astrainteractive.astralibs.lifecycle.Lifecycle;
import ru.astrainteractive.soulkeeper.ru.astrainteractive.astralibs.service.TickFlowService;
import ru.astrainteractive.soulkeeper.ru.astrainteractive.klibs.kstorage.api.CachedKrate;
import ru.astrainteractive.soulkeeper.ru.astrainteractive.klibs.mikro.core.dispatchers.KotlinDispatchers;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lru/astrainteractive/soulkeeper/module/souls/di/ServiceModule;", "", "coreModule", "Lru/astrainteractive/soulkeeper/core/di/CoreModule;", "bukkitCoreModule", "Lru/astrainteractive/soulkeeper/core/di/BukkitCoreModule;", "soulsDaoModule", "Lru/astrainteractive/soulkeeper/module/souls/di/SoulsDaoModule;", "<init>", "(Lru/astrainteractive/soulkeeper/core/di/CoreModule;Lru/astrainteractive/soulkeeper/core/di/BukkitCoreModule;Lru/astrainteractive/soulkeeper/module/souls/di/SoulsDaoModule;)V", "showArmorStandUseCase", "Lru/astrainteractive/soulkeeper/module/souls/domain/armorstand/ShowArmorStandUseCase;", "armorStandRenderer", "Lru/astrainteractive/soulkeeper/module/souls/renderer/ArmorStandRenderer;", "soulParticleRenderer", "Lru/astrainteractive/soulkeeper/module/souls/renderer/SoulParticleRenderer;", "soulSoundRenderer", "Lru/astrainteractive/soulkeeper/module/souls/renderer/SoulSoundRenderer;", "deleteSoulService", "Lru/astrainteractive/soulkeeper/ru/astrainteractive/astralibs/service/TickFlowService;", "freeSoulService", "soulCallWorker", "Lru/astrainteractive/soulkeeper/module/souls/service/SoulCallWorker;", "pickUpSoulService", "lifecycle", "Lru/astrainteractive/soulkeeper/ru/astrainteractive/astralibs/lifecycle/Lifecycle;", "getLifecycle", "()Lru/astrainteractive/soulkeeper/ru/astrainteractive/astralibs/lifecycle/Lifecycle;", "service"})
public final class ServiceModule {
    @NotNull
    private final ShowArmorStandUseCase showArmorStandUseCase;
    @NotNull
    private final ArmorStandRenderer armorStandRenderer;
    @NotNull
    private final SoulParticleRenderer soulParticleRenderer;
    @NotNull
    private final SoulSoundRenderer soulSoundRenderer;
    @NotNull
    private final TickFlowService deleteSoulService;
    @NotNull
    private final TickFlowService freeSoulService;
    @NotNull
    private final SoulCallWorker soulCallWorker;
    @NotNull
    private final TickFlowService pickUpSoulService;
    @NotNull
    private final Lifecycle lifecycle;

    public ServiceModule(@NotNull CoreModule coreModule, @NotNull BukkitCoreModule bukkitCoreModule, @NotNull SoulsDaoModule soulsDaoModule) {
        Intrinsics.checkNotNullParameter(coreModule, "coreModule");
        Intrinsics.checkNotNullParameter(bukkitCoreModule, "bukkitCoreModule");
        Intrinsics.checkNotNullParameter(soulsDaoModule, "soulsDaoModule");
        this.showArmorStandUseCase = new ShowArmorStandUseCaseFactory(coreModule).create();
        this.armorStandRenderer = new ArmorStandRenderer(coreModule.getSoulsConfigKrate(), this.showArmorStandUseCase);
        Object object = coreModule.getSoulsConfigKrate();
        Object object2 = coreModule.getDispatchers();
        this.soulParticleRenderer = new SoulParticleRenderer((KotlinDispatchers)object2, (CachedKrate<SoulsConfig>)object);
        this.soulSoundRenderer = new SoulSoundRenderer(coreModule.getDispatchers(), coreModule.getSoulsConfigKrate());
        this.deleteSoulService = new TickFlowService(coreModule.getDispatchers().getIO(), FlowKt.flowOf(Duration.box-impl(DurationKt.toDuration(60, DurationUnit.SECONDS))), null, new DeleteSoulWorker(soulsDaoModule.getSoulsDao(), coreModule.getSoulsConfigKrate()), 4, null);
        this.freeSoulService = new TickFlowService(coreModule.getDispatchers().getIO(), FlowKt.flowOf(Duration.box-impl(DurationKt.toDuration(60, DurationUnit.SECONDS))), null, new FreeSoulWorker(soulsDaoModule.getSoulsDao(), coreModule.getSoulsConfigKrate()), 4, null);
        this.soulCallWorker = new SoulCallWorker(soulsDaoModule.getSoulsDao(), (Plugin)bukkitCoreModule.getPlugin(), coreModule.getSoulsConfigKrate().getCachedValue(), this.soulParticleRenderer, this.soulSoundRenderer, this.armorStandRenderer);
        object = coreModule.getDispatchers();
        object2 = new PickUpExpUseCase(() -> ServiceModule.pickUpSoulService$lambda$0(coreModule), soulsDaoModule.getSoulsDao());
        PickUpItemsUseCase pickUpItemsUseCase = new PickUpItemsUseCase(() -> ServiceModule.pickUpSoulService$lambda$1(coreModule), soulsDaoModule.getSoulsDao());
        SoulsDao soulsDao = soulsDaoModule.getSoulsDao();
        this.pickUpSoulService = new TickFlowService(coreModule.getDispatchers().getIO(), FlowKt.flowOf(Duration.box-impl(DurationKt.toDuration(3, DurationUnit.SECONDS))), null, new PickUpWorker(new PickUpSoulUseCase((KotlinDispatchers)object, (PickUpExpUseCase)object2, pickUpItemsUseCase, soulsDao, () -> ServiceModule.pickUpSoulService$lambda$2(coreModule), () -> ServiceModule.pickUpSoulService$lambda$3(coreModule), () -> ServiceModule.pickUpSoulService$lambda$4(coreModule), () -> ServiceModule.pickUpSoulService$lambda$5(coreModule)), new GetNearestSoulUseCase(soulsDaoModule.getSoulsDao()), soulsDaoModule.getSoulsDao()), 4, null);
        this.lifecycle = new Lifecycle.Lambda(arg_0 -> ServiceModule.lifecycle$lambda$6(this, arg_0), arg_0 -> ServiceModule.lifecycle$lambda$7(this, arg_0), null, 4, null);
    }

    @NotNull
    public final Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    private static final SoulsConfig.Sounds.SoundConfig pickUpSoulService$lambda$0(CoreModule $coreModule) {
        return $coreModule.getSoulsConfigKrate().getCachedValue().getSounds().getCollectXp();
    }

    private static final SoulsConfig.Sounds.SoundConfig pickUpSoulService$lambda$1(CoreModule $coreModule) {
        return $coreModule.getSoulsConfigKrate().getCachedValue().getSounds().getCollectItem();
    }

    private static final SoulsConfig.Sounds.SoundConfig pickUpSoulService$lambda$2(CoreModule $coreModule) {
        return $coreModule.getSoulsConfigKrate().getCachedValue().getSounds().getSoulDisappear();
    }

    private static final SoulsConfig.Particles.Particle pickUpSoulService$lambda$3(CoreModule $coreModule) {
        return $coreModule.getSoulsConfigKrate().getCachedValue().getParticles().getSoulGone();
    }

    private static final SoulsConfig.Sounds.SoundConfig pickUpSoulService$lambda$4(CoreModule $coreModule) {
        return $coreModule.getSoulsConfigKrate().getCachedValue().getSounds().getSoulContentLeft();
    }

    private static final SoulsConfig.Particles.Particle pickUpSoulService$lambda$5(CoreModule $coreModule) {
        return $coreModule.getSoulsConfigKrate().getCachedValue().getParticles().getSoulContentLeft();
    }

    private static final Unit lifecycle$lambda$6(ServiceModule this$0, Lifecycle $this$Lambda) {
        Intrinsics.checkNotNullParameter($this$Lambda, "$this$Lambda");
        this$0.soulCallWorker.onEnable();
        this$0.pickUpSoulService.onCreate();
        this$0.deleteSoulService.onCreate();
        this$0.freeSoulService.onCreate();
        return Unit.INSTANCE;
    }

    private static final Unit lifecycle$lambda$7(ServiceModule this$0, Lifecycle $this$Lambda) {
        Intrinsics.checkNotNullParameter($this$Lambda, "$this$Lambda");
        this$0.soulCallWorker.onDisable();
        this$0.pickUpSoulService.onDestroy();
        this$0.deleteSoulService.onDestroy();
        this$0.freeSoulService.onDestroy();
        return Unit.INSTANCE;
    }
}

