/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.soulkeeper.okio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ru.astrainteractive.soulkeeper.okio.Buffer;
import ru.astrainteractive.soulkeeper.okio.ByteString;
import ru.astrainteractive.soulkeeper.okio.Segment;
import ru.astrainteractive.soulkeeper.okio.internal.-SegmentedByteString;
import ru.astrainteractive.soulkeeper.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.soulkeeper.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0001H\u0016J\b\u0010\u0015\u001a\u00020\u0001H\u0016J\u0015\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0018J\u001d\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u000fH\u0016J\u001c\u0010\u001d\u001a\u00020\u00012\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u001fH\u0016J\u0015\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b$J\r\u0010%\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b&J\b\u0010'\u001a\u00020\u0004H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J%\u0010*\u001a\u00020+2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b2J(\u00103\u001a\u0002042\u0006\u00100\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u00012\u0006\u00106\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fH\u0016J(\u00103\u001a\u0002042\u0006\u00100\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fH\u0016J,\u00107\u001a\u00020+2\b\b\u0002\u00100\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u00042\b\b\u0002\u00109\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fH\u0016J\u001a\u0010:\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u00042\b\b\u0002\u0010;\u001a\u00020\u001fH\u0016J\u001a\u0010<\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u00042\b\b\u0002\u0010;\u001a\u00020\u001fH\u0016J\b\u0010=\u001a\u00020\u0001H\u0002J\r\u0010>\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b?J\u0013\u0010@\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010AH\u0096\u0002J\b\u0010B\u001a\u00020\u001fH\u0016J\b\u0010C\u001a\u00020\u000fH\u0016J\b\u0010D\u001a\u00020EH\u0002R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006F"}, d2={"Lru/astrainteractive/soulkeeper/okio/SegmentedByteString;", "Lru/astrainteractive/soulkeeper/okio/ByteString;", "segments", "", "", "directory", "", "<init>", "([[B[I)V", "getSegments$okio", "()[[B", "[[B", "getDirectory$okio", "()[I", "string", "", "charset", "Ljava/nio/charset/Charset;", "base64", "hex", "toAsciiLowercase", "toAsciiUppercase", "digest", "algorithm", "digest$okio", "hmac", "key", "hmac$okio", "base64Url", "substring", "beginIndex", "", "endIndex", "internalGet", "", "pos", "internalGet$okio", "getSize", "getSize$okio", "toByteArray", "asByteBuffer", "Ljava/nio/ByteBuffer;", "write", "", "out", "Ljava/io/OutputStream;", "buffer", "Lru/astrainteractive/soulkeeper/okio/Buffer;", "offset", "byteCount", "write$okio", "rangeEquals", "", "other", "otherOffset", "copyInto", "target", "targetOffset", "indexOf", "fromIndex", "lastIndexOf", "toByteString", "internalArray", "internalArray$okio", "equals", "", "hashCode", "toString", "writeReplace", "Ljava/lang/Object;", "ru.astrainteractive.soulkeeper.okio"})
@SourceDebugExtension(value={"SMAP\nSegmentedByteString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentedByteString.kt\nokio/SegmentedByteString\n+ 2 SegmentedByteString.kt\nokio/internal/-SegmentedByteString\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n63#2,12:141\n63#2,12:153\n104#2,2:165\n106#2,26:168\n135#2,5:194\n142#2:199\n145#2,3:200\n63#2,8:203\n148#2,8:211\n71#2,4:219\n156#2:223\n63#2,12:224\n160#2:236\n85#2,10:237\n161#2,9:247\n95#2,4:256\n170#2,2:260\n179#2,4:262\n85#2,10:266\n183#2,3:276\n95#2,4:279\n186#2:283\n195#2,8:284\n85#2,10:292\n203#2,3:302\n95#2,4:305\n206#2:309\n215#2,5:310\n85#2,10:315\n220#2,3:325\n95#2,4:328\n223#2:332\n226#2,4:333\n234#2,6:337\n63#2,8:343\n240#2,7:351\n71#2,4:358\n247#2,2:362\n1#3:167\n*S KotlinDebug\n*F\n+ 1 SegmentedByteString.kt\nokio/SegmentedByteString\n*L\n54#1:141,12\n66#1:153,12\n78#1:165,2\n78#1:168,26\n80#1:194,5\n82#1:199\n84#1:200,3\n84#1:203,8\n84#1:211,8\n84#1:219,4\n84#1:223\n90#1:224,12\n96#1:236\n96#1:237,10\n96#1:247,9\n96#1:256,4\n96#1:260,2\n103#1:262,4\n103#1:266,10\n103#1:276,3\n103#1:279,4\n103#1:283\n110#1:284,8\n110#1:292,10\n110#1:302,3\n110#1:305,4\n110#1:309\n117#1:310,5\n117#1:315,10\n117#1:325,3\n117#1:328,4\n117#1:332\n131#1:333,4\n133#1:337,6\n133#1:343,8\n133#1:351,7\n133#1:358,4\n133#1:362,2\n78#1:167\n*E\n"})
public final class SegmentedByteString
extends ByteString {
    @NotNull
    private final transient byte[][] segments;
    @NotNull
    private final transient int[] directory;

    public SegmentedByteString(@NotNull byte[][] segments, @NotNull int[] directory) {
        Intrinsics.checkNotNullParameter(segments, "segments");
        Intrinsics.checkNotNullParameter(directory, "directory");
        super(ByteString.EMPTY.getData$okio());
        this.segments = segments;
        this.directory = directory;
    }

    @NotNull
    public final byte[][] getSegments$okio() {
        return this.segments;
    }

    @NotNull
    public final int[] getDirectory$okio() {
        return this.directory;
    }

    @Override
    @NotNull
    public String string(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        return this.toByteString().string(charset);
    }

    @Override
    @NotNull
    public String base64() {
        return this.toByteString().base64();
    }

    @Override
    @NotNull
    public String hex() {
        return this.toByteString().hex();
    }

    @Override
    @NotNull
    public ByteString toAsciiLowercase() {
        return this.toByteString().toAsciiLowercase();
    }

    @Override
    @NotNull
    public ByteString toAsciiUppercase() {
        return this.toByteString().toAsciiUppercase();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ByteString digest$okio(@NotNull String algorithm) {
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        MessageDigest $this$digest_u24lambda_u240 = MessageDigest.getInstance(algorithm);
        boolean bl = false;
        SegmentedByteString $this$forEachSegment$iv = this;
        boolean $i$f$forEachSegment = false;
        int segmentCount$iv = ((Object[])$this$forEachSegment$iv.getSegments$okio()).length;
        int pos$iv = 0;
        for (int s$iv = 0; s$iv < segmentCount$iv; ++s$iv) {
            void byteCount;
            void offset;
            int segmentPos$iv = $this$forEachSegment$iv.getDirectory$okio()[segmentCount$iv + s$iv];
            int nextSegmentOffset$iv = $this$forEachSegment$iv.getDirectory$okio()[s$iv];
            int n = nextSegmentOffset$iv - pos$iv;
            int n2 = segmentPos$iv;
            byte[] data = $this$forEachSegment$iv.getSegments$okio()[s$iv];
            boolean bl2 = false;
            $this$digest_u24lambda_u240.update(data, (int)offset, (int)byteCount);
            pos$iv = nextSegmentOffset$iv;
        }
        byte[] digestBytes = $this$digest_u24lambda_u240.digest();
        Intrinsics.checkNotNull(digestBytes);
        return new ByteString(digestBytes);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ByteString hmac$okio(@NotNull String algorithm, @NotNull ByteString key) {
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        Intrinsics.checkNotNullParameter(key, "key");
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key.toByteArray(), algorithm));
            SegmentedByteString $this$forEachSegment$iv = this;
            boolean $i$f$forEachSegment = false;
            int segmentCount$iv = ((Object[])$this$forEachSegment$iv.getSegments$okio()).length;
            int pos$iv = 0;
            for (int s$iv = 0; s$iv < segmentCount$iv; ++s$iv) {
                void byteCount;
                void offset;
                int segmentPos$iv = $this$forEachSegment$iv.getDirectory$okio()[segmentCount$iv + s$iv];
                int nextSegmentOffset$iv = $this$forEachSegment$iv.getDirectory$okio()[s$iv];
                int n = nextSegmentOffset$iv - pos$iv;
                int n2 = segmentPos$iv;
                byte[] data = $this$forEachSegment$iv.getSegments$okio()[s$iv];
                boolean bl = false;
                mac.update(data, (int)offset, (int)byteCount);
                pos$iv = nextSegmentOffset$iv;
            }
            byte[] byArray = mac.doFinal();
            Intrinsics.checkNotNullExpressionValue(byArray, "doFinal(...)");
            return new ByteString(byArray);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    @NotNull
    public String base64Url() {
        return this.toByteString().base64Url();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ByteString substring(int beginIndex, int endIndex) {
        ByteString byteString;
        void beginIndex$iv;
        void $this$commonSubstring$iv;
        SegmentedByteString segmentedByteString = this;
        int n = beginIndex;
        int endIndex$iv = endIndex;
        boolean $i$f$commonSubstring = false;
        int endIndex$iv2 = ru.astrainteractive.soulkeeper.okio.-SegmentedByteString.resolveDefaultParameter((ByteString)$this$commonSubstring$iv, endIndex$iv);
        if (!(beginIndex$iv >= 0)) {
            boolean $i$a$-require--SegmentedByteString$commonSubstring$1$iv22 = false;
            String $i$a$-require--SegmentedByteString$commonSubstring$1$iv22 = "beginIndex=" + (int)beginIndex$iv + " < 0";
            throw new IllegalArgumentException($i$a$-require--SegmentedByteString$commonSubstring$1$iv22.toString());
        }
        if (!(endIndex$iv2 <= $this$commonSubstring$iv.size())) {
            boolean $i$a$-require--SegmentedByteString$commonSubstring$2$iv22 = false;
            String $i$a$-require--SegmentedByteString$commonSubstring$2$iv22 = "endIndex=" + endIndex$iv2 + " > length(" + $this$commonSubstring$iv.size() + ')';
            throw new IllegalArgumentException($i$a$-require--SegmentedByteString$commonSubstring$2$iv22.toString());
        }
        int subLen$iv = endIndex$iv2 - beginIndex$iv;
        if (!(subLen$iv >= 0)) {
            boolean $i$a$-require--SegmentedByteString$commonSubstring$3$iv22 = false;
            String $i$a$-require--SegmentedByteString$commonSubstring$3$iv22 = "endIndex=" + endIndex$iv2 + " < beginIndex=" + (int)beginIndex$iv;
            throw new IllegalArgumentException($i$a$-require--SegmentedByteString$commonSubstring$3$iv22.toString());
        }
        if (beginIndex$iv == false && endIndex$iv2 == $this$commonSubstring$iv.size()) {
            byteString = (ByteString)$this$commonSubstring$iv;
        } else if (beginIndex$iv == endIndex$iv2) {
            byteString = ByteString.EMPTY;
        } else {
            int beginSegment$iv = -SegmentedByteString.segment((SegmentedByteString)$this$commonSubstring$iv, (int)beginIndex$iv);
            int endSegment$iv = -SegmentedByteString.segment((SegmentedByteString)$this$commonSubstring$iv, endIndex$iv2 - 1);
            byte[][] newSegments$iv = (byte[][])ArraysKt.copyOfRange((Object[])$this$commonSubstring$iv.getSegments$okio(), beginSegment$iv, endSegment$iv + 1);
            int[] newDirectory$iv = new int[((Object[])newSegments$iv).length * 2];
            int index$iv = 0;
            int s$iv = beginSegment$iv;
            if (s$iv <= endSegment$iv) {
                while (true) {
                    newDirectory$iv[index$iv] = Math.min($this$commonSubstring$iv.getDirectory$okio()[s$iv] - beginIndex$iv, subLen$iv);
                    newDirectory$iv[index$iv++ + ((Object[])newSegments$iv).length] = $this$commonSubstring$iv.getDirectory$okio()[s$iv + ((Object[])$this$commonSubstring$iv.getSegments$okio()).length];
                    if (s$iv == endSegment$iv) break;
                    ++s$iv;
                }
            }
            int segmentOffset$iv = beginSegment$iv == 0 ? 0 : $this$commonSubstring$iv.getDirectory$okio()[beginSegment$iv - 1];
            int n2 = ((Object[])newSegments$iv).length;
            newDirectory$iv[n2] = newDirectory$iv[n2] + (beginIndex$iv - segmentOffset$iv);
            byteString = new SegmentedByteString(newSegments$iv, newDirectory$iv);
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte internalGet$okio(int pos) {
        void $this$commonInternalGet$iv;
        SegmentedByteString segmentedByteString = this;
        int pos$iv = pos;
        boolean $i$f$commonInternalGet = false;
        ru.astrainteractive.soulkeeper.okio.-SegmentedByteString.checkOffsetAndCount($this$commonInternalGet$iv.getDirectory$okio()[((Object[])$this$commonInternalGet$iv.getSegments$okio()).length - 1], pos$iv, 1L);
        int segment$iv = -SegmentedByteString.segment((SegmentedByteString)$this$commonInternalGet$iv, pos$iv);
        int segmentOffset$iv = segment$iv == 0 ? 0 : $this$commonInternalGet$iv.getDirectory$okio()[segment$iv - 1];
        int segmentPos$iv = $this$commonInternalGet$iv.getDirectory$okio()[segment$iv + ((Object[])$this$commonInternalGet$iv.getSegments$okio()).length];
        return $this$commonInternalGet$iv.getSegments$okio()[segment$iv][pos$iv - segmentOffset$iv + segmentPos$iv];
    }

    @Override
    public int getSize$okio() {
        SegmentedByteString $this$commonGetSize$iv = this;
        boolean $i$f$commonGetSize = false;
        return $this$commonGetSize$iv.getDirectory$okio()[((Object[])$this$commonGetSize$iv.getSegments$okio()).length - 1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public byte[] toByteArray() {
        void var3_3;
        SegmentedByteString $this$commonToByteArray$iv = this;
        boolean $i$f$commonToByteArray = false;
        byte[] result$iv = new byte[$this$commonToByteArray$iv.size()];
        int resultPos$iv = 0;
        SegmentedByteString $this$forEachSegment$iv$iv = $this$commonToByteArray$iv;
        boolean $i$f$forEachSegment = false;
        int segmentCount$iv$iv = ((Object[])$this$forEachSegment$iv$iv.getSegments$okio()).length;
        int pos$iv$iv = 0;
        for (int s$iv$iv = 0; s$iv$iv < segmentCount$iv$iv; ++s$iv$iv) {
            void byteCount$iv;
            void offset$iv;
            int segmentPos$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[segmentCount$iv$iv + s$iv$iv];
            int nextSegmentOffset$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv];
            int n = nextSegmentOffset$iv$iv - pos$iv$iv;
            int n2 = segmentPos$iv$iv;
            byte[] data$iv = $this$forEachSegment$iv$iv.getSegments$okio()[s$iv$iv];
            boolean bl = false;
            ArraysKt.copyInto(data$iv, result$iv, resultPos$iv, (int)offset$iv, (int)(offset$iv + byteCount$iv));
            resultPos$iv += byteCount$iv;
            pos$iv$iv = nextSegmentOffset$iv$iv;
        }
        return var3_3;
    }

    @Override
    @NotNull
    public ByteBuffer asByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.toByteArray()).asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "asReadOnlyBuffer(...)");
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull OutputStream out) throws IOException {
        Intrinsics.checkNotNullParameter(out, "out");
        SegmentedByteString $this$forEachSegment$iv = this;
        boolean $i$f$forEachSegment = false;
        int segmentCount$iv = ((Object[])$this$forEachSegment$iv.getSegments$okio()).length;
        int pos$iv = 0;
        for (int s$iv = 0; s$iv < segmentCount$iv; ++s$iv) {
            void byteCount;
            void offset;
            int segmentPos$iv = $this$forEachSegment$iv.getDirectory$okio()[segmentCount$iv + s$iv];
            int nextSegmentOffset$iv = $this$forEachSegment$iv.getDirectory$okio()[s$iv];
            int n = nextSegmentOffset$iv - pos$iv;
            int n2 = segmentPos$iv;
            byte[] data = $this$forEachSegment$iv.getSegments$okio()[s$iv];
            boolean bl = false;
            out.write(data, (int)offset, (int)byteCount);
            pos$iv = nextSegmentOffset$iv;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write$okio(@NotNull Buffer buffer, int offset, int byteCount) {
        void buffer$iv;
        void beginIndex$iv$iv;
        void $this$forEachSegment$iv$iv;
        void offset$iv;
        void $this$commonWrite$iv;
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        SegmentedByteString segmentedByteString = this;
        Buffer buffer2 = buffer;
        int n = offset;
        int byteCount$iv = byteCount;
        boolean $i$f$commonWrite = false;
        void var9_9 = $this$commonWrite$iv;
        void var10_10 = offset$iv;
        void endIndex$iv$iv = offset$iv + byteCount$iv;
        boolean $i$f$forEachSegment = false;
        int s$iv$iv = -SegmentedByteString.segment((SegmentedByteString)$this$forEachSegment$iv$iv, (int)beginIndex$iv$iv);
        void pos$iv$iv = beginIndex$iv$iv;
        while (pos$iv$iv < endIndex$iv$iv) {
            void byteCount$iv2;
            void offset$iv2;
            int segmentOffset$iv$iv = s$iv$iv == 0 ? 0 : $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv - 1];
            int segmentSize$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv] - segmentOffset$iv$iv;
            int segmentPos$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[((Object[])$this$forEachSegment$iv$iv.getSegments$okio()).length + s$iv$iv];
            int byteCount$iv$iv = Math.min((int)endIndex$iv$iv, segmentOffset$iv$iv + segmentSize$iv$iv) - pos$iv$iv;
            int offset$iv$iv = segmentPos$iv$iv + (pos$iv$iv - segmentOffset$iv$iv);
            int n2 = byteCount$iv$iv;
            int n3 = offset$iv$iv;
            byte[] data$iv = $this$forEachSegment$iv$iv.getSegments$okio()[s$iv$iv];
            boolean bl = false;
            Segment segment$iv = new Segment(data$iv, (int)offset$iv2, (int)(offset$iv2 + byteCount$iv2), true, false);
            if (buffer$iv.head == null) {
                buffer$iv.head = segment$iv.next = (segment$iv.prev = segment$iv);
            } else {
                Segment segment = buffer$iv.head;
                Intrinsics.checkNotNull(segment);
                Segment segment2 = segment.prev;
                Intrinsics.checkNotNull(segment2);
                segment2.push(segment$iv);
            }
            pos$iv$iv += byteCount$iv$iv;
            ++s$iv$iv;
        }
        buffer$iv.setSize$okio(buffer$iv.size() + (long)byteCount$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean rangeEquals(int offset, @NotNull ByteString other, int otherOffset, int byteCount) {
        boolean bl;
        block4: {
            void $this$commonRangeEquals$iv;
            void offset$iv;
            Intrinsics.checkNotNullParameter(other, "other");
            SegmentedByteString segmentedByteString = this;
            int n = offset;
            ByteString byteString = other;
            int n2 = otherOffset;
            int byteCount$iv = byteCount;
            boolean $i$f$commonRangeEquals = false;
            if (offset$iv < 0 || offset$iv > $this$commonRangeEquals$iv.size() - byteCount$iv) {
                bl = false;
            } else {
                void beginIndex$iv$iv;
                void $this$forEachSegment$iv$iv;
                void otherOffset$iv;
                int otherOffset$iv2 = 0;
                otherOffset$iv2 = otherOffset$iv;
                void var12_12 = $this$commonRangeEquals$iv;
                void var13_13 = offset$iv;
                void endIndex$iv$iv = offset$iv + byteCount$iv;
                boolean $i$f$forEachSegment = false;
                int s$iv$iv = -SegmentedByteString.segment((SegmentedByteString)$this$forEachSegment$iv$iv, (int)beginIndex$iv$iv);
                void pos$iv$iv = beginIndex$iv$iv;
                while (pos$iv$iv < endIndex$iv$iv) {
                    void byteCount$iv2;
                    void offset$iv2;
                    void other$iv;
                    int segmentOffset$iv$iv = s$iv$iv == 0 ? 0 : $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv - 1];
                    int segmentSize$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv] - segmentOffset$iv$iv;
                    int segmentPos$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[((Object[])$this$forEachSegment$iv$iv.getSegments$okio()).length + s$iv$iv];
                    int byteCount$iv$iv = Math.min((int)endIndex$iv$iv, segmentOffset$iv$iv + segmentSize$iv$iv) - pos$iv$iv;
                    int offset$iv$iv = segmentPos$iv$iv + (pos$iv$iv - segmentOffset$iv$iv);
                    int n3 = byteCount$iv$iv;
                    int n4 = offset$iv$iv;
                    byte[] data$iv = $this$forEachSegment$iv$iv.getSegments$okio()[s$iv$iv];
                    boolean bl2 = false;
                    if (!other$iv.rangeEquals(otherOffset$iv2, data$iv, (int)offset$iv2, (int)byteCount$iv2)) {
                        bl = false;
                        break block4;
                    }
                    otherOffset$iv2 += byteCount$iv2;
                    pos$iv$iv += byteCount$iv$iv;
                    ++s$iv$iv;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean rangeEquals(int offset, @NotNull byte[] other, int otherOffset, int byteCount) {
        boolean bl;
        block4: {
            void other$iv;
            void otherOffset$iv;
            void $this$commonRangeEquals$iv;
            void offset$iv;
            Intrinsics.checkNotNullParameter(other, "other");
            SegmentedByteString segmentedByteString = this;
            int n = offset;
            byte[] byArray = other;
            int n2 = otherOffset;
            int byteCount$iv = byteCount;
            boolean $i$f$commonRangeEquals = false;
            if (offset$iv < 0 || offset$iv > $this$commonRangeEquals$iv.size() - byteCount$iv || otherOffset$iv < 0 || otherOffset$iv > ((void)other$iv).length - byteCount$iv) {
                bl = false;
            } else {
                void beginIndex$iv$iv;
                void $this$forEachSegment$iv$iv;
                int otherOffset$iv2 = 0;
                otherOffset$iv2 = otherOffset$iv;
                void var12_12 = $this$commonRangeEquals$iv;
                void var13_13 = offset$iv;
                void endIndex$iv$iv = offset$iv + byteCount$iv;
                boolean $i$f$forEachSegment = false;
                int s$iv$iv = -SegmentedByteString.segment((SegmentedByteString)$this$forEachSegment$iv$iv, (int)beginIndex$iv$iv);
                void pos$iv$iv = beginIndex$iv$iv;
                while (pos$iv$iv < endIndex$iv$iv) {
                    void byteCount$iv2;
                    void offset$iv2;
                    int segmentOffset$iv$iv = s$iv$iv == 0 ? 0 : $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv - 1];
                    int segmentSize$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv] - segmentOffset$iv$iv;
                    int segmentPos$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[((Object[])$this$forEachSegment$iv$iv.getSegments$okio()).length + s$iv$iv];
                    int byteCount$iv$iv = Math.min((int)endIndex$iv$iv, segmentOffset$iv$iv + segmentSize$iv$iv) - pos$iv$iv;
                    int offset$iv$iv = segmentPos$iv$iv + (pos$iv$iv - segmentOffset$iv$iv);
                    int n3 = byteCount$iv$iv;
                    int n4 = offset$iv$iv;
                    byte[] data$iv = $this$forEachSegment$iv$iv.getSegments$okio()[s$iv$iv];
                    boolean bl2 = false;
                    if (!ru.astrainteractive.soulkeeper.okio.-SegmentedByteString.arrayRangeEquals(data$iv, (int)offset$iv2, (byte[])other$iv, otherOffset$iv2, (int)byteCount$iv2)) {
                        bl = false;
                        break block4;
                    }
                    otherOffset$iv2 += byteCount$iv2;
                    pos$iv$iv += byteCount$iv$iv;
                    ++s$iv$iv;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void copyInto(int offset, @NotNull byte[] target, int targetOffset, int byteCount) {
        void beginIndex$iv$iv;
        void $this$forEachSegment$iv$iv;
        void targetOffset$iv;
        void target$iv;
        void offset$iv;
        void $this$commonCopyInto$iv;
        Intrinsics.checkNotNullParameter(target, "target");
        SegmentedByteString segmentedByteString = this;
        int n = offset;
        byte[] byArray = target;
        int n2 = targetOffset;
        int byteCount$iv = byteCount;
        boolean $i$f$commonCopyInto = false;
        ru.astrainteractive.soulkeeper.okio.-SegmentedByteString.checkOffsetAndCount($this$commonCopyInto$iv.size(), (long)offset$iv, byteCount$iv);
        ru.astrainteractive.soulkeeper.okio.-SegmentedByteString.checkOffsetAndCount(((void)target$iv).length, (long)targetOffset$iv, byteCount$iv);
        int targetOffset$iv2 = 0;
        targetOffset$iv2 = targetOffset$iv;
        void var12_12 = $this$commonCopyInto$iv;
        void var13_13 = offset$iv;
        void endIndex$iv$iv = offset$iv + byteCount$iv;
        boolean $i$f$forEachSegment = false;
        int s$iv$iv = -SegmentedByteString.segment((SegmentedByteString)$this$forEachSegment$iv$iv, (int)beginIndex$iv$iv);
        void pos$iv$iv = beginIndex$iv$iv;
        while (pos$iv$iv < endIndex$iv$iv) {
            void byteCount$iv2;
            void offset$iv2;
            int segmentOffset$iv$iv = s$iv$iv == 0 ? 0 : $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv - 1];
            int segmentSize$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv] - segmentOffset$iv$iv;
            int segmentPos$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[((Object[])$this$forEachSegment$iv$iv.getSegments$okio()).length + s$iv$iv];
            int byteCount$iv$iv = Math.min((int)endIndex$iv$iv, segmentOffset$iv$iv + segmentSize$iv$iv) - pos$iv$iv;
            int offset$iv$iv = segmentPos$iv$iv + (pos$iv$iv - segmentOffset$iv$iv);
            int n3 = byteCount$iv$iv;
            int n4 = offset$iv$iv;
            byte[] data$iv = $this$forEachSegment$iv$iv.getSegments$okio()[s$iv$iv];
            boolean bl = false;
            ArraysKt.copyInto(data$iv, (byte[])target$iv, targetOffset$iv2, (int)offset$iv2, (int)(offset$iv2 + byteCount$iv2));
            targetOffset$iv2 += byteCount$iv2;
            pos$iv$iv += byteCount$iv$iv;
            ++s$iv$iv;
        }
    }

    @Override
    public int indexOf(@NotNull byte[] other, int fromIndex) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.toByteString().indexOf(other, fromIndex);
    }

    @Override
    public int lastIndexOf(@NotNull byte[] other, int fromIndex) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.toByteString().lastIndexOf(other, fromIndex);
    }

    private final ByteString toByteString() {
        return new ByteString(this.toByteArray());
    }

    @Override
    @NotNull
    public byte[] internalArray$okio() {
        return this.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(@Nullable Object other) {
        void $this$commonEquals$iv;
        SegmentedByteString segmentedByteString = this;
        Object other$iv = other;
        boolean $i$f$commonEquals = false;
        return other$iv == $this$commonEquals$iv ? true : (other$iv instanceof ByteString ? ((ByteString)other$iv).size() == $this$commonEquals$iv.size() && $this$commonEquals$iv.rangeEquals(0, (ByteString)other$iv, 0, $this$commonEquals$iv.size()) : false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        int n;
        SegmentedByteString $this$commonHashCode$iv = this;
        boolean $i$f$commonHashCode = false;
        int result$iv = 0;
        result$iv = $this$commonHashCode$iv.getHashCode$okio();
        if (result$iv != 0) {
            n = result$iv;
        } else {
            void var3_3;
            result$iv = 1;
            SegmentedByteString $this$forEachSegment$iv$iv = $this$commonHashCode$iv;
            boolean $i$f$forEachSegment = false;
            int segmentCount$iv$iv = ((Object[])$this$forEachSegment$iv$iv.getSegments$okio()).length;
            int pos$iv$iv = 0;
            for (int s$iv$iv = 0; s$iv$iv < segmentCount$iv$iv; ++s$iv$iv) {
                void byteCount$iv;
                void offset$iv;
                int segmentPos$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[segmentCount$iv$iv + s$iv$iv];
                int nextSegmentOffset$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv];
                int n2 = nextSegmentOffset$iv$iv - pos$iv$iv;
                int n3 = segmentPos$iv$iv;
                byte[] data$iv = $this$forEachSegment$iv$iv.getSegments$okio()[s$iv$iv];
                boolean bl = false;
                void limit$iv = offset$iv + byteCount$iv;
                for (void i$iv = offset$iv; i$iv < limit$iv; ++i$iv) {
                    result$iv = 31 * result$iv + data$iv[i$iv];
                }
                pos$iv$iv = nextSegmentOffset$iv$iv;
            }
            $this$commonHashCode$iv.setHashCode$okio(result$iv);
            n = var3_3;
        }
        return n;
    }

    @Override
    @NotNull
    public String toString() {
        return this.toByteString().toString();
    }

    private final Object writeReplace() {
        ByteString byteString = this.toByteString();
        Intrinsics.checkNotNull(byteString, "null cannot be cast to non-null type java.lang.Object");
        return byteString;
    }
}

