/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.javatime;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ru.astrainteractive.soulkeeper.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.soulkeeper.org.jetbrains.annotations.Nullable;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.ColumnType;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.IDateColumnType;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.H2Dialect;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.MysqlDialect;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.OracleDialect;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001d\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ%\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Lru/astrainteractive/soulkeeper/org/jetbrains/exposed/sql/javatime/JavaLocalDateTimeColumnType;", "Lru/astrainteractive/soulkeeper/org/jetbrains/exposed/sql/ColumnType;", "Ljava/time/LocalDateTime;", "Lru/astrainteractive/soulkeeper/org/jetbrains/exposed/sql/IDateColumnType;", "<init>", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "sqlType", "", "nonNullValueToString", "value", "valueFromDB", "", "notNullValueToDB", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "nonNullValueAsDefaultString", "longToLocalDateTime", "kotlin.jvm.PlatformType", "millis", "", "(J)Ljava/time/LocalDateTime;", "seconds", "nanos", "(JJ)Ljava/time/LocalDateTime;", "Companion", "exposed-java-time"})
@SourceDebugExtension(value={"SMAP\nJavaDateColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaDateColumnType.kt\norg/jetbrains/exposed/sql/javatime/JavaLocalDateTimeColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,552:1\n1#2:553\n*E\n"})
public final class JavaLocalDateTimeColumnType
extends ColumnType<LocalDateTime>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaLocalDateTimeColumnType INSTANCE = new JavaLocalDateTimeColumnType();

    public JavaLocalDateTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().dateTimeType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull LocalDateTime value) {
        String string;
        Intrinsics.checkNotNullParameter(value, "value");
        Instant instant = Instant.from(value.atZone(ZoneId.systemDefault()));
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof SQLiteDialect) {
            string = '\'' + JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(instant) + '\'';
        } else if (dialect instanceof OracleDialect) {
            Intrinsics.checkNotNull(instant);
            string = JavaDateColumnTypeKt.access$oracleDateTimeLiteral(instant);
        } else if (dialect instanceof MysqlDialect) {
            DateTimeFormatter formatter = ((MysqlDialect)dialect).isFractionDateTimeSupported() ? JavaDateColumnTypeKt.access$getMYSQL_FRACTION_DATE_TIME_STRING_FORMATTER() : JavaDateColumnTypeKt.access$getMYSQL_DATE_TIME_STRING_FORMATTER();
            string = '\'' + formatter.format(instant) + '\'';
        } else {
            string = '\'' + JavaDateColumnTypeKt.access$getDEFAULT_DATE_TIME_STRING_FORMATTER().format(instant) + '\'';
        }
        return string;
    }

    @Override
    @Nullable
    public LocalDateTime valueFromDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        return object instanceof LocalDateTime ? (LocalDateTime)value : (object instanceof Date ? this.longToLocalDateTime(((Date)value).getTime()) : (object instanceof Timestamp ? this.longToLocalDateTime(((Timestamp)value).getTime() / (long)1000, ((Timestamp)value).getNanos()) : (object instanceof Integer ? this.longToLocalDateTime(((Number)value).intValue()) : (object instanceof Long ? this.longToLocalDateTime(((Number)value).longValue()) : (object instanceof String ? LocalDateTime.parse((CharSequence)value, JavaDateColumnTypeKt.access$formatterForDateString((String)value)) : (object instanceof OffsetDateTime ? ((OffsetDateTime)value).toLocalDateTime() : this.valueFromDB(value.toString())))))));
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull LocalDateTime value) {
        Object object;
        Intrinsics.checkNotNullParameter(value, "value");
        if (DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect) {
            object = JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(value.atZone(ZoneId.systemDefault()));
        } else {
            Timestamp timestamp;
            Instant instant = value.atZone(ZoneId.systemDefault()).toInstant();
            Timestamp $this$notNullValueToDB_u24lambda_u240 = timestamp = new Timestamp(instant.toEpochMilli());
            boolean bl = false;
            $this$notNullValueToDB_u24lambda_u240.setNanos(instant.getNano());
            object = timestamp;
        }
        return object;
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        return DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect ? rs.getObject(index, Timestamp.class) : super.readObject(rs, index);
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(@NotNull LocalDateTime value) {
        String string;
        Intrinsics.checkNotNullParameter(value, "value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof PostgreSQLDialect) {
            StringBuilder stringBuilder = new StringBuilder().append('\'');
            String string2 = JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(value);
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            char[] cArray = new char[]{'0'};
            String string3 = StringsKt.trimEnd(string2, cArray);
            cArray = new char[]{'.'};
            string = stringBuilder.append(StringsKt.trimEnd(string3, cArray)).append("'::timestamp without time zone").toString();
        } else {
            H2Dialect h2Dialect = dialect instanceof H2Dialect ? (H2Dialect)dialect : null;
            if ((h2Dialect != null ? h2Dialect.getH2Mode() : null) == H2Dialect.H2CompatibilityMode.Oracle) {
                StringBuilder stringBuilder = new StringBuilder().append('\'');
                String string4 = JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(value);
                Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
                char[] cArray = new char[]{'0'};
                String string5 = StringsKt.trimEnd(string4, cArray);
                cArray = new char[]{'.'};
                string = stringBuilder.append(StringsKt.trimEnd(string5, cArray)).append('\'').toString();
            } else {
                string = super.nonNullValueAsDefaultString(value);
            }
        }
        return string;
    }

    private final LocalDateTime longToLocalDateTime(long millis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
    }

    private final LocalDateTime longToLocalDateTime(long seconds, long nanos) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(seconds, nanos), ZoneId.systemDefault());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/astrainteractive/soulkeeper/org/jetbrains/exposed/sql/javatime/JavaLocalDateTimeColumnType$Companion;", "", "<init>", "()V", "INSTANCE", "Lru/astrainteractive/soulkeeper/org/jetbrains/exposed/sql/javatime/JavaLocalDateTimeColumnType;", "getINSTANCE$exposed_java_time", "()Lru/astrainteractive/soulkeeper/org/jetbrains/exposed/sql/javatime/JavaLocalDateTimeColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaLocalDateTimeColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

