/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.javatime;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.soulkeeper.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.ColumnType;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.IDateColumnType;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.H2Dialect;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.H2Kt;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.MysqlDialect;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.OracleDialect;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import ru.astrainteractive.soulkeeper.org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001d\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lru/astrainteractive/soulkeeper/org/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "Lru/astrainteractive/soulkeeper/org/jetbrains/exposed/sql/ColumnType;", "Ljava/time/LocalTime;", "Lru/astrainteractive/soulkeeper/org/jetbrains/exposed/sql/IDateColumnType;", "<init>", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "sqlType", "", "nonNullValueToString", "value", "valueFromDB", "", "notNullValueToDB", "nonNullValueAsDefaultString", "longToLocalTime", "kotlin.jvm.PlatformType", "millis", "", "(J)Ljava/time/LocalTime;", "Companion", "exposed-java-time"})
public final class JavaLocalTimeColumnType
extends ColumnType<LocalTime>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaLocalTimeColumnType INSTANCE = new JavaLocalTimeColumnType();

    public JavaLocalTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().timeType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull LocalTime value) {
        Intrinsics.checkNotNullParameter(value, "value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof OracleDialect || H2Kt.getH2Mode(dialect) == H2Dialect.H2CompatibilityMode.Oracle) {
            return "TIMESTAMP '" + JavaDateColumnTypeKt.access$getORACLE_TIME_STRING_FORMATTER().format(value) + '\'';
        }
        return '\'' + JavaDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER().format(value) + '\'';
    }

    @Override
    @NotNull
    public LocalTime valueFromDB(@NotNull Object value) {
        LocalTime localTime;
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        if (object instanceof LocalTime) {
            localTime = (LocalTime)value;
        } else if (object instanceof Time) {
            LocalTime localTime2 = ((Time)value).toLocalTime();
            localTime = localTime2;
            Intrinsics.checkNotNullExpressionValue(localTime2, "toLocalTime(...)");
        } else if (object instanceof Timestamp) {
            LocalTime localTime3 = ((Timestamp)value).toLocalDateTime().toLocalTime();
            localTime = localTime3;
            Intrinsics.checkNotNullExpressionValue(localTime3, "toLocalTime(...)");
        } else if (object instanceof Integer) {
            LocalTime localTime4 = this.longToLocalTime(((Number)value).intValue());
            localTime = localTime4;
            Intrinsics.checkNotNullExpressionValue(localTime4, "longToLocalTime(...)");
        } else if (object instanceof Long) {
            LocalTime localTime5 = this.longToLocalTime(((Number)value).longValue());
            localTime = localTime5;
            Intrinsics.checkNotNullExpressionValue(localTime5, "longToLocalTime(...)");
        } else if (object instanceof String) {
            DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
            DateTimeFormatter formatter = dialect instanceof OracleDialect || H2Kt.getH2Mode(dialect) == H2Dialect.H2CompatibilityMode.Oracle ? JavaDateColumnTypeKt.access$formatterForDateString((String)value) : JavaDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER();
            LocalTime localTime6 = LocalTime.parse((CharSequence)value, formatter);
            Intrinsics.checkNotNull(localTime6);
            localTime = localTime6;
        } else {
            localTime = this.valueFromDB(value.toString());
        }
        return localTime;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull LocalTime value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? JavaDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER().format(value) : (H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? JavaDateColumnTypeKt.access$getORACLE_TIME_STRING_FORMATTER().format(value) : Time.valueOf(value));
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(@NotNull LocalTime value) {
        Intrinsics.checkNotNullParameter(value, "value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        return databaseDialect instanceof PostgreSQLDialect ? this.nonNullValueToString(value) + "::time without time zone" : (databaseDialect instanceof MysqlDialect ? '\'' + JavaDateColumnTypeKt.access$getMYSQL_TIME_AS_DEFAULT_STRING_FORMATTER().format(value) + '\'' : super.nonNullValueAsDefaultString(value));
    }

    private final LocalTime longToLocalTime(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalTime();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/astrainteractive/soulkeeper/org/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType$Companion;", "", "<init>", "()V", "INSTANCE", "Lru/astrainteractive/soulkeeper/org/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "getINSTANCE$exposed_java_time", "()Lru/astrainteractive/soulkeeper/org/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaLocalTimeColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

