/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import mekanism.client.render.FluidRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.tile.TileEntityDynamicTank;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderDynamicTank
extends TileEntitySpecialRenderer<TileEntityDynamicTank> {
    public void render(TileEntityDynamicTank tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        if (tileEntity.clientHasStructure && tileEntity.isRendering && tileEntity.structure != null && ((SynchronizedTankData)tileEntity.structure).fluidStored != null && ((SynchronizedTankData)tileEntity.structure).fluidStored.amount != 0) {
            FluidRenderer.RenderData data = new FluidRenderer.RenderData();
            data.location = ((SynchronizedTankData)tileEntity.structure).renderLocation;
            data.height = ((SynchronizedTankData)tileEntity.structure).volHeight - 2;
            data.length = ((SynchronizedTankData)tileEntity.structure).volLength;
            data.width = ((SynchronizedTankData)tileEntity.structure).volWidth;
            data.fluidType = ((SynchronizedTankData)tileEntity.structure).fluidStored;
            if (data.location != null && data.height >= 1) {
                this.func_147499_a(TextureMap.field_110575_b);
                GlStateManager.func_179094_E();
                GlStateManager.func_179089_o();
                GlStateManager.func_179147_l();
                GlStateManager.func_179140_f();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_190053_a(true);
                FluidRenderer.translateToOrigin(data.location);
                MekanismRenderer.GlowInfo glowInfo = MekanismRenderer.enableGlow(data.fluidType);
                MekanismRenderer.color(data.fluidType, (float)data.fluidType.amount / (float)tileEntity.clientCapacity);
                if (data.fluidType.getFluid().isGaseous(data.fluidType)) {
                    FluidRenderer.getTankDisplay(data).render();
                } else {
                    FluidRenderer.getTankDisplay(data, tileEntity.prevScale).render();
                }
                MekanismRenderer.resetColor();
                MekanismRenderer.disableGlow(glowInfo);
                GlStateManager.func_179121_F();
                for (SynchronizedTankData.ValveData valveData : tileEntity.valveViewing) {
                    GlStateManager.func_179094_E();
                    FluidRenderer.translateToOrigin(valveData.location);
                    MekanismRenderer.GlowInfo valveGlowInfo = MekanismRenderer.enableGlow(data.fluidType);
                    MekanismRenderer.color(data.fluidType);
                    FluidRenderer.getValveDisplay(FluidRenderer.ValveRenderData.get(data, valveData)).render();
                    MekanismRenderer.disableGlow(valveGlowInfo);
                    GlStateManager.func_179121_F();
                }
                MekanismRenderer.resetColor();
                this.func_190053_a(false);
                GlStateManager.func_179145_e();
                GlStateManager.func_179084_k();
                GlStateManager.func_179129_p();
            }
        }
    }
}

