/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.MekanismAPI;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.OreGas;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.client.ClientTickHandler;
import mekanism.common.BoxBlacklistParser;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.CommonPlayerTracker;
import mekanism.common.CommonProxy;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.CoreGuiHandler;
import mekanism.common.CreativeTabMekanism;
import mekanism.common.FuelHandler;
import mekanism.common.KeySync;
import mekanism.common.MekFakePlayer;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismFluids;
import mekanism.common.MekanismItems;
import mekanism.common.MekanismSounds;
import mekanism.common.PacketHandler;
import mekanism.common.PlayerState;
import mekanism.common.Resource;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.chunkloading.ChunkManager;
import mekanism.common.command.CommandMek;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.entity.EntityBabySkeleton;
import mekanism.common.entity.EntityBalloon;
import mekanism.common.entity.EntityFlame;
import mekanism.common.entity.EntityObsidianTNT;
import mekanism.common.entity.EntityRobit;
import mekanism.common.fixers.MekanismDataFixers;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.integration.IMCHandler;
import mekanism.common.integration.MekanismHooks;
import mekanism.common.integration.multipart.MultipartMekanism;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.network.PacketTransmitterUpdate;
import mekanism.common.recipe.BinRecipe;
import mekanism.common.recipe.GasConversionHandler;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.SmeltingRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.tier.BaseTier;
import mekanism.common.tile.TileEntityAdvancedBoundingBlock;
import mekanism.common.tile.TileEntityAdvancedFactory;
import mekanism.common.tile.TileEntityAmbientAccumulator;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.tile.TileEntityBoilerValve;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.TileEntityCardboardBox;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.TileEntityChemicalCrystallizer;
import mekanism.common.tile.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.TileEntityChemicalInfuser;
import mekanism.common.tile.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.TileEntityChemicalOxidizer;
import mekanism.common.tile.TileEntityChemicalWasher;
import mekanism.common.tile.TileEntityCombiner;
import mekanism.common.tile.TileEntityCrusher;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.TileEntityDynamicValve;
import mekanism.common.tile.TileEntityElectricPump;
import mekanism.common.tile.TileEntityElectrolyticSeparator;
import mekanism.common.tile.TileEntityEliteFactory;
import mekanism.common.tile.TileEntityEnergizedSmelter;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.TileEntityEnrichmentChamber;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityFluidicPlenisher;
import mekanism.common.tile.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.TileEntityFuelwoodHeater;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.TileEntityGlowPanel;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionPort;
import mekanism.common.tile.TileEntityInductionProvider;
import mekanism.common.tile.TileEntityLaser;
import mekanism.common.tile.TileEntityLaserAmplifier;
import mekanism.common.tile.TileEntityLaserTractorBeam;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityMetallurgicInfuser;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.tile.TileEntityOsmiumCompressor;
import mekanism.common.tile.TileEntityPRC;
import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.tile.TileEntityPrecisionSawmill;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.tile.TileEntityPurificationChamber;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.tile.TileEntityRotaryCondensentrator;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.TileEntitySeismicVibrator;
import mekanism.common.tile.TileEntitySolarNeutronActivator;
import mekanism.common.tile.TileEntityStructuralGlass;
import mekanism.common.tile.TileEntitySuperheatingElement;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.tile.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.tile.TileEntityThermalEvaporationValve;
import mekanism.common.tile.transmitter.TileEntityDiversionTransporter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import mekanism.common.tile.transmitter.TileEntityRestrictiveTransporter;
import mekanism.common.tile.transmitter.TileEntityThermodynamicConductor;
import mekanism.common.tile.transmitter.TileEntityUniversalCable;
import mekanism.common.transmitters.grid.EnergyNetwork;
import mekanism.common.transmitters.grid.FluidNetwork;
import mekanism.common.transmitters.grid.GasNetwork;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.voice.VoiceServerManager;
import mekanism.common.world.GenHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="mekanism", useMetadata=true, guiFactory="mekanism.client.gui.ConfigGuiFactory", acceptedMinecraftVersions="[1.12,1.13)", version="9.12.12")
@Mod.EventBusSubscriber
public class Mekanism {
    public static final String MODID = "mekanism";
    public static final String MOD_NAME = "Mekanism";
    public static final String LOG_TAG = "[Mekanism]";
    public static final PlayerState playerState = new PlayerState();
    public static final Set<UUID> freeRunnerOn = new HashSet<UUID>();
    public static PacketHandler packetHandler = new PacketHandler();
    public static Logger logger = LogManager.getLogger((String)"Mekanism");
    @SidedProxy(clientSide="mekanism.client.ClientProxy", serverSide="mekanism.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="mekanism")
    public static Mekanism instance;
    public static MekanismHooks hooks;
    public static Configuration configuration;
    public static Configuration configurationce;
    public static Configuration configurationgenerators;
    public static Configuration configurationtools;
    public static Version versionNumber;
    public static MultiblockManager<SynchronizedTankData> tankManager;
    public static MultiblockManager<SynchronizedMatrixData> matrixManager;
    public static MultiblockManager<SynchronizedBoilerData> boilerManager;
    public static FrequencyManager publicTeleporters;
    public static Map<UUID, FrequencyManager> privateTeleporters;
    public static FrequencyManager publicEntangloporters;
    public static Map<UUID, FrequencyManager> privateEntangloporters;
    public static FrequencyManager securityFrequencies;
    public static CreativeTabMekanism tabMekanism;
    public static List<IModule> modulesLoaded;
    public static CommonWorldTickHandler worldTickHandler;
    public static GenHandler genHandler;
    public static int baseWorldGenVersion;
    public static VoiceServerManager voiceManager;
    public static GameProfile gameProfile;
    public static KeySync keyMap;
    public static Set<Coord4D> activeVibrators;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        MekanismBlocks.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        MekanismItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
        MekanismBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        Mekanism.registerOreDict();
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "ObsidianTNT"), EntityObsidianTNT.class, (String)"ObsidianTNT", (int)0, (Object)instance, (int)64, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "Robit"), EntityRobit.class, (String)"Robit", (int)1, (Object)instance, (int)64, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "Balloon"), EntityBalloon.class, (String)"Balloon", (int)2, (Object)instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "BabySkeleton"), EntityBabySkeleton.class, (String)"BabySkeleton", (int)3, (Object)instance, (int)64, (int)5, (boolean)true, (int)0xFFFFFF, (int)0x800080);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "Flame"), EntityFlame.class, (String)"Flame", (int)4, (Object)instance, (int)64, (int)5, (boolean)true);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        proxy.registerBlockRenders();
        proxy.registerItemRenders();
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        MekanismSounds.register((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register((IForgeRegistryEntry)new BinRecipe());
        Mekanism.addRecipes();
        GasConversionHandler.addDefaultGasMappings();
    }

    public static void addRecipes() {
        int i;
        GameRegistry.addSmelting((ItemStack)new ItemStack(MekanismBlocks.OreBlock, 1, 0), (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 1), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(MekanismBlocks.OreBlock, 1, 1), (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 5), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(MekanismBlocks.OreBlock, 1, 2), (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 6), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(MekanismItems.Dust, 1, Resource.OSMIUM.ordinal()), (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 1), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(MekanismItems.Dust, 1, Resource.IRON.ordinal()), (ItemStack)new ItemStack(Items.field_151042_j), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(MekanismItems.Dust, 1, Resource.GOLD.ordinal()), (ItemStack)new ItemStack(Items.field_151043_k), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(MekanismItems.OtherDust, 1, 1), (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 4), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(MekanismItems.Dust, 1, Resource.COPPER.ordinal()), (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 5), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(MekanismItems.Dust, 1, Resource.TIN.ordinal()), (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 6), (float)0.0f);
        if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.ENRICHMENT_CHAMBER)) {
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Blocks.field_150343_Z), new ItemStack(MekanismItems.OtherDust, 4, 6));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Items.field_151044_h, 1, 0), new ItemStack(MekanismItems.CompressedCarbon));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Items.field_151044_h, 1, 1), new ItemStack(MekanismItems.CompressedCarbon));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Items.field_151137_ax), new ItemStack(MekanismItems.CompressedRedstone));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Blocks.field_150341_Y), new ItemStack(Blocks.field_150347_e));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Blocks.field_150348_b), new ItemStack(Blocks.field_150417_aV, 1, 2));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150351_n));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Blocks.field_150351_n), new ItemStack(Blocks.field_150347_e));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Items.field_151016_H), new ItemStack(Items.field_151145_ak));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Blocks.field_150417_aV, 1, 2), new ItemStack(Blocks.field_150417_aV, 1, 0));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Blocks.field_150417_aV, 1, 0), new ItemStack(Blocks.field_150417_aV, 1, 3));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Blocks.field_150417_aV, 1, 1), new ItemStack(Blocks.field_150417_aV, 1, 0));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Blocks.field_150426_aN), new ItemStack(Items.field_151114_aO, 4));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Blocks.field_150435_aG), new ItemStack(Items.field_151119_aD, 4));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(MekanismBlocks.SaltBlock), new ItemStack(MekanismItems.Salt, 4));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(Items.field_151045_i), new ItemStack(MekanismItems.CompressedDiamond));
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(MekanismItems.Polyethene, 3, 0), new ItemStack(MekanismItems.Polyethene, 1, 2));
            for (i = 0; i < EnumColor.DYES.length; ++i) {
                RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(MekanismBlocks.PlasticBlock, 1, i), new ItemStack(MekanismBlocks.SlickPlasticBlock, 1, i));
            }
        }
        if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.COMBINER)) {
            RecipeHandler.addCombinerRecipe(new ItemStack(Items.field_151145_ak), new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150351_n));
            RecipeHandler.addCombinerRecipe(new ItemStack(Items.field_151044_h, 3), new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150365_q));
        }
        if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.OSMIUM_COMPRESSOR)) {
            RecipeHandler.addOsmiumCompressorRecipe(new ItemStack(Items.field_151114_aO), new ItemStack(MekanismItems.Ingot, 1, 3));
        }
        if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.CRUSHER)) {
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151042_j), new ItemStack(MekanismItems.Dust, 1, Resource.IRON.ordinal()));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151043_k), new ItemStack(MekanismItems.Dust, 1, Resource.GOLD.ordinal()));
            RecipeHandler.addCrusherRecipe(new ItemStack(Blocks.field_150351_n), new ItemStack((Block)Blocks.field_150354_m));
            RecipeHandler.addCrusherRecipe(new ItemStack(Blocks.field_150348_b), new ItemStack(Blocks.field_150347_e));
            RecipeHandler.addCrusherRecipe(new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150351_n));
            RecipeHandler.addCrusherRecipe(new ItemStack(Blocks.field_150417_aV, 1, 2), new ItemStack(Blocks.field_150348_b));
            RecipeHandler.addCrusherRecipe(new ItemStack(Blocks.field_150417_aV, 1, 0), new ItemStack(Blocks.field_150417_aV, 1, 2));
            RecipeHandler.addCrusherRecipe(new ItemStack(Blocks.field_150417_aV, 1, 3), new ItemStack(Blocks.field_150417_aV, 1, 0));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151145_ak), new ItemStack(Items.field_151016_H));
            RecipeHandler.addCrusherRecipe(new ItemStack(Blocks.field_150322_A), new ItemStack((Block)Blocks.field_150354_m, 2));
            RecipeHandler.addCrusherRecipe(new ItemStack(Blocks.field_180395_cM), new ItemStack((Block)Blocks.field_150354_m, 2, 1));
            for (i = 0; i < 16; ++i) {
                RecipeHandler.addCrusherRecipe(new ItemStack(Blocks.field_150325_L, 1, i), new ItemStack(Items.field_151007_F, 4));
            }
            RecipeHandler.addCrusherRecipe(new ItemStack((Block)Blocks.field_150329_H), new ItemStack(MekanismItems.BioFuel, 4));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151120_aE), new ItemStack(MekanismItems.BioFuel, 2));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151014_N), new ItemStack(MekanismItems.BioFuel, 2));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151015_O), new ItemStack(MekanismItems.BioFuel, 4));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151080_bb), new ItemStack(MekanismItems.BioFuel, 2));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151081_bc), new ItemStack(MekanismItems.BioFuel, 2));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151034_e), new ItemStack(MekanismItems.BioFuel, 4));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151025_P), new ItemStack(MekanismItems.BioFuel, 4));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151174_bG), new ItemStack(MekanismItems.BioFuel, 4));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151172_bF), new ItemStack(MekanismItems.BioFuel, 4));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151078_bh), new ItemStack(MekanismItems.BioFuel, 2));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151127_ba), new ItemStack(MekanismItems.BioFuel, 4));
            RecipeHandler.addCrusherRecipe(new ItemStack(Blocks.field_150423_aK), new ItemStack(MekanismItems.BioFuel, 6));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151168_bH), new ItemStack(MekanismItems.BioFuel, 4));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151170_bI), new ItemStack(MekanismItems.BioFuel, 4));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_185164_cV), new ItemStack(MekanismItems.BioFuel, 4));
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_185163_cU), new ItemStack(MekanismItems.BioFuel, 2));
            RecipeHandler.addCrusherRecipe(new ItemStack((Block)Blocks.field_150434_aF), new ItemStack(MekanismItems.BioFuel, 2));
        }
        if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.PURIFICATION_CHAMBER)) {
            RecipeHandler.addPurificationChamberRecipe(new ItemStack(Blocks.field_150351_n), new ItemStack(Items.field_151145_ak));
        }
        if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER)) {
            RecipeHandler.addChemicalInjectionChamberRecipe(new ItemStack(Blocks.field_150346_d), MekanismFluids.Water, new ItemStack(Blocks.field_150435_aG));
            RecipeHandler.addChemicalInjectionChamberRecipe(new ItemStack(Blocks.field_150405_ch), MekanismFluids.Water, new ItemStack(Blocks.field_150435_aG));
            RecipeHandler.addChemicalInjectionChamberRecipe(new ItemStack(Items.field_151118_aC), MekanismFluids.Water, new ItemStack(Items.field_151119_aD));
            RecipeHandler.addChemicalInjectionChamberRecipe(new ItemStack(Items.field_151016_H), MekanismFluids.HydrogenChloride, new ItemStack(MekanismItems.OtherDust, 1, 3));
        }
        if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.PRECISION_SAWMILL)) {
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_150468_ap, 3), new ItemStack(Items.field_151055_y, 7));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_150478_aa, 4), new ItemStack(Items.field_151055_y), new ItemStack(Items.field_151044_h), 1.0);
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_150421_aI), new ItemStack(Blocks.field_150344_f, 8), new ItemStack(Items.field_151045_i), 1.0);
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_150342_X), new ItemStack(Blocks.field_150344_f, 6), new ItemStack(Items.field_151122_aG, 3), 1.0);
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_150452_aw), new ItemStack(Blocks.field_150344_f, 2));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_150323_B), new ItemStack(Blocks.field_150344_f, 8), new ItemStack(Items.field_151137_ax), 1.0);
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_150429_aA), new ItemStack(Items.field_151055_y), new ItemStack(Items.field_151137_ax), 1.0);
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_150462_ai), new ItemStack(Blocks.field_150344_f, 4));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack((Block)Blocks.field_150486_ae), new ItemStack(Blocks.field_150344_f, 8));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_150447_bR), new ItemStack(Blocks.field_150344_f, 8), new ItemStack((Block)Blocks.field_150479_bC), 0.75);
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Items.field_151124_az), new ItemStack(Blocks.field_150344_f, 5));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Items.field_185150_aH), new ItemStack(Blocks.field_150344_f, 5, 1));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Items.field_185151_aI), new ItemStack(Blocks.field_150344_f, 5, 2));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Items.field_185152_aJ), new ItemStack(Blocks.field_150344_f, 5, 3));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Items.field_185153_aK), new ItemStack(Blocks.field_150344_f, 5, 4));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Items.field_185154_aL), new ItemStack(Blocks.field_150344_f, 5, 5));
            for (i = 0; i < 16; ++i) {
                RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Items.field_151104_aV, 1, i), new ItemStack(Blocks.field_150344_f, 3), new ItemStack(Blocks.field_150325_L, 3, i), 1.0);
            }
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_150415_aT), new ItemStack(Blocks.field_150344_f, 1));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Items.field_179570_aq), new ItemStack(Blocks.field_150344_f, 2, 0));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Items.field_179569_ar), new ItemStack(Blocks.field_150344_f, 2, 1));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Items.field_179568_as), new ItemStack(Blocks.field_150344_f, 2, 2));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Items.field_179567_at), new ItemStack(Blocks.field_150344_f, 2, 3));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Items.field_179572_au), new ItemStack(Blocks.field_150344_f, 2, 4));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Items.field_179571_av), new ItemStack(Blocks.field_150344_f, 2, 5));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_180407_aO), new ItemStack(Items.field_151055_y, 3));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_180408_aP), new ItemStack(Items.field_151055_y, 3));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_180404_aQ), new ItemStack(Items.field_151055_y, 3));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_180403_aR), new ItemStack(Items.field_151055_y, 3));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_180405_aT), new ItemStack(Items.field_151055_y, 3));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_180406_aS), new ItemStack(Items.field_151055_y, 3));
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_180390_bo), new ItemStack(Blocks.field_150344_f, 2, 0), new ItemStack(Items.field_151055_y, 4), 1.0);
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_180391_bp), new ItemStack(Blocks.field_150344_f, 2, 1), new ItemStack(Items.field_151055_y, 4), 1.0);
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_180392_bq), new ItemStack(Blocks.field_150344_f, 2, 2), new ItemStack(Items.field_151055_y, 4), 1.0);
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_180386_br), new ItemStack(Blocks.field_150344_f, 2, 3), new ItemStack(Items.field_151055_y, 4), 1.0);
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_180387_bt), new ItemStack(Blocks.field_150344_f, 2, 4), new ItemStack(Items.field_151055_y, 4), 1.0);
            RecipeHandler.addPrecisionSawmillRecipe(new ItemStack(Blocks.field_180385_bs), new ItemStack(Blocks.field_150344_f, 2, 5), new ItemStack(Items.field_151055_y, 4), 1.0);
        }
        if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.METALLURGIC_INFUSER)) {
            InfuseType carbon = InfuseRegistry.get("CARBON");
            InfuseType bio = InfuseRegistry.get("BIO");
            InfuseType redstone = InfuseRegistry.get("REDSTONE");
            InfuseType fungi = InfuseRegistry.get("FUNGI");
            InfuseType diamond = InfuseRegistry.get("DIAMOND");
            InfuseType obsidian = InfuseRegistry.get("OBSIDIAN");
            InfuseRegistry.registerInfuseObject(new ItemStack(MekanismItems.BioFuel), new InfuseObject(bio, 5));
            InfuseRegistry.registerInfuseObject(new ItemStack(Items.field_151044_h, 1, 0), new InfuseObject(carbon, 10));
            InfuseRegistry.registerInfuseObject(new ItemStack(Items.field_151044_h, 1, 1), new InfuseObject(carbon, 20));
            InfuseRegistry.registerInfuseObject(new ItemStack(Blocks.field_150402_ci, 1, 0), new InfuseObject(carbon, 90));
            InfuseRegistry.registerInfuseObject(new ItemStack(MekanismBlocks.BasicBlock, 1, 3), new InfuseObject(carbon, 180));
            InfuseRegistry.registerInfuseObject(new ItemStack(MekanismItems.CompressedCarbon), new InfuseObject(carbon, 80));
            InfuseRegistry.registerInfuseObject(new ItemStack(Items.field_151137_ax), new InfuseObject(redstone, 10));
            InfuseRegistry.registerInfuseObject(new ItemStack(Blocks.field_150451_bX), new InfuseObject(redstone, 90));
            InfuseRegistry.registerInfuseObject(new ItemStack(MekanismItems.CompressedRedstone), new InfuseObject(redstone, 80));
            InfuseRegistry.registerInfuseObject(new ItemStack((Block)Blocks.field_150337_Q), new InfuseObject(fungi, 10));
            InfuseRegistry.registerInfuseObject(new ItemStack((Block)Blocks.field_150338_P), new InfuseObject(fungi, 10));
            InfuseRegistry.registerInfuseObject(new ItemStack(MekanismItems.CompressedDiamond), new InfuseObject(diamond, 80));
            InfuseRegistry.registerInfuseObject(new ItemStack(MekanismItems.CompressedObsidian), new InfuseObject(obsidian, 80));
            RecipeHandler.addMetallurgicInfuserRecipe(carbon, 10, new ItemStack(Items.field_151042_j), new ItemStack(MekanismItems.EnrichedIron));
            RecipeHandler.addMetallurgicInfuserRecipe(carbon, 10, new ItemStack(MekanismItems.EnrichedIron), new ItemStack(MekanismItems.OtherDust, 1, 1));
            for (ItemStack steel : OreDictionary.getOres((String)"ingotSteel", (boolean)false)) {
                RecipeHandler.addMetallurgicInfuserRecipe(redstone, 10, StackUtils.size(steel, 1), new ItemStack(MekanismItems.EnrichedAlloy));
            }
            RecipeHandler.addMetallurgicInfuserRecipe(fungi, 10, new ItemStack(Blocks.field_150346_d), new ItemStack((Block)Blocks.field_150391_bh));
            RecipeHandler.addMetallurgicInfuserRecipe(bio, 10, new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150341_Y));
            RecipeHandler.addMetallurgicInfuserRecipe(bio, 10, new ItemStack(Blocks.field_150417_aV, 1, 0), new ItemStack(Blocks.field_150417_aV, 1, 1));
            RecipeHandler.addMetallurgicInfuserRecipe(bio, 10, new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150346_d));
            RecipeHandler.addMetallurgicInfuserRecipe(bio, 10, new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d, 1, 2));
            RecipeHandler.addMetallurgicInfuserRecipe(diamond, 10, new ItemStack(MekanismItems.EnrichedAlloy), new ItemStack(MekanismItems.ReinforcedAlloy));
            RecipeHandler.addMetallurgicInfuserRecipe(obsidian, 10, new ItemStack(MekanismItems.ReinforcedAlloy), new ItemStack(MekanismItems.AtomicAlloy));
        }
        if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.CHEMICAL_INFUSER)) {
            RecipeHandler.addChemicalInfuserRecipe(new GasStack(MekanismFluids.Oxygen, 1), new GasStack(MekanismFluids.SulfurDioxide, 2), new GasStack(MekanismFluids.SulfurTrioxide, 2));
            RecipeHandler.addChemicalInfuserRecipe(new GasStack(MekanismFluids.SulfurTrioxide, 1), new GasStack(MekanismFluids.Water, 1), new GasStack(MekanismFluids.SulfuricAcid, 1));
            RecipeHandler.addChemicalInfuserRecipe(new GasStack(MekanismFluids.Hydrogen, 1), new GasStack(MekanismFluids.Chlorine, 1), new GasStack(MekanismFluids.HydrogenChloride, 1));
            RecipeHandler.addChemicalInfuserRecipe(new GasStack(MekanismFluids.Deuterium, 1), new GasStack(MekanismFluids.Tritium, 1), new GasStack(MekanismFluids.FusionFuel, 2));
        }
        if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR)) {
            RecipeHandler.addElectrolyticSeparatorRecipe(FluidRegistry.getFluidStack((String)"water", (int)2), 2.0 * MekanismConfig.current().general.FROM_H2.val(), new GasStack(MekanismFluids.Hydrogen, 2), new GasStack(MekanismFluids.Oxygen, 1));
            RecipeHandler.addElectrolyticSeparatorRecipe(FluidRegistry.getFluidStack((String)"brine", (int)10), 2.0 * MekanismConfig.current().general.FROM_H2.val(), new GasStack(MekanismFluids.Sodium, 1), new GasStack(MekanismFluids.Chlorine, 1));
            RecipeHandler.addElectrolyticSeparatorRecipe(FluidRegistry.getFluidStack((String)"heavywater", (int)2), MekanismConfig.current().usage.heavyWaterElectrolysis.val(), new GasStack(MekanismFluids.Deuterium, 2), new GasStack(MekanismFluids.Oxygen, 1));
        }
        RecipeHandler.addThermalEvaporationRecipe(FluidRegistry.getFluidStack((String)"water", (int)10), FluidRegistry.getFluidStack((String)"brine", (int)1));
        RecipeHandler.addThermalEvaporationRecipe(FluidRegistry.getFluidStack((String)"brine", (int)10), FluidRegistry.getFluidStack((String)"liquidlithium", (int)1));
        if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER)) {
            RecipeHandler.addChemicalCrystallizerRecipe(new GasStack(MekanismFluids.Lithium, 100), new ItemStack(MekanismItems.OtherDust, 1, 4));
            RecipeHandler.addChemicalCrystallizerRecipe(new GasStack(MekanismFluids.Brine, 15), new ItemStack(MekanismItems.Salt));
        }
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            Resource gasResource;
            if (!(gas instanceof OreGas) || ((OreGas)gas).isClean()) continue;
            OreGas oreGas = (OreGas)gas;
            if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.CHEMICAL_WASHER)) {
                RecipeHandler.addChemicalWasherRecipe(new GasStack(oreGas, 1), new GasStack(oreGas.getCleanGas(), 1));
            }
            if ((gasResource = Resource.getFromName(oreGas.getName())) == null || !MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER)) continue;
            RecipeHandler.addChemicalCrystallizerRecipe(new GasStack(oreGas.getCleanGas(), 200), new ItemStack(MekanismItems.Crystal, 1, gasResource.ordinal()));
        }
        if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER)) {
            RecipeHandler.addPRCRecipe(new ItemStack(MekanismItems.BioFuel, 2), new FluidStack(FluidRegistry.WATER, 10), new GasStack(MekanismFluids.Hydrogen, 100), new ItemStack(MekanismItems.Substrate), new GasStack(MekanismFluids.Ethene, 100), 0.0, 100);
            RecipeHandler.addPRCRecipe(new ItemStack(MekanismItems.Substrate), new FluidStack(MekanismFluids.Ethene.getFluid(), 50), new GasStack(MekanismFluids.Oxygen, 10), new ItemStack(MekanismItems.Polyethene), new GasStack(MekanismFluids.Oxygen, 5), 1000.0, 60);
            RecipeHandler.addPRCRecipe(new ItemStack(MekanismItems.Substrate), new FluidStack(FluidRegistry.WATER, 200), new GasStack(MekanismFluids.Ethene, 100), new ItemStack(MekanismItems.Substrate, 8), new GasStack(MekanismFluids.Oxygen, 10), 200.0, 400);
            RecipeHandler.addPRCRecipe(new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), new FluidStack(FluidRegistry.WATER, 100), new GasStack(MekanismFluids.Oxygen, 100), new ItemStack(MekanismItems.OtherDust, 1, 3), new GasStack(MekanismFluids.Hydrogen, 100), 0.0, 100);
        }
        if (MekanismConfig.current().general.machinesManager.isEnabled(BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR)) {
            RecipeHandler.addSolarNeutronRecipe(new GasStack(MekanismFluids.Lithium, 1), new GasStack(MekanismFluids.Tritium, 1));
        }
        FuelHandler.addGas(MekanismFluids.Hydrogen, 1, MekanismConfig.current().general.FROM_H2.val());
    }

    public static void registerOreDict() {
        OreDictionary.registerOre((String)"universalCable", (ItemStack)MekanismUtils.getTransmitter(BlockStateTransmitter.TransmitterType.UNIVERSAL_CABLE, BaseTier.BASIC, 1));
        OreDictionary.registerOre((String)"battery", (ItemStack)MekanismItems.EnergyTablet.getUnchargedItem());
        OreDictionary.registerOre((String)"pulpWood", (Item)MekanismItems.Sawdust);
        OreDictionary.registerOre((String)"dustWood", (Item)MekanismItems.Sawdust);
        OreDictionary.registerOre((String)"blockSalt", (Block)MekanismBlocks.SaltBlock);
        OreDictionary.registerOre((String)"alloyBasic", (ItemStack)new ItemStack(Items.field_151137_ax));
        OreDictionary.registerOre((String)"alloyAdvanced", (ItemStack)new ItemStack(MekanismItems.EnrichedAlloy));
        OreDictionary.registerOre((String)"alloyElite", (ItemStack)new ItemStack(MekanismItems.ReinforcedAlloy));
        OreDictionary.registerOre((String)"alloyUltimate", (ItemStack)new ItemStack(MekanismItems.AtomicAlloy));
        OreDictionary.registerOre((String)"itemSalt", (Item)MekanismItems.Salt);
        OreDictionary.registerOre((String)"dustSalt", (Item)MekanismItems.Salt);
        OreDictionary.registerOre((String)"foodSalt", (Item)MekanismItems.Salt);
        OreDictionary.registerOre((String)"dustDiamond", (ItemStack)new ItemStack(MekanismItems.OtherDust, 1, 0));
        OreDictionary.registerOre((String)"dustSteel", (ItemStack)new ItemStack(MekanismItems.OtherDust, 1, 1));
        OreDictionary.registerOre((String)"dustSulfur", (ItemStack)new ItemStack(MekanismItems.OtherDust, 1, 3));
        OreDictionary.registerOre((String)"dustLithium", (ItemStack)new ItemStack(MekanismItems.OtherDust, 1, 4));
        OreDictionary.registerOre((String)"dustRefinedObsidian", (ItemStack)new ItemStack(MekanismItems.OtherDust, 1, 5));
        OreDictionary.registerOre((String)"dustObsidian", (ItemStack)new ItemStack(MekanismItems.OtherDust, 1, 6));
        OreDictionary.registerOre((String)"ingotRefinedObsidian", (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 0));
        OreDictionary.registerOre((String)"ingotOsmium", (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 1));
        OreDictionary.registerOre((String)"ingotBronze", (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 2));
        OreDictionary.registerOre((String)"ingotRefinedGlowstone", (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 3));
        OreDictionary.registerOre((String)"ingotSteel", (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 4));
        OreDictionary.registerOre((String)"ingotCopper", (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 5));
        OreDictionary.registerOre((String)"ingotTin", (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 6));
        OreDictionary.registerOre((String)"nuggetRefinedObsidian", (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 0));
        OreDictionary.registerOre((String)"nuggetOsmium", (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 1));
        OreDictionary.registerOre((String)"nuggetBronze", (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 2));
        OreDictionary.registerOre((String)"nuggetRefinedGlowstone", (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 3));
        OreDictionary.registerOre((String)"nuggetSteel", (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 4));
        OreDictionary.registerOre((String)"nuggetCopper", (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 5));
        OreDictionary.registerOre((String)"nuggetTin", (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 6));
        OreDictionary.registerOre((String)"blockOsmium", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock, 1, 0));
        OreDictionary.registerOre((String)"blockBronze", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock, 1, 1));
        OreDictionary.registerOre((String)"blockRefinedObsidian", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock, 1, 2));
        OreDictionary.registerOre((String)"blockCharcoal", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock, 1, 3));
        OreDictionary.registerOre((String)"blockRefinedGlowstone", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock, 1, 4));
        OreDictionary.registerOre((String)"blockSteel", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock, 1, 5));
        OreDictionary.registerOre((String)"blockCopper", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock, 1, 12));
        OreDictionary.registerOre((String)"blockTin", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock, 1, 13));
        for (Resource resource : Resource.values()) {
            OreDictionary.registerOre((String)("dust" + resource.getName()), (ItemStack)new ItemStack(MekanismItems.Dust, 1, resource.ordinal()));
            OreDictionary.registerOre((String)("dustDirty" + resource.getName()), (ItemStack)new ItemStack(MekanismItems.DirtyDust, 1, resource.ordinal()));
            OreDictionary.registerOre((String)("clump" + resource.getName()), (ItemStack)new ItemStack(MekanismItems.Clump, 1, resource.ordinal()));
            OreDictionary.registerOre((String)("shard" + resource.getName()), (ItemStack)new ItemStack(MekanismItems.Shard, 1, resource.ordinal()));
            OreDictionary.registerOre((String)("crystal" + resource.getName()), (ItemStack)new ItemStack(MekanismItems.Crystal, 1, resource.ordinal()));
        }
        OreDictionary.registerOre((String)"oreOsmium", (ItemStack)new ItemStack(MekanismBlocks.OreBlock, 1, 0));
        OreDictionary.registerOre((String)"oreCopper", (ItemStack)new ItemStack(MekanismBlocks.OreBlock, 1, 1));
        OreDictionary.registerOre((String)"oreTin", (ItemStack)new ItemStack(MekanismBlocks.OreBlock, 1, 2));
        if (MekanismConfig.current().general.controlCircuitOreDict.val()) {
            OreDictionary.registerOre((String)"circuitBasic", (ItemStack)new ItemStack(MekanismItems.ControlCircuit, 1, 0));
            OreDictionary.registerOre((String)"circuitAdvanced", (ItemStack)new ItemStack(MekanismItems.ControlCircuit, 1, 1));
            OreDictionary.registerOre((String)"circuitElite", (ItemStack)new ItemStack(MekanismItems.ControlCircuit, 1, 2));
            OreDictionary.registerOre((String)"circuitUltimate", (ItemStack)new ItemStack(MekanismItems.ControlCircuit, 1, 3));
        }
        OreDictionary.registerOre((String)"itemCompressedCarbon", (ItemStack)new ItemStack(MekanismItems.CompressedCarbon));
        OreDictionary.registerOre((String)"itemCompressedRedstone", (ItemStack)new ItemStack(MekanismItems.CompressedRedstone));
        OreDictionary.registerOre((String)"itemCompressedDiamond", (ItemStack)new ItemStack(MekanismItems.CompressedDiamond));
        OreDictionary.registerOre((String)"itemCompressedObsidian", (ItemStack)new ItemStack(MekanismItems.CompressedObsidian));
        OreDictionary.registerOre((String)"itemEnrichedAlloy", (ItemStack)new ItemStack(MekanismItems.EnrichedAlloy));
        OreDictionary.registerOre((String)"itemBioFuel", (ItemStack)new ItemStack(MekanismItems.BioFuel));
    }

    private static void registerTileEntity(Class<? extends TileEntity> clazz, String name) {
        GameRegistry.registerTileEntity(clazz, (ResourceLocation)new ResourceLocation(MODID, name));
    }

    private void registerTileEntities() {
        Mekanism.registerTileEntity(TileEntityAdvancedBoundingBlock.class, "advanced_bounding_block");
        Mekanism.registerTileEntity(TileEntityAdvancedFactory.class, "advanced_smelting_factory");
        Mekanism.registerTileEntity(TileEntityAmbientAccumulator.class, "ambient_accumulator");
        Mekanism.registerTileEntity(TileEntityBin.class, "bin");
        Mekanism.registerTileEntity(TileEntityBoilerCasing.class, "boiler_casing");
        Mekanism.registerTileEntity(TileEntityBoilerValve.class, "boiler_valve");
        Mekanism.registerTileEntity(TileEntityBoundingBlock.class, "bounding_block");
        Mekanism.registerTileEntity(TileEntityCardboardBox.class, "cardboard_box");
        Mekanism.registerTileEntity(TileEntityChargepad.class, "chargepad");
        Mekanism.registerTileEntity(TileEntityChemicalCrystallizer.class, "chemical_crystallizer");
        Mekanism.registerTileEntity(TileEntityChemicalDissolutionChamber.class, "chemical_dissolution_chamber");
        Mekanism.registerTileEntity(TileEntityChemicalInfuser.class, "chemical_infuser");
        Mekanism.registerTileEntity(TileEntityChemicalInjectionChamber.class, "chemical_injection_chamber");
        Mekanism.registerTileEntity(TileEntityChemicalOxidizer.class, "chemical_oxidizer");
        Mekanism.registerTileEntity(TileEntityChemicalWasher.class, "chemical_washer");
        Mekanism.registerTileEntity(TileEntityCombiner.class, "combiner");
        Mekanism.registerTileEntity(TileEntityCrusher.class, "crusher");
        Mekanism.registerTileEntity(TileEntityDigitalMiner.class, "digital_miner");
        Mekanism.registerTileEntity(TileEntityDiversionTransporter.class, "diversion_transporter");
        Mekanism.registerTileEntity(TileEntityDynamicTank.class, "dynamic_tank");
        Mekanism.registerTileEntity(TileEntityDynamicValve.class, "dynamic_valve");
        Mekanism.registerTileEntity(TileEntityElectricPump.class, "electric_pump");
        Mekanism.registerTileEntity(TileEntityElectrolyticSeparator.class, "electrolytic_separator");
        Mekanism.registerTileEntity(TileEntityEliteFactory.class, "ultimate_smelting_factory");
        Mekanism.registerTileEntity(TileEntityEnergizedSmelter.class, "energized_smelter");
        Mekanism.registerTileEntity(TileEntityEnergyCube.class, "energy_cube");
        Mekanism.registerTileEntity(TileEntityEnrichmentChamber.class, "enrichment_chamber");
        Mekanism.registerTileEntity(TileEntityFactory.class, "smelting_factory");
        Mekanism.registerTileEntity(TileEntityFluidTank.class, "fluid_tank");
        Mekanism.registerTileEntity(TileEntityFluidicPlenisher.class, "fluidic_plenisher");
        Mekanism.registerTileEntity(TileEntityFormulaicAssemblicator.class, "formulaic_assemblicator");
        Mekanism.registerTileEntity(TileEntityFuelwoodHeater.class, "fuelwood_heater");
        Mekanism.registerTileEntity(TileEntityGasTank.class, "gas_tank");
        Mekanism.registerTileEntity(TileEntityGlowPanel.class, "glow_panel");
        Mekanism.registerTileEntity(TileEntityInductionCasing.class, "induction_casing");
        Mekanism.registerTileEntity(TileEntityInductionCell.class, "induction_cell");
        Mekanism.registerTileEntity(TileEntityInductionPort.class, "induction_port");
        Mekanism.registerTileEntity(TileEntityInductionProvider.class, "induction_provider");
        Mekanism.registerTileEntity(TileEntityLaser.class, "laser");
        Mekanism.registerTileEntity(TileEntityLaserAmplifier.class, "laser_amplifier");
        Mekanism.registerTileEntity(TileEntityLaserTractorBeam.class, "laser_tractor_beam");
        Mekanism.registerTileEntity(TileEntityLogisticalSorter.class, "logistical_sorter");
        Mekanism.registerTileEntity(TileEntityLogisticalTransporter.class, "logistical_transporter");
        Mekanism.registerTileEntity(TileEntityMechanicalPipe.class, "mechanical_pipe");
        Mekanism.registerTileEntity(TileEntityMetallurgicInfuser.class, "metallurgic_infuser");
        Mekanism.registerTileEntity(TileEntityOredictionificator.class, "oredictionificator");
        Mekanism.registerTileEntity(TileEntityOsmiumCompressor.class, "osmium_compressor");
        Mekanism.registerTileEntity(TileEntityPRC.class, "pressurized_reaction_chamber");
        Mekanism.registerTileEntity(TileEntityPersonalChest.class, "personal_chest");
        Mekanism.registerTileEntity(TileEntityPrecisionSawmill.class, "precision_sawmill");
        Mekanism.registerTileEntity(TileEntityPressureDisperser.class, "pressure_disperser");
        Mekanism.registerTileEntity(TileEntityPressurizedTube.class, "pressurized_tube");
        Mekanism.registerTileEntity(TileEntityPurificationChamber.class, "purification_chamber");
        Mekanism.registerTileEntity(TileEntityQuantumEntangloporter.class, "quantum_entangloporter");
        Mekanism.registerTileEntity(TileEntityResistiveHeater.class, "resistive_heater");
        Mekanism.registerTileEntity(TileEntityRestrictiveTransporter.class, "restrictive_transporter");
        Mekanism.registerTileEntity(TileEntityRotaryCondensentrator.class, "rotary_condensentrator");
        Mekanism.registerTileEntity(TileEntitySecurityDesk.class, "security_desk");
        Mekanism.registerTileEntity(TileEntitySeismicVibrator.class, "seismic_vibrator");
        Mekanism.registerTileEntity(TileEntitySolarNeutronActivator.class, "solar_neutron_activator");
        Mekanism.registerTileEntity(TileEntityStructuralGlass.class, "structural_glass");
        Mekanism.registerTileEntity(TileEntitySuperheatingElement.class, "superheating_element");
        Mekanism.registerTileEntity(TileEntityTeleporter.class, "mekanism_teleporter");
        Mekanism.registerTileEntity(TileEntityThermalEvaporationBlock.class, "thermal_evaporation_block");
        Mekanism.registerTileEntity(TileEntityThermalEvaporationController.class, "thermal_evaporation_controller");
        Mekanism.registerTileEntity(TileEntityThermalEvaporationValve.class, "thermal_evaporation_valve");
        Mekanism.registerTileEntity(TileEntityThermodynamicConductor.class, "thermodynamic_conductor");
        Mekanism.registerTileEntity(TileEntityUniversalCable.class, "universal_cable");
        proxy.registerTESRs();
        MekanismDataFixers.register();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (MekanismConfig.current().general.voiceServerEnabled.val()) {
            voiceManager.start();
        }
        CommandMek.register(event);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        if (MekanismConfig.current().general.voiceServerEnabled.val()) {
            voiceManager.stop();
        }
        playerState.clear();
        activeVibrators.clear();
        worldTickHandler.resetRegenChunks();
        privateTeleporters.clear();
        privateEntangloporters.clear();
        freeRunnerOn.clear();
        MultiblockManager.reset();
        FrequencyManager.reset();
        TransporterManager.reset();
        PathfinderCache.reset();
        TransmitterNetworkRegistry.reset();
    }

    @Mod.EventHandler
    public void loadComplete(FMLInterModComms.IMCEvent event) {
        new IMCHandler().onIMCEvent((List<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String apiLocation;
        if (!((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue() && (apiLocation = MekanismAPI.class.getProtectionDomain().getCodeSource().getLocation().toString()).toLowerCase(Locale.ROOT).contains("-api.jar")) {
            proxy.throwApiPresentException();
        }
        configuration = new Configuration(new File("config/mekanism/Mekanism.cfg"));
        configurationce = new Configuration(new File("config/mekanism/MekanismCE.cfg"));
        configurationgenerators = new Configuration(new File("config/mekanism/MekanismGenerators.cfg"));
        configurationtools = new Configuration(new File("config/mekanism/MekanismTools.cfg"));
        proxy.loadConfiguration();
        proxy.onConfigSync(false);
        MinecraftForge.EVENT_BUS.register((Object)MekanismItems.GasMask);
        MinecraftForge.EVENT_BUS.register((Object)MekanismItems.FreeRunners);
        if (Loader.isModLoaded((String)"mcmultipart")) {
            new MultipartMekanism();
        } else {
            logger.info("Didn't detect MCMP, ignoring compatibility package");
        }
        proxy.preInit();
        InfuseRegistry.registerInfuseType(new InfuseType("CARBON", new ResourceLocation(MODID, "blocks/infuse/Carbon")).setTranslationKey("carbon"));
        InfuseRegistry.registerInfuseType(new InfuseType("TIN", new ResourceLocation(MODID, "blocks/infuse/Tin")).setTranslationKey("tin"));
        InfuseRegistry.registerInfuseType(new InfuseType("DIAMOND", new ResourceLocation(MODID, "blocks/infuse/Diamond")).setTranslationKey("diamond"));
        InfuseRegistry.registerInfuseType(new InfuseType("REDSTONE", new ResourceLocation(MODID, "blocks/infuse/Redstone")).setTranslationKey("redstone"));
        InfuseRegistry.registerInfuseType(new InfuseType("FUNGI", new ResourceLocation(MODID, "blocks/infuse/Fungi")).setTranslationKey("fungi"));
        InfuseRegistry.registerInfuseType(new InfuseType("BIO", new ResourceLocation(MODID, "blocks/infuse/Bio")).setTranslationKey("bio"));
        InfuseRegistry.registerInfuseType(new InfuseType("OBSIDIAN", new ResourceLocation(MODID, "blocks/infuse/Obsidian")).setTranslationKey("obsidian"));
        Capabilities.registerCapabilities();
        hooks.hookPreInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)genHandler, (int)1);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new CoreGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CommonPlayerTracker());
        MinecraftForge.EVENT_BUS.register((Object)new CommonPlayerTickHandler());
        logger.info("Version " + versionNumber + " initializing...");
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkManager());
        MinecraftForge.EVENT_BUS.register((Object)this);
        PacketSimpleGui.handlers.add(0, proxy);
        if (MekanismConfig.current().general.voiceServerEnabled.val()) {
            voiceManager = new VoiceServerManager();
        }
        TransmitterNetworkRegistry.initiate();
        if (MekanismConfig.current().general.spawnBabySkeletons.val()) {
            for (Biome biome : BiomeProvider.allowedBiomes) {
                if (biome.func_76747_a(EnumCreatureType.MONSTER) == null || biome.func_76747_a(EnumCreatureType.MONSTER).size() <= 0) continue;
                EntityRegistry.addSpawn(EntityBabySkeleton.class, (int)40, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{biome});
            }
        }
        this.registerTileEntities();
        hooks.hookInit();
        packetHandler.initialize();
        proxy.init();
        logger.info("Loading complete.");
        logger.info("Mod loaded.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        logger.info("Fake player readout: UUID = " + gameProfile.getId().toString() + ", name = " + gameProfile.getName());
        for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            SmeltingRecipe recipe = new SmeltingRecipe(new ItemStackInput((ItemStack)entry.getKey()), new ItemStackOutput((ItemStack)entry.getValue()));
            RecipeHandler.Recipe.ENERGIZED_SMELTER.put(recipe);
        }
        hooks.hookPostInit();
        MinecraftForge.EVENT_BUS.post((Event)new MekanismAPI.BoxBlacklistEvent());
        logger.info("Hooking complete.");
    }

    @SubscribeEvent
    public void onEnergyTransferred(EnergyNetwork.EnergyTransferEvent event) {
        try {
            packetHandler.sendToReceivers(new PacketTransmitterUpdate.TransmitterUpdateMessage(PacketTransmitterUpdate.PacketType.ENERGY, event.energyNetwork.firstTransmitter().coord(), event.power), event.energyNetwork.getPacketRange());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onGasTransferred(GasNetwork.GasTransferEvent event) {
        try {
            packetHandler.sendToReceivers(new PacketTransmitterUpdate.TransmitterUpdateMessage(PacketTransmitterUpdate.PacketType.GAS, event.gasNetwork.firstTransmitter().coord(), event.transferType, event.didTransfer), event.gasNetwork.getPacketRange());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onLiquidTransferred(FluidNetwork.FluidTransferEvent event) {
        try {
            packetHandler.sendToReceivers(new PacketTransmitterUpdate.TransmitterUpdateMessage(PacketTransmitterUpdate.PacketType.FLUID, event.fluidNetwork.firstTransmitter().coord(), event.fluidType, event.didTransfer), event.fluidNetwork.getPacketRange());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onTransmittersAddedEvent(DynamicNetwork.TransmittersAddedEvent event) {
        try {
            packetHandler.sendToReceivers(new PacketTransmitterUpdate.TransmitterUpdateMessage(PacketTransmitterUpdate.PacketType.UPDATE, event.network.firstTransmitter().coord(), event.newNetwork, event.newTransmitters), event.network.getPacketRange());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onNetworkClientRequest(DynamicNetwork.NetworkClientRequest event) {
        try {
            packetHandler.sendToServer(new PacketDataRequest.DataRequestMessage(Coord4D.get(event.tileEntity)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onClientTickUpdate(DynamicNetwork.ClientTickUpdate event) {
        try {
            if (event.operation == 0) {
                ClientTickHandler.tickingSet.remove(event.network);
            } else {
                ClientTickHandler.tickingSet.add(event.network);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onBlacklistUpdate(MekanismAPI.BoxBlacklistEvent event) {
        event.blacklistWildcard(MekanismBlocks.CardboardBox);
        event.blacklistWildcard(MekanismBlocks.BoundingBlock);
        event.blacklist(MekanismBlocks.BasicBlock2, 9);
        event.blacklist(MekanismBlocks.MachineBlock, 4);
        event.blacklist(MekanismBlocks.MachineBlock2, 9);
        event.blacklist(MekanismBlocks.MachineBlock3, 1);
        event.blacklist(Blocks.field_150357_h, 0);
        event.blacklistWildcard((Block)Blocks.field_150427_aO);
        event.blacklistWildcard(Blocks.field_150384_bq);
        event.blacklistWildcard(Blocks.field_150378_br);
        event.blacklistWildcard(Blocks.field_150324_C);
        event.blacklistWildcard((Block)Blocks.field_180413_ao);
        event.blacklistWildcard((Block)Blocks.field_180414_ap);
        event.blacklistWildcard((Block)Blocks.field_180412_aq);
        event.blacklistWildcard((Block)Blocks.field_180411_ar);
        event.blacklistWildcard((Block)Blocks.field_180410_as);
        event.blacklistWildcard((Block)Blocks.field_180409_at);
        event.blacklistWildcard((Block)Blocks.field_150454_av);
        event.blacklistWildcard(new ResourceLocation("extrautils2", "machine"));
        event.blacklistWildcard(new ResourceLocation("immersiveengineering", "metal_device0"));
        event.blacklistWildcard(new ResourceLocation("immersiveengineering", "metal_device1"));
        event.blacklistWildcard(new ResourceLocation("immersiveengineering", "wooden_device0"));
        event.blacklistWildcard(new ResourceLocation("immersiveengineering", "wooden_device1"));
        event.blacklistWildcard(new ResourceLocation("immersiveengineering", "connector"));
        event.blacklistWildcard(new ResourceLocation("immersiveengineering", "metal_multiblock"));
        event.blacklistWildcard(new ResourceLocation("ic2", "te"));
        event.blacklistMod("storagedrawers");
        event.blacklistMod("colossalchests");
        BoxBlacklistParser.load();
    }

    @SubscribeEvent
    public void chunkSave(ChunkDataEvent.Save event) {
        if (!event.getWorld().field_72995_K) {
            NBTTagCompound nbtTags = event.getData();
            nbtTags.func_74768_a("MekanismWorldGen", baseWorldGenVersion);
            nbtTags.func_74768_a("MekanismUserWorldGen", MekanismConfig.current().general.userWorldGenVersion.val());
        }
    }

    @SubscribeEvent
    public synchronized void onChunkDataLoad(ChunkDataEvent.Load event) {
        if (!event.getWorld().field_72995_K && MekanismConfig.current().general.enableWorldRegeneration.val()) {
            NBTTagCompound loadData = event.getData();
            if (loadData.func_74762_e("MekanismWorldGen") == baseWorldGenVersion && loadData.func_74762_e("MekanismUserWorldGen") == MekanismConfig.current().general.userWorldGenVersion.val()) {
                return;
            }
            ChunkPos coordPair = event.getChunk().func_76632_l();
            worldTickHandler.addRegenChunk(event.getWorld().field_73011_w.getDimension(), coordPair);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            proxy.loadConfiguration();
            proxy.onConfigSync(false);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        playerState.init(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof WorldServer) {
            MekFakePlayer.releaseInstance(event.getWorld());
        }
    }

    static {
        hooks = new MekanismHooks();
        versionNumber = new Version(999, 999, 999);
        tankManager = new MultiblockManager("dynamicTank");
        matrixManager = new MultiblockManager("inductionMatrix");
        boilerManager = new MultiblockManager("thermoelectricBoiler");
        publicTeleporters = new FrequencyManager(Frequency.class, "Teleporter");
        privateTeleporters = new HashMap<UUID, FrequencyManager>();
        publicEntangloporters = new FrequencyManager(InventoryFrequency.class, "Entangloporter");
        privateEntangloporters = new HashMap<UUID, FrequencyManager>();
        securityFrequencies = new FrequencyManager(SecurityFrequency.class, "Security");
        tabMekanism = new CreativeTabMekanism();
        modulesLoaded = new ArrayList<IModule>();
        worldTickHandler = new CommonWorldTickHandler();
        genHandler = new GenHandler();
        baseWorldGenVersion = 0;
        gameProfile = new GameProfile(UUID.nameUUIDFromBytes("mekanism.common".getBytes()), LOG_TAG);
        keyMap = new KeySync();
        activeVibrators = new HashSet<Coord4D>();
        MekanismFluids.register();
    }
}

