/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.block.states.BlockStateBounding;
import mekanism.common.tile.TileEntityAdvancedBoundingBlock;
import mekanism.common.tile.TileEntityBoundingBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBounding
extends Block {
    @Nullable
    private static BlockPos getMainBlockPos(IBlockAccess world, BlockPos thisPos) {
        TileEntity te = world.func_175625_s(thisPos);
        if (te instanceof TileEntityBoundingBlock && !thisPos.equals((Object)((TileEntityBoundingBlock)te).getMainPos())) {
            return ((TileEntityBoundingBlock)te).getMainPos();
        }
        return null;
    }

    private static void removeMainBlock(World world, BlockPos thisPos) {
        IBlockState state;
        BlockPos mainPos = BlockBounding.getMainBlockPos((IBlockAccess)world, thisPos);
        if (mainPos != null && !(state = world.func_180495_p(mainPos)).func_177230_c().isAir(state, (IBlockAccess)world, mainPos)) {
            world.func_175698_g(mainPos);
        }
    }

    public BlockBounding() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(8.0f);
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateBounding(this);
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockStateBounding.advancedProperty, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateBounding.advancedProperty) != false ? 1 : 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockPos mainPos = BlockBounding.getMainBlockPos((IBlockAccess)world, pos);
        if (mainPos == null) {
            return false;
        }
        IBlockState state1 = world.func_180495_p(mainPos);
        return state1.func_177230_c().func_180639_a(world, mainPos, state1, player, hand, side, hitX, hitY, hitZ);
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        BlockBounding.removeMainBlock(world, pos);
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        BlockPos mainPos = BlockBounding.getMainBlockPos((IBlockAccess)world, pos);
        if (mainPos == null) {
            return ItemStack.field_190927_a;
        }
        IBlockState state1 = world.func_180495_p(mainPos);
        return state1.func_177230_c().getPickBlock(state1, target, world, mainPos, player);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        BlockBounding.removeMainBlock(world, pos);
        return super.removedByPlayer(state, world, pos, player, false);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        BlockPos mainPos = BlockBounding.getMainBlockPos(world, pos);
        if (mainPos == null) {
            return;
        }
        IBlockState state1 = world.func_180495_p(mainPos);
        state1.func_177230_c().getDrops(drops, world, mainPos, state1, fortune);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    @Deprecated
    protected boolean func_149700_E() {
        return false;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        if (world.func_175625_s(pos) instanceof TileEntityBoundingBlock) {
            BlockPos mainPos;
            TileEntityBoundingBlock tileEntity = (TileEntityBoundingBlock)world.func_175625_s(pos);
            if (tileEntity != null) {
                tileEntity.onNeighborChange(state.func_177230_c());
            }
            if ((mainPos = BlockBounding.getMainBlockPos((IBlockAccess)world, pos)) != null) {
                IBlockState state1 = world.func_180495_p(mainPos);
                state1.func_177230_c().func_189540_a(state1, world, mainPos, neighborBlock, neighborPos);
            }
        } else {
            System.out.print("\nCant cast exception\n");
        }
    }

    @Deprecated
    public float func_180647_a(IBlockState state, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos) {
        BlockPos mainPos = BlockBounding.getMainBlockPos((IBlockAccess)world, pos);
        if (mainPos == null) {
            return super.func_180647_a(state, player, world, pos);
        }
        IBlockState state1 = world.func_180495_p(mainPos);
        return state1.func_177230_c().func_180647_a(state1, player, world, mainPos);
    }

    @Nonnull
    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        TileEntity tile;
        BlockPos mainPos = BlockBounding.getMainBlockPos(world, pos);
        if (mainPos != null && (tile = world.func_175625_s(mainPos)) instanceof IBoundingBlock) {
            return ((IBoundingBlock)tile).getOffsetBlockFaceShape(face, (Vec3i)pos.func_177973_b((Vec3i)mainPos));
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)BlockStateBounding.advancedProperty)).booleanValue()) {
            return new TileEntityAdvancedBoundingBlock();
        }
        return new TileEntityBoundingBlock();
    }
}

