/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.OreDictCache;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemEnergized;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemAtomicDisassembler
extends ItemEnergized {
    public ItemAtomicDisassembler() {
        super(MekanismConfig.current().general.disassemblerBatteryCapacity.val());
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, ItemStack stack) {
        return state.func_177230_c() != Blocks.field_150357_h;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        Mode mode = this.getMode(itemstack);
        list.add(LangUtils.localize("tooltip.mode") + ": " + (Object)((Object)EnumColor.INDIGO) + mode.getModeName());
        list.add(LangUtils.localize("tooltip.efficiency") + ": " + (Object)((Object)EnumColor.INDIGO) + mode.getEfficiency());
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase target, EntityLivingBase attacker) {
        double energy = this.getEnergy(itemstack);
        int energyCost = MekanismConfig.current().general.disassemblerEnergyUsageWeapon.val();
        int minDamage = MekanismConfig.current().general.disassemblerDamageMin.val();
        int damageDifference = MekanismConfig.current().general.disassemblerDamageMax.val() - minDamage;
        double percent = 1.0;
        if (energy < (double)energyCost && energyCost != 0) {
            percent = energy / (double)energyCost;
        }
        float damage = (float)((double)minDamage + (double)damageDifference * percent);
        if (attacker instanceof EntityPlayer) {
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), damage);
        } else {
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)attacker), damage);
        }
        if (energy > 0.0) {
            this.setEnergy(itemstack, energy - (double)energyCost);
        }
        return false;
    }

    public float func_150893_a(ItemStack itemstack, IBlockState state) {
        return this.getEnergy(itemstack) != 0.0 ? (float)this.getMode(itemstack).getEfficiency() : 1.0f;
    }

    public boolean func_179218_a(ItemStack itemstack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityliving) {
        this.setEnergy(itemstack, this.getEnergy(itemstack) - (double)this.getDestroyEnergy(itemstack, state.func_185887_b(world, pos)));
        return true;
    }

    private RayTraceResult doRayTrace(IBlockState state, BlockPos pos, EntityPlayer player) {
        double blockReachDistance;
        Vec3d maxReach;
        Vec3d positionEyes = player.func_174824_e(1.0f);
        Vec3d playerLook = player.func_70676_i(1.0f);
        RayTraceResult res = state.func_185910_a(player.field_70170_p, pos, playerLook, maxReach = positionEyes.func_72441_c(playerLook.field_72450_a * (blockReachDistance = player.func_110140_aT().func_111151_a(EntityPlayer.REACH_DISTANCE).func_111126_e()), playerLook.field_72448_b * blockReachDistance, playerLook.field_72449_c * blockReachDistance));
        return res != null ? res : new RayTraceResult(RayTraceResult.Type.MISS, Vec3d.field_186680_a, EnumFacing.UP, pos);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        super.onBlockStartBreak(itemstack, pos, player);
        if (!player.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            boolean extended;
            Mode mode = this.getMode(itemstack);
            boolean bl = extended = mode == Mode.EXTENDED_VEIN;
            if (extended || mode == Mode.VEIN) {
                IBlockState state = player.field_70170_p.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block == Blocks.field_150439_ay) {
                    block = Blocks.field_150450_ax;
                }
                RayTraceResult raytrace = this.doRayTrace(state, pos, player);
                ItemStack stack = block.getPickBlock(state, raytrace, player.field_70170_p, pos, player);
                List<String> names = OreDictCache.getOreDictName(stack);
                boolean isOre = false;
                for (String s : names) {
                    if (!s.startsWith("ore") && !s.equals("logWood")) continue;
                    isOre = true;
                    break;
                }
                if (isOre || extended) {
                    Coord4D orig = new Coord4D(pos, player.field_70170_p);
                    Set<Coord4D> found = new Finder(player, stack, orig, raytrace, extended ? MekanismConfig.current().general.disassemblerMiningRange.val() : -1).calc();
                    for (Coord4D coord : found) {
                        if (coord.equals(orig)) continue;
                        int destroyEnergy = this.getDestroyEnergy(itemstack, coord.getBlockState((IBlockAccess)player.field_70170_p).func_185887_b(player.field_70170_p, coord.getPos()));
                        if (this.getEnergy(itemstack) < (double)destroyEnergy) continue;
                        Block block2 = coord.getBlock((IBlockAccess)player.field_70170_p);
                        block2.func_176208_a(player.field_70170_p, coord.getPos(), state, player);
                        player.field_70170_p.func_175718_b(2001, coord.getPos(), Block.func_176210_f((IBlockState)state));
                        block2.func_176226_b(player.field_70170_p, coord.getPos(), state, 0);
                        player.field_70170_p.func_175698_g(coord.getPos());
                        this.setEnergy(itemstack, this.getEnergy(itemstack) - (double)destroyEnergy);
                    }
                }
            }
        }
        return false;
    }

    public boolean func_77662_d() {
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityplayer, @Nonnull EnumHand hand) {
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        if (entityplayer.func_70093_af()) {
            if (!world.field_72995_K) {
                this.toggleMode(itemstack);
                Mode mode = this.getMode(itemstack);
                entityplayer.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + " " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.modeToggle") + " " + (Object)((Object)EnumColor.INDIGO) + mode.getModeName() + (Object)((Object)EnumColor.AQUA) + " (" + mode.getEfficiency() + ")"));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        int diameter;
        if (!player.func_70093_af() && (diameter = this.getMode(stack = player.func_184586_b(hand)).getDiameter()) > 0) {
            Block block = world.func_180495_p(pos).func_177230_c();
            if (block == Blocks.field_150346_d || block == Blocks.field_185774_da) {
                return this.useItemAs(player, world, pos, side, stack, diameter, this::useHoe);
            }
            if (block == Blocks.field_150349_c) {
                return this.useItemAs(player, world, pos, side, stack, diameter, this::useShovel);
            }
        }
        return EnumActionResult.PASS;
    }

    private EnumActionResult useItemAs(EntityPlayer player, World world, BlockPos pos, EnumFacing side, ItemStack stack, int diameter, ItemUseConsumer consumer) {
        int hoeUsage;
        double energy = this.getEnergy(stack);
        if (energy < (double)(hoeUsage = MekanismConfig.current().general.disassemblerEnergyUsageHoe.val()) || consumer.use(stack, player, world, pos, side) == EnumActionResult.FAIL) {
            return EnumActionResult.FAIL;
        }
        double energyUsed = hoeUsage;
        int radius = (diameter - 1) / 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius && !(energyUsed + (double)hoeUsage > energy); ++z) {
                if (x == 0 && z == 0 || consumer.use(stack, player, world, pos.func_177982_a(x, 0, z), side) != EnumActionResult.SUCCESS) continue;
                energyUsed += (double)hoeUsage;
            }
        }
        this.setEnergy(stack, energy - energyUsed);
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult useHoe(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing) {
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        int hook = ForgeEventFactory.onHoeUse((ItemStack)stack, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (hook != 0) {
            return hook > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        if (facing != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            IBlockState newState = null;
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                newState = Blocks.field_150458_ak.func_176223_P();
            } else if (block == Blocks.field_150346_d) {
                BlockDirt.DirtType type = (BlockDirt.DirtType)state.func_177229_b((IProperty)BlockDirt.field_176386_a);
                if (type == BlockDirt.DirtType.DIRT) {
                    newState = Blocks.field_150458_ak.func_176223_P();
                } else if (type == BlockDirt.DirtType.COARSE_DIRT) {
                    newState = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT);
                }
            }
            if (newState != null) {
                this.setBlock(stack, player, world, pos, newState);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    private EnumActionResult useShovel(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing) {
        Block block;
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        if (facing != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a()) && (block = world.func_180495_p(pos).func_177230_c()) == Blocks.field_150349_c) {
            this.setBlock(stack, player, world, pos, Blocks.field_185774_da.func_176223_P());
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private void setBlock(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state, 11);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    private int getDestroyEnergy(ItemStack itemStack, float hardness) {
        int destroyEnergy = MekanismConfig.current().general.disassemblerEnergyUsage.val() * this.getMode(itemStack).getEfficiency();
        return hardness == 0.0f ? destroyEnergy / 2 : destroyEnergy;
    }

    public Mode getMode(ItemStack itemStack) {
        return Mode.getFromInt(ItemDataUtils.getInt(itemStack, "mode"));
    }

    public void toggleMode(ItemStack itemStack) {
        ItemDataUtils.setInt(itemStack, "mode", Mode.getNextEnabledAsInt(this.getMode(itemStack)));
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Nonnull
    @Deprecated
    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multiMap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multiMap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multiMap;
    }

    @FunctionalInterface
    static interface ItemUseConsumer {
        public EnumActionResult use(ItemStack var1, EntityPlayer var2, World var3, BlockPos var4, EnumFacing var5);
    }

    public static class Finder {
        public static Map<Block, List<Block>> ignoreBlocks = new HashMap<Block, List<Block>>();
        private final EntityPlayer player;
        public final World world;
        public final ItemStack stack;
        public final Coord4D location;
        public final Set<Coord4D> found = new HashSet<Coord4D>();
        private final RayTraceResult rayTraceResult;
        private final Block startBlock;
        private final boolean isWood;
        private final int maxRange;
        private final int maxCount;

        public Finder(EntityPlayer p, ItemStack s, Coord4D loc, RayTraceResult traceResult, int range) {
            this.player = p;
            this.world = p.field_70170_p;
            this.stack = s;
            this.location = loc;
            this.startBlock = loc.getBlock((IBlockAccess)this.world);
            this.rayTraceResult = traceResult;
            this.isWood = OreDictCache.getOreDictName(this.stack).contains("logWood");
            this.maxRange = range;
            this.maxCount = MekanismConfig.current().general.disassemblerMiningCount.val() - 1;
        }

        public void loop(Coord4D pointer) {
            if (this.found.contains(pointer) || this.found.size() > this.maxCount) {
                return;
            }
            this.found.add(pointer);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                ItemStack blockStack;
                Block block;
                Coord4D coord = pointer.offset(side);
                if (this.maxRange > 0 && this.location.distanceTo(coord) > this.maxRange || !coord.exists(this.world) || !this.checkID(block = coord.getBlock((IBlockAccess)this.world)) || !ItemHandlerHelper.canItemStacksStack((ItemStack)this.stack, (ItemStack)(blockStack = block.getPickBlock(coord.getBlockState((IBlockAccess)this.world), this.rayTraceResult, this.world, coord.getPos(), this.player))) && (block != this.startBlock || !this.isWood || coord.getBlockMeta((IBlockAccess)this.world) % 4 != this.stack.func_77952_i() % 4)) continue;
                this.loop(coord);
            }
        }

        public Set<Coord4D> calc() {
            this.loop(this.location);
            return this.found;
        }

        public boolean checkID(Block b) {
            Block origBlock = this.location.getBlock((IBlockAccess)this.world);
            List<Block> ignored = ignoreBlocks.get(origBlock);
            return ignored == null ? b == origBlock : ignored.contains(b);
        }

        static {
            ignoreBlocks.put(Blocks.field_150450_ax, Arrays.asList(Blocks.field_150450_ax, Blocks.field_150439_ay));
            ignoreBlocks.put(Blocks.field_150439_ay, Arrays.asList(Blocks.field_150450_ax, Blocks.field_150439_ay));
        }
    }

    public static enum Mode {
        NORMAL("normal", 20, 3, () -> true),
        SLOW("slow", 8, 1, () -> MekanismConfig.current().general.disassemblerSlowMode.val()),
        FAST("fast", 128, 5, () -> MekanismConfig.current().general.disassemblerFastMode.val()),
        VEIN("vein", 20, 3, () -> MekanismConfig.current().general.disassemblerVeinMining.val()),
        EXTENDED_VEIN("extended_vein", 20, 3, () -> MekanismConfig.current().general.disassemblerExtendedMining.val()),
        OFF("off", 0, 0, () -> true);

        private final Supplier<Boolean> checkEnabled;
        private final String mode;
        private final int efficiency;
        private final int diameter;

        private Mode(String mode, int efficiency, int diameter, Supplier<Boolean> checkEnabled) {
            this.mode = mode;
            this.efficiency = efficiency;
            this.diameter = diameter;
            this.checkEnabled = checkEnabled;
        }

        public static Mode getFromInt(int ordinal) {
            Mode[] values = Mode.values();
            Mode mode = values[ordinal % values.length];
            return mode.isEnabled() ? mode : NORMAL;
        }

        public static int getNextEnabledAsInt(Mode mode) {
            Mode next = mode.getNext();
            while (!next.isEnabled()) {
                next = next.getNext();
            }
            return next.ordinal();
        }

        private Mode getNext() {
            Mode[] values = Mode.values();
            return values[(this.ordinal() + 1) % values.length];
        }

        public String getModeName() {
            return LangUtils.localize("mekanism.tooltip.disassembler." + this.mode);
        }

        public int getEfficiency() {
            return this.efficiency;
        }

        public int getDiameter() {
            return this.diameter;
        }

        public boolean isEnabled() {
            return this.checkEnabled.get();
        }
    }
}

