/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters.grid;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.base.FluidAcceptor;
import mekanism.common.base.target.FluidHandlerTarget;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class FluidNetwork
extends DynamicNetwork<IFluidHandler, FluidNetwork, FluidStack> {
    public int transferDelay = 0;
    public boolean didTransfer;
    public boolean prevTransfer;
    public float fluidScale;
    public Fluid refFluid;
    public FluidStack buffer;
    public int prevStored;
    public int prevTransferAmount = 0;

    public FluidNetwork() {
    }

    public FluidNetwork(Collection<FluidNetwork> networks) {
        for (FluidNetwork net : networks) {
            if (net == null) continue;
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.fluidScale = this.getScale();
        this.register();
    }

    @Override
    public void adoptTransmittersAndAcceptorsFrom(FluidNetwork net) {
        if (net.buffer != null) {
            if (this.buffer == null) {
                this.buffer = net.buffer.copy();
            } else if (this.buffer.getFluid() == net.buffer.getFluid()) {
                this.buffer.amount += net.buffer.amount;
            } else if (net.buffer.amount > this.buffer.amount) {
                this.buffer = net.buffer.copy();
            }
            net.buffer = null;
        }
        super.adoptTransmittersAndAcceptorsFrom(net);
    }

    @Override
    @Nullable
    public FluidStack getBuffer() {
        return this.buffer;
    }

    @Override
    public void absorbBuffer(IGridTransmitter<IFluidHandler, FluidNetwork, FluidStack> transmitter) {
        FluidStack fluid = transmitter.getBuffer();
        if (fluid == null || fluid.amount == 0) {
            return;
        }
        if (this.buffer == null || this.buffer.amount == 0) {
            this.buffer = fluid.copy();
            fluid.amount = 0;
            return;
        }
        if (this.buffer.isFluidEqual(fluid)) {
            this.buffer.amount += fluid.amount;
        }
        fluid.amount = 0;
    }

    @Override
    public void clampBuffer() {
        if (this.buffer != null && this.buffer.amount > this.getCapacity()) {
            this.buffer.amount = this.getCapacity();
        }
    }

    public int getFluidNeeded() {
        return this.getCapacity() - (this.buffer != null ? this.buffer.amount : 0);
    }

    private int tickEmit(FluidStack fluidToSend) {
        HashSet<FluidHandlerTarget> availableAcceptors = new HashSet<FluidHandlerTarget>();
        HashSet availableTransmitters = new HashSet();
        int totalHandlers = 0;
        for (Coord4D coord : this.possibleAcceptors) {
            TileEntity tile;
            EnumSet sides = (EnumSet)this.acceptorDirections.get(coord);
            if (sides == null || sides.isEmpty() || (tile = coord.getTileEntity((IBlockAccess)this.getWorld())) == null) continue;
            FluidHandlerTarget target = new FluidHandlerTarget(fluidToSend);
            for (EnumFacing side : sides) {
                FluidAcceptor acceptor;
                if (!CapabilityUtils.hasCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) continue;
                int limit = Integer.MAX_VALUE;
                if (this.world.func_175625_s(coord.offset(side).getPos()) instanceof TileEntityMechanicalPipe) {
                    TileEntityMechanicalPipe pipe = (TileEntityMechanicalPipe)this.world.func_175625_s(coord.offset(side).getPos());
                    limit = pipe.getCapacity();
                }
                if ((acceptor = new FluidAcceptor((IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side), limit)) == null || !PipeUtils.canFill(acceptor, fluidToSend)) continue;
                target.addHandler(side, acceptor);
            }
            int curHandlers = target.getHandlers().size();
            if (curHandlers <= 0) continue;
            availableAcceptors.add(target);
            totalHandlers += curHandlers;
        }
        return EmitUtils.sendToAcceptors(availableAcceptors, totalHandlers, fluidToSend.amount, fluidToSend);
    }

    public int emit(FluidStack fluidToSend, boolean doTransfer) {
        if (fluidToSend == null || this.buffer != null && this.buffer.getFluid() != fluidToSend.getFluid()) {
            return 0;
        }
        int toUse = Math.min(this.getFluidNeeded(), fluidToSend.amount);
        if (doTransfer) {
            if (this.buffer == null) {
                this.buffer = fluidToSend.copy();
                this.buffer.amount = toUse;
            } else {
                this.buffer.amount += toUse;
            }
        }
        return toUse;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int stored;
            this.prevTransferAmount = 0;
            if (this.transferDelay == 0) {
                this.didTransfer = false;
            } else {
                --this.transferDelay;
            }
            int n = stored = this.buffer != null ? this.buffer.amount : 0;
            if (stored != this.prevStored) {
                this.needsUpdate = true;
            }
            this.prevStored = stored;
            if (this.didTransfer != this.prevTransfer || this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new FluidTransferEvent(this, this.buffer, this.didTransfer));
                this.needsUpdate = false;
            }
            this.prevTransfer = this.didTransfer;
            if (this.buffer != null) {
                this.prevTransferAmount = this.tickEmit(this.buffer);
                if (this.prevTransferAmount > 0) {
                    this.didTransfer = true;
                    this.transferDelay = 2;
                }
                if (this.buffer != null) {
                    this.buffer.amount -= this.prevTransferAmount;
                    if (this.buffer.amount <= 0) {
                        this.buffer = null;
                    }
                }
            }
        }
    }

    @Override
    public void clientTick() {
        super.clientTick();
        this.fluidScale = Math.max(this.fluidScale, this.getScale());
        if (this.didTransfer && this.fluidScale < 1.0f) {
            this.fluidScale = Math.max(this.getScale(), Math.min(1.0f, this.fluidScale + 0.02f));
        } else if (!this.didTransfer && this.fluidScale > 0.0f) {
            this.fluidScale = this.getScale();
            if (this.fluidScale == 0.0f) {
                this.buffer = null;
            }
        }
    }

    public float getScale() {
        return Math.min(1.0f, this.buffer == null || this.getCapacity() == 0 ? 0.0f : (float)this.buffer.amount / (float)this.getCapacity());
    }

    public String toString() {
        return "[FluidNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public String getNeededInfo() {
        return (float)this.getFluidNeeded() / 1000.0f + " buckets";
    }

    @Override
    public String getStoredInfo() {
        return this.buffer != null ? LangUtils.localizeFluidStack(this.buffer) + " (" + this.buffer.amount + " mB)" : "None";
    }

    @Override
    public String getFlowInfo() {
        return this.prevTransferAmount + " mB/t";
    }

    @Override
    public boolean isCompatibleWith(FluidNetwork other) {
        return super.isCompatibleWith(other) && (this.buffer == null || other.buffer == null || this.buffer.isFluidEqual(other.buffer));
    }

    @Override
    public boolean compatibleWithBuffer(FluidStack buffer) {
        return super.compatibleWithBuffer(buffer) && (this.buffer == null || buffer == null || this.buffer.isFluidEqual(buffer));
    }

    public static class FluidTransferEvent
    extends Event {
        public final FluidNetwork fluidNetwork;
        public final FluidStack fluidType;
        public final boolean didTransfer;

        public FluidTransferEvent(FluidNetwork network, FluidStack type, boolean did) {
            this.fluidNetwork = network;
            this.fluidType = type;
            this.didTransfer = did;
        }
    }
}

