/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.config.MekanismConfig;
import mekanism.tools.common.Materials;
import mekanism.tools.common.ToolsCommonProxy;
import mekanism.tools.common.ToolsItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="mekanismtools", useMetadata=true, guiFactory="mekanism.tools.client.gui.ToolsGuiFactory", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class MekanismTools
implements IModule {
    public static final String MODID = "mekanismtools";
    @SidedProxy(clientSide="mekanism.tools.client.ToolsClientProxy", serverSide="mekanism.tools.common.ToolsCommonProxy")
    public static ToolsCommonProxy proxy;
    @Mod.Instance(value="mekanismtools")
    public static MekanismTools instance;
    public static Version versionNumber;

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ToolsItem.registerItems((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        proxy.registerItemRenders();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.loadConfiguration();
        Materials.load();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Mekanism.modulesLoaded.add(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Mekanism.logger.info("Loaded 'Mekanism: Tools' module.");
    }

    @Mod.EventHandler
    public void modRemapping(FMLModIdMappingEvent event) {
        ToolsItem.remapItems();
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        MekanismTools.addSmeltingRecipe(ToolsItem.IRON_PAXEL, new ItemStack(Items.field_191525_da));
        MekanismTools.addSmeltingRecipe(ToolsItem.GOLD_PAXEL, new ItemStack(Items.field_151074_bl));
        MekanismTools.addSmeltingRecipe(ToolsItem.OBSIDIAN_SET, new ItemStack(MekanismItems.Nugget));
        MekanismTools.addSmeltingRecipe(ToolsItem.OSMIUM_SET, new ItemStack(MekanismItems.Nugget, 1, 1));
        MekanismTools.addSmeltingRecipe(ToolsItem.BRONZE_SET, new ItemStack(MekanismItems.Nugget, 1, 2));
        MekanismTools.addSmeltingRecipe(ToolsItem.GLOWSTONE_SET, new ItemStack(MekanismItems.Nugget, 1, 3));
        MekanismTools.addSmeltingRecipe(ToolsItem.STEEL_SET, new ItemStack(MekanismItems.Nugget, 1, 4));
    }

    private static void addSmeltingRecipe(List<ToolsItem> itemSet, ItemStack nugget) {
        itemSet.forEach(toolsItem -> MekanismTools.addSmeltingRecipe(toolsItem, nugget));
    }

    private static void addSmeltingRecipe(ToolsItem toolsItem, ItemStack nugget) {
        GameRegistry.addSmelting((ItemStack)toolsItem.getItemStackAnyDamage(), (ItemStack)nugget, (float)0.1f);
    }

    private void setStackIfEmpty(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack item) {
        if (entity.func_184582_a(slot).func_190926_b()) {
            entity.func_184201_a(slot, item);
        }
    }

    private void setEntityArmorWithChance(Random random, EntityLivingBase entity, ToolsItem sword, ToolsItem helmet, ToolsItem chestplate, ToolsItem leggings, ToolsItem boots) {
        if (entity instanceof EntityZombie && random.nextInt(100) < 50) {
            this.setStackIfEmpty(entity, EntityEquipmentSlot.MAINHAND, sword.getItemStack());
        }
        if (random.nextInt(100) < 50) {
            this.setStackIfEmpty(entity, EntityEquipmentSlot.HEAD, helmet.getItemStack());
        }
        if (random.nextInt(100) < 50) {
            this.setStackIfEmpty(entity, EntityEquipmentSlot.CHEST, chestplate.getItemStack());
        }
        if (random.nextInt(100) < 50) {
            this.setStackIfEmpty(entity, EntityEquipmentSlot.LEGS, leggings.getItemStack());
        }
        if (random.nextInt(100) < 50) {
            this.setStackIfEmpty(entity, EntityEquipmentSlot.FEET, boots.getItemStack());
        }
    }

    @SubscribeEvent
    public void onLivingSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        Random random;
        double chance;
        EntityLivingBase entity = event.getEntityLiving();
        if ((entity instanceof EntityZombie || entity instanceof EntitySkeleton) && (chance = (random = event.getWorld().field_73012_v).nextDouble()) < MekanismConfig.current().tools.armorSpawnRate.val()) {
            int armorType = random.nextInt(4);
            if (armorType == 0) {
                this.setEntityArmorWithChance(random, entity, ToolsItem.GLOWSTONE_SWORD, ToolsItem.GLOWSTONE_HELMET, ToolsItem.GLOWSTONE_CHESTPLATE, ToolsItem.GLOWSTONE_LEGGINGS, ToolsItem.GLOWSTONE_BOOTS);
            } else if (armorType == 1) {
                this.setEntityArmorWithChance(random, entity, ToolsItem.LAPIS_LAZULI_SWORD, ToolsItem.LAPIS_LAZULI_HELMET, ToolsItem.LAPIS_LAZULI_CHESTPLATE, ToolsItem.LAPIS_LAZULI_LEGGINGS, ToolsItem.LAPIS_LAZULI_BOOTS);
            } else if (armorType == 2) {
                this.setEntityArmorWithChance(random, entity, ToolsItem.OBSIDIAN_SWORD, ToolsItem.OBSIDIAN_HELMET, ToolsItem.OBSIDIAN_CHESTPLATE, ToolsItem.OBSIDIAN_LEGGINGS, ToolsItem.OBSIDIAN_BOOTS);
            } else if (armorType == 3) {
                this.setEntityArmorWithChance(random, entity, ToolsItem.STEEL_SWORD, ToolsItem.STEEL_HELMET, ToolsItem.STEEL_CHESTPLATE, ToolsItem.STEEL_LEGGINGS, ToolsItem.STEEL_BOOTS);
            } else if (armorType == 4) {
                this.setEntityArmorWithChance(random, entity, ToolsItem.BRONZE_SWORD, ToolsItem.BRONZE_HELMET, ToolsItem.BRONZE_CHESTPLATE, ToolsItem.BRONZE_LEGGINGS, ToolsItem.BRONZE_BOOTS);
            }
        }
    }

    public Version getVersion() {
        return versionNumber;
    }

    public String getName() {
        return "Tools";
    }

    public void writeConfig(ByteBuf dataStream, MekanismConfig config) {
        config.tools.write(dataStream);
    }

    public void readConfig(ByteBuf dataStream, MekanismConfig destConfig) {
        destConfig.tools.read(dataStream);
    }

    public void resetClient() {
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID) || event.getModID().equalsIgnoreCase("mekanism")) {
            proxy.loadConfiguration();
        }
    }

    static {
        versionNumber = new Version(999, 999, 999);
    }
}

