/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands.requirements;

import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.interaction.commands.RequirementTagResolver;
import me.rockyhawk.commandpanels.session.Panel;
import net.kyori.adventure.audience.Audience;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultTag
implements RequirementTagResolver {
    private final Economy economy;

    public VaultTag() {
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.economy = null;
            return;
        }
        RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        this.economy = rsp != null ? (Economy)rsp.getProvider() : null;
    }

    @Override
    public boolean isCorrectTag(String tag) {
        return tag.equalsIgnoreCase("[vault]");
    }

    @Override
    public boolean check(Context ctx, Panel panel, Player player, String raw, String args) {
        if (this.economy == null) {
            return false;
        }
        Double amount = this.parseAmount(ctx, player, args);
        return amount != null && this.economy.has((OfflinePlayer)player, amount.doubleValue());
    }

    @Override
    public void execute(Context ctx, Panel panel, Player player, String raw, String args) {
        if (this.economy == null) {
            return;
        }
        Double amount = this.parseAmount(ctx, player, args);
        if (amount == null) {
            return;
        }
        this.economy.withdrawPlayer((OfflinePlayer)player, amount.doubleValue());
    }

    private Double parseAmount(Context ctx, Player player, String args) {
        try {
            return Double.parseDouble(args);
        }
        catch (NumberFormatException e) {
            ctx.text.sendError((Audience)player, Message.REQUIREMENT_ECONOMY_INVALID, args);
            return null;
        }
    }
}

