/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.inventory;

import io.papermc.paper.persistence.PersistentDataContainerView;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.inventory.InventoryPanelBuilder;
import me.rockyhawk.commandpanels.builder.inventory.items.ItemBuilder;
import me.rockyhawk.commandpanels.session.inventory.InventoryPanel;
import me.rockyhawk.commandpanels.session.inventory.PanelItem;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InventoryPanelUpdater {
    private ScheduledTask checkTask;
    private ScheduledTask updateTask;

    public void start(Context ctx, Player p, InventoryPanel panel) {
        this.stop();
        int updateDelay = 20;
        if (panel.getUpdateDelay().matches("\\d+")) {
            updateDelay = Integer.parseInt(panel.getUpdateDelay());
        }
        if (updateDelay == 0) {
            this.updateTask = null;
            return;
        }
        InventoryPanelBuilder panelBuilder = new InventoryPanelBuilder(ctx, p);
        ItemBuilder builder = new ItemBuilder(ctx, panelBuilder);
        this.updateTask = Bukkit.getRegionScheduler().runAtFixedRate((Plugin)ctx.plugin, p.getLocation(), scheduledTask -> {
            Inventory inv = p.getOpenInventory().getTopInventory();
            InventoryHolder holder = inv.getHolder();
            if (!(holder instanceof InventoryPanel) || holder != panel) {
                this.stop();
                return;
            }
            NamespacedKey itemIdKey = new NamespacedKey((Plugin)ctx.plugin, "item_id");
            NamespacedKey baseIdKey = new NamespacedKey((Plugin)ctx.plugin, "base_item_id");
            NamespacedKey fillItem = new NamespacedKey((Plugin)ctx.plugin, "fill_item");
            for (int slot = 0; slot < inv.getSize(); ++slot) {
                PersistentDataContainerView container;
                ItemStack item = inv.getItem(slot);
                if (item == null || item.getType().isAir() || !(container = item.getPersistentDataContainer()).has(itemIdKey, PersistentDataType.STRING) || container.has(fillItem, PersistentDataType.STRING)) continue;
                String itemId = (String)container.get(itemIdKey, PersistentDataType.STRING);
                String baseItemId = (String)container.get(baseIdKey, PersistentDataType.STRING);
                PanelItem panelItem = panel.getItems().get(itemId);
                if (!panelItem.animate().isEmpty()) {
                    PanelItem animateItem = panel.getItems().get(panelItem.animate());
                    if (animateItem != null) {
                        panelItem = animateItem;
                    }
                } else if (!baseItemId.equals(itemId)) {
                    panelItem = panel.getItems().get(baseItemId);
                }
                ItemStack newItem = builder.buildItem(panel, panelItem);
                newItem.editPersistentDataContainer(c -> c.set(baseIdKey, PersistentDataType.STRING, (Object)baseItemId));
                inv.setItem(slot, newItem);
            }
        }, (long)updateDelay, (long)updateDelay);
        this.checkTask = Bukkit.getRegionScheduler().runAtFixedRate((Plugin)ctx.plugin, p.getLocation(), scheduledTask -> {
            Inventory inv = p.getOpenInventory().getTopInventory();
            InventoryHolder holder = inv.getHolder();
            if (!(holder instanceof InventoryPanel) || holder != panel) {
                this.stop();
            }
        }, 2L, 2L);
    }

    public void stop() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
            this.checkTask = null;
        }
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
    }
}

