/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.inventory.listeners;

import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.interaction.commands.CommandRunner;
import me.rockyhawk.commandpanels.interaction.commands.RequirementRunner;
import me.rockyhawk.commandpanels.session.ClickActions;
import me.rockyhawk.commandpanels.session.inventory.InventoryPanel;
import me.rockyhawk.commandpanels.session.inventory.PanelItem;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ClickEvents
implements Listener {
    private final Context ctx;
    public CommandRunner commands;
    public RequirementRunner requirements;

    public ClickEvents(Context ctx) {
        this.ctx = ctx;
        this.commands = new CommandRunner(ctx);
        this.requirements = new RequirementRunner(ctx);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        NamespacedKey baseIdKey;
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (e.getClickedInventory() == null) {
            return;
        }
        InventoryHolder inventoryHolder = e.getClickedInventory().getHolder();
        if (!(inventoryHolder instanceof InventoryPanel)) {
            return;
        }
        InventoryPanel panel = (InventoryPanel)inventoryHolder;
        ItemStack item = e.getCurrentItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!container.has(baseIdKey = new NamespacedKey((Plugin)this.ctx.plugin, "base_item_id"), PersistentDataType.STRING)) {
            return;
        }
        e.setCancelled(true);
        e.setResult(Event.Result.DENY);
        String itemId = (String)container.get(baseIdKey, PersistentDataType.STRING);
        switch (e.getClick()) {
            case LEFT: 
            case RIGHT: 
            case MIDDLE: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: {
                PanelItem panelItem = panel.getItems().get(itemId);
                ClickActions actions = panelItem.getClickActions(e.getClick());
                if (!this.requirements.processRequirements(panel, player, actions.requirements())) {
                    this.commands.runCommands(panel, player, actions.fail());
                    return;
                }
                this.commands.runCommands(panel, player, actions.commands());
                break;
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Inventory topInventory = event.getView().getTopInventory();
        if (!(topInventory.getHolder() instanceof InventoryPanel)) {
            return;
        }
        int topSize = topInventory.getSize();
        boolean draggingOverPanelItem = event.getRawSlots().stream().filter(slot -> slot < topSize).anyMatch(slot -> {
            ItemStack item = topInventory.getItem(slot.intValue());
            if (item == null || !item.hasItemMeta()) {
                return false;
            }
            ItemMeta meta = item.getItemMeta();
            return meta.getPersistentDataContainer().has(new NamespacedKey((Plugin)this.ctx.plugin, "item_id"), PersistentDataType.STRING);
        });
        if (draggingOverPanelItem) {
            event.setCancelled(true);
        }
    }
}

