/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels;

import java.io.File;
import java.util.HashMap;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.libs.bstats.bukkit.Metrics;
import me.rockyhawk.commandpanels.libs.bstats.charts.SingleLineChart;
import me.rockyhawk.commandpanels.session.Panel;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.java.JavaPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandPanels
extends JavaPlugin {
    public File folder = new File(String.valueOf(this.getDataFolder()) + File.separator + "panels");
    public HashMap<String, Panel> panels = new HashMap();
    public Context ctx;
    private static final Logger logger = LoggerFactory.getLogger(CommandPanels.class);

    public void onEnable() {
        Bukkit.getConsoleSender().sendMessage("[CommandPanels] RockyHawk's CommandPanels v" + this.getPluginMeta().getVersion() + " Plugin Loading...");
        try {
            this.registerPermissions();
            this.ctx = new Context(this);
            Metrics metrics = new Metrics(this, 5097);
            metrics.addCustomChart(new SingleLineChart("panels_amount", () -> this.panels.size()));
            Bukkit.getConsoleSender().sendMessage("[CommandPanels] RockyHawk's CommandPanels v" + this.getPluginMeta().getVersion() + " Plugin Loaded!");
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage("[CommandPanels] Failed to load plugin: " + e.getMessage());
            logger.error("Plugin loading failed with exception", (Throwable)e);
            this.ctx = null;
        }
    }

    public void onDisable() {
        if (this.ctx == null) {
            Bukkit.getConsoleSender().sendMessage("[CommandPanels] RockyHawk's CommandPanels Plugin Disabled (initialization failed).");
            return;
        }
        try {
            this.ctx.dataLoader.saveDataFileSync();
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage("[CommandPanels] Error during CommandPanels disable: " + e.getMessage());
        }
        Bukkit.getConsoleSender().sendMessage("[CommandPanels] RockyHawk's CommandPanels Plugin Disabled, aww man.");
    }

    private void registerPermissions() {
        this.addPermission("commandpanels.command", PermissionDefault.TRUE);
        this.addPermission("commandpanels.command.reload", PermissionDefault.OP);
        this.addPermission("commandpanels.command.generate", PermissionDefault.OP);
        this.addPermission("commandpanels.command.version", PermissionDefault.TRUE);
        this.addPermission("commandpanels.command.data", PermissionDefault.OP);
        this.addPermission("commandpanels.command.open", PermissionDefault.OP);
        this.addPermission("commandpanels.command.open.other", PermissionDefault.OP);
        this.addPermission("commandpanels.command.help", PermissionDefault.TRUE);
        this.addPermission("commandpanels.command.convert", PermissionDefault.OP);
    }

    private void addPermission(String name, PermissionDefault defaultValue) {
        Permission permission = new Permission(name, defaultValue);
        if (this.getServer().getPluginManager().getPermission(name) == null) {
            this.getServer().getPluginManager().addPermission(permission);
        }
    }
}

