/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class Converter {
    private final Context ctx;

    public Converter(Context ctx) {
        this.ctx = ctx;
    }

    public void convertPanels(CommandSender sender) {
        File oldPanelsDir = new File(this.ctx.plugin.getDataFolder(), "old_panels");
        if (!oldPanelsDir.exists()) {
            this.ctx.text.sendError((Audience)sender, Message.CONVERT_PANEL_CONFIG, new Object[0]);
            this.ctx.text.sendError((Audience)sender, Message.CONVERT_OLD_DIR_NOT_FOUND, oldPanelsDir.getPath());
            return;
        }
        File[] files = oldPanelsDir.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null || files.length == 0) {
            this.ctx.text.sendInfo((Audience)sender, Message.CONVERT_NO_OLD_FILES, new Object[0]);
            return;
        }
        for (File file : files) {
            try {
                YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)file);
                ConfigurationSection panelsSection = oldConfig.getConfigurationSection("panels");
                if (panelsSection == null) {
                    this.ctx.text.sendError((Audience)sender, Message.CONVERT_NO_PANELS_SECTION, file.getName());
                    continue;
                }
                for (String panelName : panelsSection.getKeys(false)) {
                    ConfigurationSection oldPanel = panelsSection.getConfigurationSection(panelName);
                    if (oldPanel == null) continue;
                    Map<String, Object> newPanel = this.convertPanel(panelName, oldPanel);
                    File outFile = new File(this.ctx.plugin.folder, panelName + ".yml");
                    YamlConfiguration newYaml = new YamlConfiguration();
                    for (Map.Entry<String, Object> entry : newPanel.entrySet()) {
                        newYaml.set(entry.getKey(), entry.getValue());
                    }
                    newYaml.save(outFile);
                    this.ctx.text.sendInfo((Audience)sender, Message.CONVERT_SUCCESS, panelName, outFile.getName());
                }
            }
            catch (IOException ex) {
                this.ctx.text.sendError((Audience)sender, Message.CONVERT_FILE_FAILED, file.getName());
            }
        }
    }

    private Map<String, Object> convertPanel(String panelName, ConfigurationSection oldPanel) {
        ConfigurationSection itemSection;
        ConfigurationSection customItems;
        LinkedHashMap<String, Object> newPanel = new LinkedHashMap<String, Object>();
        newPanel.put("title", oldPanel.getString("title", "&fPanel"));
        newPanel.put("type", "inventory");
        newPanel.put("rows", oldPanel.getInt("rows", 6));
        List openCommands = oldPanel.getStringList("commands-on-open");
        List baseCommands = oldPanel.getStringList("commands");
        String newOpenCommand = null;
        if (!baseCommands.isEmpty()) {
            newOpenCommand = (String)baseCommands.getFirst();
        }
        ArrayList newOpenCommands = new ArrayList(openCommands);
        newPanel.put("command", newOpenCommand);
        newPanel.put("commands", newOpenCommands);
        LinkedHashMap<String, ArrayList<Object>> layout = new LinkedHashMap<String, ArrayList<Object>>();
        LinkedHashMap<Object, Object> items = new LinkedHashMap<Object, Object>();
        if (oldPanel.isConfigurationSection("custom-item") && (customItems = oldPanel.getConfigurationSection("custom-item")) != null) {
            for (String itemKey : customItems.getKeys(false)) {
                items.put(itemKey, this.convertItem(customItems.getConfigurationSection(itemKey)));
            }
        }
        if ((itemSection = oldPanel.getConfigurationSection("item")) != null) {
            for (String slotKey : itemSection.getKeys(false)) {
                List<Map<String, Object>> logicVariants;
                List cmds;
                ConfigurationSection itemConfig = itemSection.getConfigurationSection(slotKey);
                String itemId = panelName + "_slot_" + slotKey;
                Map<String, Object> convertedItem = this.convertItem(itemConfig);
                if (itemConfig != null && (itemConfig.contains("commands") || this.hasNestedConditions(itemConfig)) && !(cmds = itemConfig.getStringList("commands")).isEmpty()) {
                    HashMap leftClick = new HashMap();
                    ArrayList<String> cmdList = new ArrayList<String>();
                    for (String cmd : cmds) {
                        cmdList.add(this.commandTagConverter(cmd));
                    }
                    leftClick.put("commands", cmdList);
                    convertedItem.put("actions", leftClick);
                }
                if (!(logicVariants = this.extractConditionVariants(itemConfig)).isEmpty()) {
                    items.put(itemId + "_base", convertedItem);
                    layout.put(slotKey, new ArrayList<CallSite>(Collections.singletonList(itemId + "_base")));
                    int i = 0;
                    for (Map<String, Object> variant : logicVariants) {
                        String variantId = itemId + "_cond_" + i;
                        items.put(variantId, variant);
                        ((List)layout.get(slotKey)).addFirst(variantId);
                        ++i;
                    }
                    continue;
                }
                items.put(itemId, convertedItem);
                layout.put(slotKey, new ArrayList<CallSite>(Collections.singletonList(itemId)));
            }
        }
        if (oldPanel.contains("empty")) {
            layout.put("fill", new ArrayList<String>(Collections.singletonList("empty_item")));
            items.put("empty_item.material", oldPanel.getString("empty"));
        }
        newPanel.put("layout", layout);
        newPanel.put("items", items);
        return newPanel;
    }

    private Map<String, Object> convertItem(ConfigurationSection itemConfig) {
        LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
        if (itemConfig == null) {
            return item;
        }
        block14: for (String key : itemConfig.getKeys(false)) {
            Object value = itemConfig.get(key);
            switch (key) {
                case "commands": {
                    continue block14;
                }
                case "name": 
                case "material": 
                case "lore": 
                case "enchanted": 
                case "damage": 
                case "stack": 
                case "leatherarmor": {
                    item.put(key, value);
                    continue block14;
                }
            }
            if (key.startsWith("has")) continue;
            item.put(key, value);
        }
        return item;
    }

    private String commandTagConverter(String command) {
        command = command.replace("server=", "[server]");
        command = command.replace("open=", "[open]");
        command = command.replace("cpc", "[close]");
        command = command.replace("console=", "[console]");
        command = command.replace("refresh", "[refresh]");
        command = command.replace("data=", "[data]");
        command = command.replace("msg=", "[msg]");
        command = command.replace("teleport=", "[teleport]");
        return command;
    }

    private boolean hasNestedConditions(ConfigurationSection itemConfig) {
        for (String key : itemConfig.getKeys(false)) {
            if (!key.startsWith("has")) continue;
            return true;
        }
        return false;
    }

    private List<Map<String, Object>> extractConditionVariants(ConfigurationSection itemConfig) {
        ArrayList<Map<String, Object>> variants = new ArrayList<Map<String, Object>>();
        for (String key : itemConfig.getKeys(false)) {
            ConfigurationSection conditionSection;
            if (!key.startsWith("has") || (conditionSection = itemConfig.getConfigurationSection(key)) == null) continue;
            Map<String, Object> variant = this.convertItem(conditionSection);
            Object conditions = "";
            for (String subKey : conditionSection.getKeys(false)) {
                int index;
                String valueKey;
                if (!subKey.startsWith("compare") || !conditionSection.contains(valueKey = "value" + (index = Integer.parseInt(subKey.substring(7))))) continue;
                String compare = conditionSection.getString(subKey);
                String value = conditionSection.getString(valueKey);
                conditions = compare + " $EQUALS " + value;
                break;
            }
            if (!((String)conditions).isEmpty()) {
                variant.put("conditions", conditions);
            }
            variants.add(variant);
        }
        return variants;
    }
}

