/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.session.Panel;
import me.rockyhawk.commandpanels.session.dialog.DialogPanel;
import me.rockyhawk.commandpanels.session.floodgate.FloodgatePanel;
import me.rockyhawk.commandpanels.session.inventory.InventoryPanel;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class FileHandler {
    private final Context ctx;
    public YamlConfiguration config;

    public FileHandler(Context ctx) {
        this.ctx = ctx;
        this.updateConfigFiles();
        this.reloadPanels();
        this.createLangFile();
    }

    public String fileToName(File file) {
        String fileName = file.getName();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > 0) {
            fileName = fileName.substring(0, dotIndex);
        }
        return fileName;
    }

    public void reloadPanels() {
        if (!this.ctx.plugin.folder.exists()) {
            if (!this.ctx.plugin.folder.mkdirs()) {
                Bukkit.getScheduler().runTask((Plugin)this.ctx.plugin, () -> this.ctx.text.sendError((Audience)this.ctx.plugin.getServer().getConsoleSender(), Message.FILE_CREATE_PANELS_FAIL, new Object[0]));
                return;
            }
            this.createExamplePanels();
        }
        HashMap<String, Panel> panels = this.loadYamlFilesRecursively(this.ctx.plugin.folder);
        Bukkit.getScheduler().runTask((Plugin)this.ctx.plugin, () -> {
            this.ctx.plugin.panels.clear();
            this.ctx.plugin.panels.putAll(panels);
            this.ctx.panelCommand.populateCommands();
        });
    }

    private HashMap<String, Panel> loadYamlFilesRecursively(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return new HashMap<String, Panel>();
        }
        HashMap<String, Panel> loaded = new HashMap<String, Panel>();
        for (File file : files) {
            String panelName;
            if (file.isDirectory()) {
                loaded.putAll(this.loadYamlFilesRecursively(file));
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".yml") && !file.getName().endsWith(".yaml")) continue;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            String panelType = config.getString("type", "inventory").toLowerCase();
            if (panelType.equals("inventory")) {
                panelName = this.fileToName(file);
                loaded.put(panelName, new InventoryPanel(panelName, config));
            }
            if (panelType.equals("dialog")) {
                panelName = this.fileToName(file);
                loaded.put(panelName, new DialogPanel(panelName, config));
            }
            if (!panelType.equals("floodgate")) continue;
            panelName = this.fileToName(file);
            loaded.put(panelName, new FloodgatePanel(panelName, config));
        }
        return loaded;
    }

    private Reader getReaderFromStream(InputStream initialStream) throws IOException {
        int bytesRead;
        if (initialStream == null) {
            return new StringReader("Missing resource for this file!");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((bytesRead = initialStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, bytesRead);
        }
        buffer.flush();
        String content = buffer.toString(StandardCharsets.UTF_8);
        return new StringReader(content);
    }

    private void createExamplePanels() {
        try {
            YamlConfiguration inventoryFile = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("inventory.yml")));
            inventoryFile.save(new File(this.ctx.plugin.folder, "inventory.yml"));
            YamlConfiguration dialogFile = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("dialog.yml")));
            dialogFile.save(new File(this.ctx.plugin.folder, "dialog.yml"));
            YamlConfiguration floodgateSimpleFile = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("floodgate_simple.yml")));
            floodgateSimpleFile.save(new File(this.ctx.plugin.folder, "floodgate_simple.yml"));
            YamlConfiguration floodgateCustomFile = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("floodgate_custom.yml")));
            floodgateCustomFile.save(new File(this.ctx.plugin.folder, "floodgate_custom.yml"));
        }
        catch (IOException | NullPointerException e) {
            Bukkit.getScheduler().runTask((Plugin)this.ctx.plugin, () -> this.ctx.text.sendError((Audience)this.ctx.plugin.getServer().getConsoleSender(), Message.FILE_CREATE_EXAMPLE_FAIL, new Object[0]));
        }
    }

    private void createLangFile() {
        File messagesFile = new File(this.ctx.plugin.getDataFolder(), "lang.yml");
        if (messagesFile.exists()) {
            return;
        }
        YamlConfiguration messagesYaml = Message.toYaml();
        try {
            messagesYaml.save(messagesFile);
        }
        catch (IOException ex) {
            Bukkit.getScheduler().runTask((Plugin)this.ctx.plugin, () -> this.ctx.text.sendError((Audience)this.ctx.plugin.getServer().getConsoleSender(), Message.FILE_CREATE_LANG_FAIL, new Object[0]));
        }
    }

    public void updateConfigFiles() {
        this.config = YamlConfiguration.loadConfiguration((File)new File(this.ctx.plugin.getDataFolder(), "config.yml"));
        File configFile = new File(this.ctx.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            try {
                YamlConfiguration configFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("config.yml")));
                configFileConfiguration.save(configFile);
                this.config = YamlConfiguration.loadConfiguration((File)new File(this.ctx.plugin.getDataFolder(), "config.yml"));
            }
            catch (IOException var11) {
                Bukkit.getScheduler().runTask((Plugin)this.ctx.plugin, () -> this.ctx.text.sendError((Audience)this.ctx.plugin.getServer().getConsoleSender(), Message.FILE_CREATE_CONFIG_FAIL, new Object[0]));
            }
        } else {
            try {
                YamlConfiguration configFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("config.yml")));
                this.config.addDefaults((Configuration)configFileConfiguration);
                this.config.options().copyDefaults(true);
                this.config.save(new File(String.valueOf(this.ctx.plugin.getDataFolder()) + File.separator + "config.yml"));
            }
            catch (IOException var10) {
                Bukkit.getScheduler().runTask((Plugin)this.ctx.plugin, () -> this.ctx.text.sendError((Audience)this.ctx.plugin.getServer().getConsoleSender(), Message.FILE_UPDATE_CONFIG_FAIL, new Object[0]));
            }
        }
    }
}

