/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.commands.SubCommand;
import me.rockyhawk.commandpanels.commands.TabComplete;
import me.rockyhawk.commandpanels.commands.subcommands.ConvertCommand;
import me.rockyhawk.commandpanels.commands.subcommands.DataCommand;
import me.rockyhawk.commandpanels.commands.subcommands.GenerateCommand;
import me.rockyhawk.commandpanels.commands.subcommands.HelpCommand;
import me.rockyhawk.commandpanels.commands.subcommands.OpenCommand;
import me.rockyhawk.commandpanels.commands.subcommands.ReloadCommand;
import me.rockyhawk.commandpanels.commands.subcommands.VersionCommand;
import me.rockyhawk.commandpanels.formatter.language.Message;
import net.kyori.adventure.audience.Audience;
import org.jspecify.annotations.Nullable;

public class MainCommand
implements BasicCommand {
    private final Context ctx;
    private final Map<String, SubCommand> subCommands = new HashMap<String, SubCommand>();

    public MainCommand(Context ctx) {
        this.ctx = ctx;
        this.registerSubCommands();
    }

    private void registerSubCommands() {
        this.register(new ReloadCommand());
        this.register(new OpenCommand());
        this.register(new GenerateCommand());
        this.register(new HelpCommand());
        this.register(new VersionCommand());
        this.register(new DataCommand());
        this.register(new ConvertCommand());
    }

    private void register(SubCommand subCommand) {
        this.subCommands.put(subCommand.getName().toLowerCase(), subCommand);
    }

    public void execute(CommandSourceStack cmdStack, String[] args) {
        if (!cmdStack.getSender().hasPermission("commandpanels.command")) {
            this.ctx.text.sendError((Audience)cmdStack.getSender(), Message.COMMAND_NO_PERMISSION, new Object[0]);
            return;
        }
        if (args.length == 0) {
            this.ctx.text.sendError((Audience)cmdStack.getSender(), Message.COMMAND_SUBCOMMAND_HELP, new Object[0]);
            return;
        }
        SubCommand subCommand = this.subCommands.get(args[0].toLowerCase());
        if (subCommand == null) {
            this.ctx.text.sendError((Audience)cmdStack.getSender(), Message.COMMAND_UNKNOWN_SUBCOMMAND, new Object[0]);
            return;
        }
        if (subCommand.getPermission() != null && !subCommand.getPermission().isEmpty() && !cmdStack.getSender().hasPermission(subCommand.getPermission())) {
            this.ctx.text.sendError((Audience)cmdStack.getSender(), Message.COMMAND_NO_PERMISSION, new Object[0]);
            return;
        }
        String[] subArgs = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
        subCommand.execute(this.ctx, cmdStack.getSender(), subArgs);
    }

    public @Nullable String permission() {
        return "commandpanels.command";
    }

    public Collection<String> suggest(CommandSourceStack commandSourceStack, String[] args) {
        TabComplete suggestions = new TabComplete(this.ctx);
        return suggestions.onTabComplete(commandSourceStack.getSender(), args);
    }
}

