/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands;

import java.util.ArrayList;
import java.util.List;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.interaction.commands.RequirementTagResolver;
import me.rockyhawk.commandpanels.interaction.commands.requirements.ConditionTag;
import me.rockyhawk.commandpanels.interaction.commands.requirements.DataTag;
import me.rockyhawk.commandpanels.interaction.commands.requirements.ItemTag;
import me.rockyhawk.commandpanels.interaction.commands.requirements.VaultTag;
import me.rockyhawk.commandpanels.interaction.commands.requirements.XpTag;
import me.rockyhawk.commandpanels.session.Panel;
import net.kyori.adventure.audience.Audience;
import org.bukkit.entity.Player;

public class RequirementRunner {
    private final Context ctx;
    private final List<RequirementTagResolver> resolvers = new ArrayList<RequirementTagResolver>();

    public RequirementRunner(Context ctx) {
        this.ctx = ctx;
        this.registerResolvers();
    }

    private void registerResolvers() {
        this.resolvers.add(new ConditionTag());
        this.resolvers.add(new VaultTag());
        this.resolvers.add(new ItemTag());
        this.resolvers.add(new DataTag());
        this.resolvers.add(new XpTag());
    }

    public boolean processRequirements(Panel panel, Player player, List<String> requirements) {
        ArrayList<RequirementTagResolver> toExecute = new ArrayList<RequirementTagResolver>();
        ArrayList<String> argsList = new ArrayList<String>();
        ArrayList<String> argsParsedList = new ArrayList<String>();
        for (String requirement : requirements) {
            if (requirement.isEmpty()) continue;
            String[] parts = requirement.split("\\s+", 2);
            String tag = parts[0];
            String args = parts.length > 1 ? parts[1].trim() : "";
            String argsParsed = this.ctx.text.parseTextToString(player, args);
            boolean matched = false;
            for (RequirementTagResolver resolver : this.resolvers) {
                if (!resolver.isCorrectTag(tag)) continue;
                matched = true;
                if (!resolver.check(this.ctx, panel, player, args, argsParsed)) {
                    return false;
                }
                toExecute.add(resolver);
                argsList.add(args);
                argsParsedList.add(argsParsed);
                break;
            }
            if (matched) continue;
            this.ctx.text.sendError((Audience)player, Message.REQUIREMENT_UNKNOWN_TAG, new Object[0]);
            return false;
        }
        for (int i = 0; i < toExecute.size(); ++i) {
            ((RequirementTagResolver)toExecute.get(i)).execute(this.ctx, panel, player, (String)argsList.get(i), (String)argsParsedList.get(i));
        }
        return true;
    }
}

