/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session;

import java.util.List;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.logic.ConditionNode;
import me.rockyhawk.commandpanels.builder.logic.ConditionParser;
import me.rockyhawk.commandpanels.session.SessionManager;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public abstract class Panel {
    private final String name;
    private final String title;
    private final String conditions;
    private final String command;
    private final List<String> aliases;
    private final List<String> commands;
    private final String type;

    public Panel(String name, YamlConfiguration config) {
        this.name = name;
        this.conditions = config.getString("conditions", "");
        this.title = config.getString("title", "Panel");
        this.command = config.getString("command", "");
        this.aliases = config.getStringList("aliases");
        this.commands = config.getStringList("commands");
        this.type = config.getString("type", "inventory");
    }

    public boolean canOpen(Player player, Context ctx) {
        if (this.conditions.trim().isEmpty()) {
            return true;
        }
        try {
            ConditionNode node = new ConditionParser().parse(this.conditions);
            return node.evaluate(player, ctx);
        }
        catch (Exception e) {
            return false;
        }
    }

    public abstract void open(Context var1, Player var2, SessionManager.PanelOpenType var3);

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getCommand() {
        return this.command;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public String getTitle() {
        return this.title;
    }
}

