/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.inventory.generator.resolvers;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import me.rockyhawk.commandpanels.session.inventory.generator.ItemResolver;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class PotionResolver
implements ItemResolver {
    private static final Set<Material> POTION_MATERIALS = EnumSet.of(Material.POTION, Material.SPLASH_POTION, Material.LINGERING_POTION, Material.TIPPED_ARROW);

    @Override
    public void resolve(ItemStack item, Map<String, Object> itemData) {
        if (!POTION_MATERIALS.contains(item.getType())) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return;
        }
        PotionMeta meta = (PotionMeta)itemMeta;
        if (meta.getBasePotionType() != null) {
            itemData.put("potion", meta.getBasePotionType().name());
        }
        if (meta.hasColor()) {
            Color color = meta.getColor();
            itemData.put("potion-color", Map.of("r", color.getRed(), "g", color.getGreen(), "b", color.getBlue()));
        }
    }
}

