/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder.floodgate;

import java.util.ArrayList;
import java.util.List;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.floodgate.FloodgatePanelBuilder;
import me.rockyhawk.commandpanels.builder.logic.ConditionNode;
import me.rockyhawk.commandpanels.builder.logic.ConditionParser;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.interaction.commands.CommandRunner;
import me.rockyhawk.commandpanels.interaction.commands.RequirementRunner;
import me.rockyhawk.commandpanels.session.CommandActions;
import me.rockyhawk.commandpanels.session.floodgate.FloodgateComponent;
import me.rockyhawk.commandpanels.session.floodgate.FloodgatePanel;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateButton;
import net.kyori.adventure.audience.Audience;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;

public class SimpleForm {
    protected final Context ctx;
    protected final FloodgatePanelBuilder builder;

    public SimpleForm(Context ctx, FloodgatePanelBuilder builder) {
        this.ctx = ctx;
        this.builder = builder;
    }

    public void sendForm(FloodgatePanel panel) {
        Player p = this.builder.getPlayer();
        SimpleForm.Builder form = ((SimpleForm.Builder)org.geysermc.cumulus.form.SimpleForm.builder().title(this.ctx.text.parseTextToString(p, panel.getTitle()))).content(this.ctx.text.parseTextToString(p, panel.getSubtitle().replaceAll("\\\\n", "\n")));
        ArrayList<FloodgateButton> buttonList = new ArrayList<FloodgateButton>();
        block0: for (int i = 0; i < panel.getOrder().size(); ++i) {
            if (!panel.getOrder().containsKey(String.valueOf(i))) {
                this.ctx.text.sendError((Audience)p, Message.PANEL_LAYOUT_NUMBER_MISSING, new Object[0]);
                return;
            }
            List<String> componentIds = panel.getOrder().get(String.valueOf(i));
            for (String key : componentIds) {
                ConditionNode conditionNode;
                boolean result;
                FloodgateButton button;
                FloodgateComponent floodgateComponent = panel.getComponents().get(key);
                if (!(floodgateComponent instanceof FloodgateButton) || !(button = (FloodgateButton)floodgateComponent).getConditions().trim().isEmpty() && !(result = (conditionNode = new ConditionParser().parse(button.getConditions())).evaluate(p, panel, this.ctx))) continue;
                String buttonContent = this.ctx.text.parseTextToString(p, button.getName().replaceAll("\\\\n", "\n"));
                if (button.getIconTexture().isEmpty()) {
                    form.button(buttonContent);
                } else {
                    FormImage.Type type = FormImage.Type.valueOf((String)this.ctx.text.parseTextToString(p, button.getIconType()).toUpperCase());
                    String texture = this.ctx.text.parseTextToString(p, button.getIconTexture());
                    form.button(buttonContent, type, texture);
                }
                buttonList.add(button);
                continue block0;
            }
        }
        form.validResultHandler(response -> {
            int clickedButtonId = response.clickedButtonId();
            if (clickedButtonId >= buttonList.size()) {
                return;
            }
            CommandActions actions = ((FloodgateButton)buttonList.get(clickedButtonId)).getClickActions();
            CommandRunner commands = new CommandRunner(this.ctx);
            RequirementRunner requirements = new RequirementRunner(this.ctx);
            if (!requirements.processRequirements(panel, p, actions.requirements())) {
                commands.runCommands(panel, p, actions.fail());
                return;
            }
            commands.runCommands(panel, p, actions.commands());
        });
        FloodgateApi.getInstance().sendForm(p.getUniqueId(), (FormBuilder)form);
    }
}

