/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder.logic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.logic.ConditionNode;
import me.rockyhawk.commandpanels.session.Panel;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ComparisonNode
implements ConditionNode {
    private final String left;
    private final String operator;
    private final String right;

    public ComparisonNode(String left, String operator, String right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    @Override
    public boolean evaluate(Player player, Panel panel, Context ctx) {
        String parsedLeftRaw = ctx.text.parseTextToString(player, this.left).replaceAll("\\s+", "_");
        String parsedRightRaw = ctx.text.parseTextToString(player, this.right).replaceAll("\\s+", "_");
        String parsedLeft = ComparisonNode.toPlainText(parsedLeftRaw);
        String parsedRight = ComparisonNode.toPlainText(parsedRightRaw);
        switch (this.operator) {
            case "$EQUALS": {
                return parsedLeft.equalsIgnoreCase(parsedRight);
            }
            case "$ATLEAST": {
                Double leftValue = this.extractNumber(parsedLeft);
                Double rightValue = this.extractNumber(parsedRight);
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return leftValue >= rightValue;
            }
            case "$HASPERM": {
                Player p = Bukkit.getPlayer((String)parsedLeft);
                panel.addObservedPerm(parsedRight);
                if (p == null) {
                    return false;
                }
                return p.hasPermission(parsedRight);
            }
        }
        return false;
    }

    public static String toPlainText(String input) {
        try {
            if (input.contains("\u00a7")) {
                TextComponent legacyComp = LegacyComponentSerializer.legacySection().deserialize(input);
                return PlainTextComponentSerializer.plainText().serialize((Component)legacyComp);
            }
            Component miniComp = MiniMessage.miniMessage().deserialize((Object)input);
            return PlainTextComponentSerializer.plainText().serialize(miniComp);
        }
        catch (Exception exception) {
            return input;
        }
    }

    private Double extractNumber(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = Pattern.compile("-?\\d+(\\.\\d+)?").matcher(input);
        if (matcher.find()) {
            return Double.parseDouble(matcher.group());
        }
        return null;
    }
}

