/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import me.rockyhawk.commandpanels.Context;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TabComplete {
    private final Context ctx;

    public TabComplete(Context ctx) {
        this.ctx = ctx;
    }

    public Collection<String> onTabComplete(CommandSender sender, String[] args) {
        String action;
        if (!sender.hasPermission("commandpanels.command")) {
            return null;
        }
        ArrayList<String> output = new ArrayList<String>();
        if (args.length < 2) {
            if (sender.hasPermission("commandpanels.command.open")) {
                output.add("open");
            }
            if (sender.hasPermission("commandpanels.command.reload")) {
                output.add("reload");
            }
            if (sender.hasPermission("commandpanels.command.generate")) {
                output.add("generate");
            }
            if (sender.hasPermission("commandpanels.command.help")) {
                output.add("help");
            }
            if (sender.hasPermission("commandpanels.command.version")) {
                output.add("version");
            }
            if (sender.hasPermission("commandpanels.command.data")) {
                output.add("data");
            }
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("open") && sender.hasPermission("commandpanels.command.open")) {
                String prefix = args[1].toLowerCase();
                for (String panelName : this.ctx.plugin.panels.keySet()) {
                    if (!panelName.toLowerCase().contains(prefix)) continue;
                    output.add(panelName);
                }
            } else if (args[0].equalsIgnoreCase("data") && sender.hasPermission("commandpanels.command.data")) {
                output.addAll(Arrays.asList("get", "set", "overwrite", "math", "del", "clear"));
            }
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("open") && sender.hasPermission("commandpanels.command.open.other")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    output.add(player.getName());
                }
            } else if (args[0].equalsIgnoreCase("data") && sender.hasPermission("commandpanels.command.data")) {
                output.addAll(this.ctx.dataLoader.dataPlayers.getPlayerNames());
            }
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("data") && sender.hasPermission("commandpanels.command.data")) {
            action = args[1].toLowerCase();
            if (Arrays.asList("get", "set", "overwrite", "math", "del").contains(action)) {
                output.add("<key>");
            }
        }
        if (args.length == 5 && args[0].equalsIgnoreCase("data") && sender.hasPermission("commandpanels.command.data")) {
            action = args[1].toLowerCase();
            if (Arrays.asList("set", "overwrite", "math").contains(action)) {
                output.add("<value_or_expression>");
            }
        }
        return output;
    }
}

