/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session;

import java.util.ArrayList;
import java.util.List;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.logic.ConditionNode;
import me.rockyhawk.commandpanels.builder.logic.ConditionParser;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.session.CommandActions;
import me.rockyhawk.commandpanels.session.inventory.InventoryPanel;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public abstract class Panel {
    private final String name;
    private final String title;
    private final String conditions;
    private final List<String> observedPerms;
    private final String command;
    private final List<String> aliases;
    private final List<String> commands;
    private final CommandActions open;
    private final String type;

    public Panel(String name, YamlConfiguration config) {
        this.name = name;
        this.conditions = config.getString("conditions", "");
        this.title = config.getString("title", "Panel");
        this.command = config.getString("command", "");
        this.aliases = config.getStringList("aliases");
        this.commands = config.getStringList("commands");
        this.type = config.getString("type", "inventory");
        this.observedPerms = new ArrayList<String>();
        this.open = new CommandActions(config.getStringList("open.requirements"), config.getStringList("open.commands"), config.getStringList("open.fail"));
    }

    public boolean passesConditions(Player player, Context ctx) {
        if (this.conditions.trim().isEmpty()) {
            return true;
        }
        try {
            ConditionNode node = new ConditionParser().parse(this.conditions);
            return node.evaluate(player, this, ctx);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean canOpen(Player p, Context ctx) {
        InventoryPanel panel;
        NamespacedKey keyTime = new NamespacedKey((Plugin)ctx.plugin, "last_open_time");
        Long lastOpenTime = (Long)p.getPersistentDataContainer().get(keyTime, PersistentDataType.LONG);
        long cooldownMillis = ctx.fileHandler.config.getLong("cooldown-ticks") * 50L;
        if (lastOpenTime != null && System.currentTimeMillis() - lastOpenTime < cooldownMillis) {
            ctx.text.sendError((Audience)p, Message.COOLDOWN_ERROR, new Object[0]);
            return false;
        }
        InventoryHolder inventoryHolder = p.getOpenInventory().getTopInventory().getHolder();
        return !(inventoryHolder instanceof InventoryPanel) || !(panel = (InventoryPanel)inventoryHolder).getName().equals(this.getName());
    }

    public void updatePanelData(Context ctx, Player p) {
        NamespacedKey keyCurrent = new NamespacedKey((Plugin)ctx.plugin, "current");
        NamespacedKey keyPrevious = new NamespacedKey((Plugin)ctx.plugin, "previous");
        NamespacedKey keyMillis = new NamespacedKey((Plugin)ctx.plugin, "last_open_time");
        PersistentDataContainer container = p.getPersistentDataContainer();
        container.set(keyMillis, PersistentDataType.LONG, (Object)System.currentTimeMillis());
        String current = (String)container.get(keyCurrent, PersistentDataType.STRING);
        current = current != null ? current : "";
        container.set(keyPrevious, PersistentDataType.STRING, (Object)current);
        container.set(keyCurrent, PersistentDataType.STRING, (Object)this.name);
        if (ctx.fileHandler.config.getBoolean("panel-snooper")) {
            ctx.text.sendInfo((Audience)Bukkit.getConsoleSender(), Message.PANEL_OPEN_LOG, p.getName(), this.name);
        }
    }

    public abstract void open(Context var1, Player var2, boolean var3);

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getCommand() {
        return this.command;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public CommandActions getOpenCommands() {
        return this.open;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getObservedPerms() {
        return this.observedPerms;
    }

    public void addObservedPerm(String node) {
        this.observedPerms.add(node);
    }
}

