/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.dialog;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.PanelBuilder;
import me.rockyhawk.commandpanels.builder.dialog.DialogPanelBuilder;
import me.rockyhawk.commandpanels.interaction.commands.CommandRunner;
import me.rockyhawk.commandpanels.interaction.commands.RequirementRunner;
import me.rockyhawk.commandpanels.session.CommandActions;
import me.rockyhawk.commandpanels.session.Panel;
import me.rockyhawk.commandpanels.session.dialog.DialogComponent;
import me.rockyhawk.commandpanels.session.floodgate.FloodgatePanel;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.geysermc.floodgate.api.FloodgateApi;

public class DialogPanel
extends Panel {
    private final String columns;
    private final String escapable;
    private final String exitButton;
    private final String floodgate;
    private final Map<String, DialogComponent> components = new HashMap<String, DialogComponent>();
    private final Map<String, List<String>> order = new HashMap<String, List<String>>();

    public DialogPanel(String name, YamlConfiguration config) {
        super(name, config);
        ConfigurationSection componentSection;
        this.floodgate = config.getString("floodgate", "");
        this.columns = config.getString("columns", "1");
        this.escapable = config.getString("escapable", "true");
        this.exitButton = config.getString("has-exit-button", "false");
        ConfigurationSection order = config.getConfigurationSection("layout");
        if (order != null) {
            for (String key : order.getKeys(false)) {
                this.order.put(key, order.getStringList(key));
            }
        }
        if ((componentSection = config.getConfigurationSection("items")) != null) {
            for (String key : componentSection.getKeys(false)) {
                DialogComponent component;
                ConfigurationSection configSection = componentSection.getConfigurationSection(key);
                if (configSection == null || (component = DialogComponent.fromSection(key, configSection)) == null) continue;
                this.components.put(component.getId(), component);
            }
        }
    }

    @Override
    public void open(Context ctx, Player player, boolean isNewPanelSession) {
        Panel panel = ctx.plugin.panels.get(this.floodgate);
        if (Bukkit.getPluginManager().getPlugin("floodgate") != null && panel instanceof FloodgatePanel) {
            FloodgatePanel floodgatePanel = (FloodgatePanel)panel;
            if (FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                floodgatePanel.open(ctx, player, true);
                return;
            }
        }
        if (isNewPanelSession) {
            if (!this.canOpen(player, ctx)) {
                return;
            }
            this.updatePanelData(ctx, player);
            CommandRunner runnerOld = new CommandRunner(ctx);
            if (!this.getCommands().isEmpty() && player.hasPermission("commandpanels.command.reload")) {
                player.sendMessage((Component)Component.text((String)"[CommandPanels] Commands is now deprecated, use new layout Open Commands instead.", (TextColor)NamedTextColor.RED));
            }
            runnerOld.runCommands(this, player, this.getCommands());
            RequirementRunner requirements = new RequirementRunner(ctx);
            CommandRunner commands = new CommandRunner(ctx);
            CommandActions actions = this.getOpenCommands();
            if (!requirements.processRequirements(this, player, actions.requirements())) {
                commands.runCommands(this, player, actions.fail());
                return;
            }
            commands.runCommands(this, player, actions.commands());
        }
        DialogPanelBuilder builder = new DialogPanelBuilder(ctx, player);
        ((PanelBuilder)builder).open(this);
    }

    public Map<String, DialogComponent> getComponents() {
        return this.components;
    }

    public Map<String, List<String>> getOrder() {
        return this.order;
    }

    public String getColumns() {
        return this.columns;
    }

    public String getEscapable() {
        return this.escapable;
    }

    public String getExitButton() {
        return this.exitButton;
    }
}

