/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.inventory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.PanelBuilder;
import me.rockyhawk.commandpanels.builder.inventory.InventoryPanelBuilder;
import me.rockyhawk.commandpanels.interaction.commands.CommandRunner;
import me.rockyhawk.commandpanels.interaction.commands.RequirementRunner;
import me.rockyhawk.commandpanels.session.CommandActions;
import me.rockyhawk.commandpanels.session.Panel;
import me.rockyhawk.commandpanels.session.floodgate.FloodgatePanel;
import me.rockyhawk.commandpanels.session.inventory.InventoryPanelUpdater;
import me.rockyhawk.commandpanels.session.inventory.PanelItem;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.geysermc.floodgate.api.FloodgateApi;

public class InventoryPanel
extends Panel
implements InventoryHolder {
    private final String rows;
    private final Map<String, PanelItem> items = new HashMap<String, PanelItem>();
    private final Map<String, List<String>> slots = new HashMap<String, List<String>>();
    private final CommandActions outside;
    private final CommandActions close;
    private final String floodgate;
    private final String inventoryLock;
    private final String updateDelay;

    public InventoryPanel(String name, YamlConfiguration config) {
        super(name, config);
        ConfigurationSection itemsSection;
        this.rows = config.getString("rows", "1");
        this.floodgate = config.getString("floodgate", "");
        this.updateDelay = config.getString("update-delay", "20");
        this.inventoryLock = config.getString("inventory-lock", "false");
        this.outside = new CommandActions(config.getStringList("outside.requirements"), config.getStringList("outside.commands"), config.getStringList("outside.fail"));
        this.close = new CommandActions(config.getStringList("close.requirements"), config.getStringList("close.commands"), config.getStringList("close.fail"));
        ConfigurationSection slotSection = config.getConfigurationSection("layout");
        if (slotSection != null) {
            for (String key : slotSection.getKeys(false)) {
                this.slots.put(key, slotSection.getStringList(key));
            }
        }
        if ((itemsSection = config.getConfigurationSection("items")) != null) {
            for (String key : itemsSection.getKeys(false)) {
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
                if (itemSection == null) continue;
                PanelItem item = PanelItem.fromSection(key, itemSection);
                this.items.put(itemSection.getName(), item);
            }
        }
    }

    @Override
    public void open(Context ctx, Player player, boolean isNewPanelSession) {
        Panel panel = ctx.plugin.panels.get(this.floodgate);
        if (Bukkit.getPluginManager().getPlugin("floodgate") != null && panel instanceof FloodgatePanel) {
            FloodgatePanel floodgatePanel = (FloodgatePanel)panel;
            if (FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                floodgatePanel.open(ctx, player, true);
                return;
            }
        }
        if (isNewPanelSession) {
            if (!this.canOpen(player, ctx)) {
                return;
            }
            this.updatePanelData(ctx, player);
            CommandRunner runnerOld = new CommandRunner(ctx);
            if (!this.getCommands().isEmpty() && player.hasPermission("commandpanels.command.reload")) {
                player.sendMessage((Component)Component.text((String)"[CommandPanels] Commands is now deprecated, use new layout Open Commands instead.", (TextColor)NamedTextColor.RED));
            }
            runnerOld.runCommands(this, player, this.getCommands());
            RequirementRunner requirements = new RequirementRunner(ctx);
            CommandRunner commands = new CommandRunner(ctx);
            CommandActions actions = this.getOpenCommands();
            if (!requirements.processRequirements(this, player, actions.requirements())) {
                commands.runCommands(this, player, actions.fail());
                return;
            }
            commands.runCommands(this, player, actions.commands());
        }
        InventoryPanelBuilder builder = new InventoryPanelBuilder(ctx, player);
        ((PanelBuilder)builder).open(this);
        if (isNewPanelSession) {
            InventoryPanelUpdater updater = new InventoryPanelUpdater();
            updater.start(ctx, player, this);
        }
    }

    public String getRows() {
        return this.rows;
    }

    public Map<String, PanelItem> getItems() {
        return this.items;
    }

    public Map<String, List<String>> getSlots() {
        return this.slots;
    }

    public String getUpdateDelay() {
        return this.updateDelay;
    }

    public CommandActions getOutsideCommands() {
        return this.outside;
    }

    public CommandActions getCloseCommands() {
        return this.close;
    }

    public String getInventoryLock() {
        return this.inventoryLock;
    }

    public Inventory getInventory() {
        return null;
    }
}

