/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands;

import java.util.ArrayList;
import java.util.List;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.interaction.commands.CommandTagResolver;
import me.rockyhawk.commandpanels.interaction.commands.tags.ChatTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.ClosePanelTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.ConsoleCmdTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.DataTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.GiveTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.GrantTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.ItemActionTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.MessageTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.OpenPanelTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.PreviousPanelTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.RefreshPanelTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.ServerTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.SessionTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.SoundTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.StopSoundTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.TeleportTag;
import me.rockyhawk.commandpanels.session.Panel;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandRunner {
    private final Context ctx;
    private final List<CommandTagResolver> resolvers = new ArrayList<CommandTagResolver>();

    public CommandRunner(Context pl) {
        this.ctx = pl;
        this.registerResolvers();
    }

    private void registerResolvers() {
        this.resolvers.add(new OpenPanelTag());
        this.resolvers.add(new RefreshPanelTag());
        this.resolvers.add(new PreviousPanelTag());
        this.resolvers.add(new ClosePanelTag());
        this.resolvers.add(new ConsoleCmdTag());
        this.resolvers.add(new SessionTag());
        this.resolvers.add(new DataTag());
        this.resolvers.add(new ChatTag());
        this.resolvers.add(new GrantTag());
        this.resolvers.add(new ServerTag());
        this.resolvers.add(new MessageTag());
        this.resolvers.add(new GiveTag());
        this.resolvers.add(new ItemActionTag());
        this.resolvers.add(new SoundTag());
        this.resolvers.add(new StopSoundTag());
        this.resolvers.add(new TeleportTag());
    }

    public void runCommands(Panel panel, Player player, List<String> commands) {
        this.runCommands(panel, player, commands, 0);
    }

    private void runCommands(Panel panel, Player player, List<String> commands, int index) {
        if (index >= commands.size()) {
            return;
        }
        String command = commands.get(index).trim();
        if (command.startsWith("[delay]")) {
            int ticks;
            String delayStr = this.ctx.text.applyPlaceholders(player, command.replace("[delay]", "").trim());
            try {
                ticks = Integer.parseInt(delayStr);
            }
            catch (NumberFormatException e) {
                ticks = 0;
            }
            int nextIndex = index + 1;
            Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.ctx.plugin, task -> this.runCommands(panel, player, commands, nextIndex), (long)ticks);
            return;
        }
        Bukkit.getGlobalRegionScheduler().run((Plugin)this.ctx.plugin, task -> this.runCommand(panel, player, command));
        this.runCommands(panel, player, commands, index + 1);
    }

    public void runCommand(Panel panel, Player player, String command) {
        for (CommandTagResolver resolver : this.resolvers) {
            if (command.isEmpty()) {
                return;
            }
            String[] parts = command.split("\\s+", 2);
            String tag = parts[0];
            String args = parts.length > 1 ? parts[1].trim() : "";
            String argsParsed = this.ctx.text.parseTextToString(player, args);
            if (!resolver.isCorrectTag(tag)) continue;
            resolver.handle(this.ctx, panel, player, args, argsParsed);
            return;
        }
    }
}

