/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.openpanel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.interaction.openpanel.CommandRegister;
import me.rockyhawk.commandpanels.session.Panel;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PanelOpenCommand
implements Listener {
    Context ctx;
    CommandRegister commandRegister;
    private final HashMap<String, List<Panel>> commands = new HashMap();

    public PanelOpenCommand(Context pl) {
        this.ctx = pl;
        this.commandRegister = new CommandRegister(this.ctx);
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent e) {
        String raw = e.getMessage().substring(1);
        String[] parts = raw.split("\\s+");
        String label = parts[0].toLowerCase(Locale.ROOT);
        String[] args = Arrays.copyOfRange(parts, 1, parts.length);
        List<Panel> panels = this.commands.get(label);
        if (panels == null || panels.isEmpty()) {
            return;
        }
        boolean hadMatch = false;
        for (Panel panel : panels) {
            String[] pnlParts;
            String[] pnlCmdArgs;
            if (panel == null || args.length != (pnlCmdArgs = Arrays.copyOfRange(pnlParts = panel.getCommand().split("\\s+"), 1, pnlParts.length)).length) continue;
            hadMatch = true;
            for (int i = 0; i < args.length; ++i) {
                String key = pnlCmdArgs[i];
                String value = args[i];
                e.getPlayer().getPersistentDataContainer().set(new NamespacedKey((Plugin)this.ctx.plugin, key), PersistentDataType.STRING, (Object)value);
            }
            if (!panel.passesConditions(e.getPlayer(), this.ctx)) continue;
            e.setCancelled(true);
            Bukkit.getGlobalRegionScheduler().run((Plugin)this.ctx.plugin, task -> panel.open(this.ctx, e.getPlayer(), true));
            return;
        }
        if (hadMatch) {
            this.ctx.text.sendError((Audience)e.getPlayer(), Message.COMMAND_NO_PERMISSION, new Object[0]);
        }
    }

    public void populateCommands() {
        this.commands.clear();
        for (Panel panel : this.ctx.plugin.panels.values()) {
            String command = panel.getCommand().split("\\s+")[0].toLowerCase(Locale.ROOT);
            if (command.isEmpty()) continue;
            this.commands.computeIfAbsent(command, k -> new ArrayList()).add(panel);
            if (this.ctx.fileHandler.config.getBoolean("custom-commands")) {
                this.commandRegister.registerPanelCommand(command);
            }
            if (panel.getAliases().isEmpty()) continue;
            for (String alias : panel.getAliases()) {
                alias = alias.split("\\s+")[0].toLowerCase(Locale.ROOT);
                this.commands.computeIfAbsent(alias, k -> new ArrayList()).add(panel);
                if (!this.ctx.fileHandler.config.getBoolean("custom-commands")) continue;
                this.commandRegister.registerPanelCommand(alias);
            }
        }
    }
}

