/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.inventory;

import java.util.List;
import me.rockyhawk.commandpanels.session.ClickActions;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.ClickType;

public record PanelItem(String id, String material, String stack, String displayName, List<String> lore, String attributes, String tooltip, String animate, String conditions, ClickActions actions, ClickActions leftClick, ClickActions rightClick, ClickActions middleClick, ClickActions shiftLeftClick, ClickActions shiftRightClick, String damage, String itemModel, String customModelData, String leatherColor, String armorTrim, String potionColor, String potion, String tooltipStyle, List<String> banner, List<String> enchantments) {
    public PanelItem(String id, String material, String stack, String displayName, List<String> lore, String attributes, String tooltip, String animate, String conditions, ClickActions actions, ClickActions leftClick, ClickActions rightClick, ClickActions middleClick, ClickActions shiftLeftClick, ClickActions shiftRightClick, String damage, String itemModel, String customModelData, String leatherColor, String armorTrim, String potionColor, String potion, String tooltipStyle, List<String> banner, List<String> enchantments) {
        this.id = id;
        this.material = material;
        this.stack = stack;
        this.displayName = displayName;
        this.lore = List.copyOf(lore);
        this.attributes = attributes;
        this.tooltip = tooltip;
        this.animate = animate;
        this.conditions = conditions;
        this.actions = actions;
        this.leftClick = leftClick;
        this.rightClick = rightClick;
        this.middleClick = middleClick;
        this.shiftLeftClick = shiftLeftClick;
        this.shiftRightClick = shiftRightClick;
        this.damage = damage;
        this.itemModel = itemModel;
        this.customModelData = customModelData;
        this.leatherColor = leatherColor;
        this.armorTrim = armorTrim;
        this.potionColor = potionColor;
        this.potion = potion;
        this.tooltipStyle = tooltipStyle;
        this.banner = List.copyOf(banner);
        this.enchantments = List.copyOf(enchantments);
    }

    public static PanelItem fromSection(String id, ConfigurationSection section) {
        String material = section.getString("material", "STONE");
        String stack = section.getString("stack", "1");
        String name = section.getString("name", "");
        List lore = section.getStringList("lore");
        String attributes = section.getString("attributes", "false");
        String tooltip = section.getString("tooltip", "true");
        String animate = section.getString("animate", "");
        String conditions = section.getString("conditions", "");
        ClickActions actions = ClickActions.fromSection(section.getConfigurationSection("actions"));
        ClickActions leftClick = ClickActions.fromSection(section.getConfigurationSection("left-click"));
        ClickActions rightClick = ClickActions.fromSection(section.getConfigurationSection("right-click"));
        ClickActions middleClick = ClickActions.fromSection(section.getConfigurationSection("middle-click"));
        ClickActions shiftLeftClick = ClickActions.fromSection(section.getConfigurationSection("shift-left-click"));
        ClickActions shiftRightClick = ClickActions.fromSection(section.getConfigurationSection("shift-right-click"));
        String damage = section.getString("damage", "0");
        String itemModel = section.getString("item-model", null);
        String customModelData = section.getString("custom-model-data", null);
        String leatherColor = section.getString("leather-color", null);
        String armorTrim = section.getString("armor-trim", null);
        String potionColor = section.getString("potion-color", null);
        String potion = section.getString("potion", null);
        String tooltipStyle = section.getString("tooltip-style", null);
        List banner = section.getStringList("banner");
        List enchanted = section.getStringList("enchantments");
        return new PanelItem(id, material, stack, name, lore, attributes, tooltip, animate, conditions, actions, leftClick, rightClick, middleClick, shiftLeftClick, shiftRightClick, damage, itemModel, customModelData, leatherColor, armorTrim, potionColor, potion, tooltipStyle, banner, enchanted);
    }

    public ClickActions getClickActions(ClickType clickType) {
        if (!this.actions.requirements().isEmpty() || !this.actions.commands().isEmpty()) {
            return this.actions;
        }
        return switch (clickType) {
            case ClickType.RIGHT -> this.rightClick;
            case ClickType.MIDDLE -> this.middleClick;
            case ClickType.SHIFT_LEFT -> this.shiftLeftClick;
            case ClickType.SHIFT_RIGHT -> this.shiftRightClick;
            default -> this.leftClick;
        };
    }
}

