/*
 * Decompiled with CFR 0.152.
 */
package com.plushycat.essentialsxtphook;

import com.earth2me.essentials.Essentials;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class essentialstphook
extends JavaPlugin
implements Listener {
    private Essentials essentials;
    private final Map<String, Long> activeRequests = new HashMap<String, Long>();
    private long REQUEST_EXPIRY_MS;

    public void onEnable() {
        this.saveDefaultConfig();
        this.essentials = (Essentials)Bukkit.getPluginManager().getPlugin("Essentials");
        if (this.essentials == null) {
            this.getLogger().severe("EssentialsX not found! This plugin is required.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        int expirySeconds = this.getConfig().getInt("expiry-delay", 120);
        this.REQUEST_EXPIRY_MS = (long)expirySeconds * 1000L;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("EssentialsXTP has been enabled and hooked into EssentialsX.");
    }

    public void onDisable() {
        this.getLogger().info("EssentialsXTP has been disabled.");
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String command = event.getMessage().toLowerCase();
        FileConfiguration config = this.getConfig();
        if (command.startsWith("/tpa ") || command.startsWith("/tpahere ")) {
            String[] args = command.split(" ");
            if (args.length < 2) {
                return;
            }
            Player target = Bukkit.getPlayerExact((String)args[1]);
            if (target == null || !target.isOnline()) {
                return;
            }
            String key = target.getName() + ":" + player.getName();
            this.activeRequests.put(key, System.currentTimeMillis() + this.REQUEST_EXPIRY_MS);
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                String msgKey = command.startsWith("/tpa ") ? "messages.target-request" : "messages.target-request-tpahere";
                String rawMsg = config.getString(msgKey, player.getName() + " has requested to teleport to you.");
                String formattedMsg = ChatColor.translateAlternateColorCodes((char)'&', (String)rawMsg.replace("{requester}", player.getName()).replace("{target}", target.getName()));
                TextComponent msg = new TextComponent(formattedMsg);
                target.spigot().sendMessage((BaseComponent)msg);
                this.playSound(target, config.getString("sounds.request"));
                TextComponent line = new TextComponent("\n");
                TextComponent accept = new TextComponent(ChatColor.GREEN + "[\u2714]");
                accept.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpaccept " + player.getName()));
                accept.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(config.getString("messages.accept-hover", "Accept teleport")).create()));
                TextComponent deny = new TextComponent(ChatColor.RED + "[\u2718]");
                deny.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpdeny " + player.getName()));
                deny.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(config.getString("messages.deny-hover", "Deny teleport")).create()));
                line.addExtra((BaseComponent)accept);
                line.addExtra(" ");
                line.addExtra((BaseComponent)deny);
                target.spigot().sendMessage((BaseComponent)line);
                String requesterMsgRaw = config.getString("messages.requester-notification", "You sent a teleport request to {target}.");
                String requesterMsg = ChatColor.translateAlternateColorCodes((char)'&', (String)requesterMsgRaw.replace("{target}", target.getName()).replace("{requester}", player.getName()));
                TextComponent cancelMsg = new TextComponent(requesterMsg + " ");
                TextComponent cancel = new TextComponent(ChatColor.RED + "[\u2718]");
                cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpacancel " + target.getName()));
                cancel.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(config.getString("messages.cancel-hover", "Cancel request")).create()));
                cancelMsg.addExtra((BaseComponent)cancel);
                player.spigot().sendMessage((BaseComponent)cancelMsg);
            }, 1L);
        } else if (command.startsWith("/tpaccept ")) {
            String[] args = command.split(" ");
            if (args.length < 2) {
                this.playSound(player, config.getString("sounds.accept"));
                return;
            }
            Player sender = Bukkit.getPlayerExact((String)args[1]);
            String key = player.getName() + ":" + args[1];
            if (!this.isRequestActive(key)) {
                this.sendExpiredFeedback(player, sender, config);
                return;
            }
            this.activeRequests.remove(key);
            if (sender != null && sender.isOnline()) {
                this.playSound(sender, config.getString("sounds.accept"));
            }
            this.playSound(player, config.getString("sounds.accept"));
        } else if (command.startsWith("/tpdeny ")) {
            String[] args = command.split(" ");
            if (args.length < 2) {
                this.playSound(player, config.getString("sounds.deny"));
                return;
            }
            Player sender = Bukkit.getPlayerExact((String)args[1]);
            String key = player.getName() + ":" + args[1];
            if (!this.isRequestActive(key)) {
                this.sendExpiredFeedback(player, sender, config);
                return;
            }
            this.activeRequests.remove(key);
            if (sender != null && sender.isOnline()) {
                this.playSound(sender, config.getString("sounds.deny"));
            }
            this.playSound(player, config.getString("sounds.deny"));
        } else if (command.startsWith("/tpacancel")) {
            Player target;
            String[] args = command.split(" ");
            String targetName = args.length > 1 ? args[1] : null;
            String key = targetName != null ? targetName + ":" + player.getName() : null;
            Player player2 = target = targetName != null ? Bukkit.getPlayerExact((String)targetName) : null;
            if (key == null || !this.isRequestActive(key)) {
                this.sendExpiredFeedback(player, target, config);
                return;
            }
            this.activeRequests.remove(key);
            this.playSound(player, config.getString("sounds.cancel"));
        }
    }

    private boolean isRequestActive(String key) {
        Long expiry = this.activeRequests.get(key);
        return expiry != null && System.currentTimeMillis() < expiry;
    }

    private void sendExpiredFeedback(Player receiver, Player sender, FileConfiguration config) {
        String expiredMsg = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.expired-request", "&cThis teleport request has expired."));
        this.playSound(receiver, config.getString("sounds.expired"));
        receiver.sendMessage(expiredMsg);
        if (sender != null && sender.isOnline()) {
            this.playSound(sender, config.getString("sounds.expired"));
            sender.sendMessage(expiredMsg);
        }
    }

    private void playSound(Player player, String soundName) {
        if (soundName == null || soundName.isEmpty()) {
            return;
        }
        try {
            Sound sound = Sound.valueOf((String)soundName);
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("Invalid sound name: " + soundName);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("essxtpreload")) {
            this.reloadConfig();
            sender.sendMessage(ChatColor.GREEN + "[EssentialsXTP] Config reloaded!");
            return true;
        }
        return false;
    }
}

